/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata related to a network operation.
 * </p>
 * <p>
 * A network operation is any operation that is done to your network, such as network instance instantiation or
 * termination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSolNetworkOperationsMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ListSolNetworkOperationsMetadata.Builder, ListSolNetworkOperationsMetadata> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(ListSolNetworkOperationsMetadata::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModified")
            .getter(getter(ListSolNetworkOperationsMetadata::lastModified))
            .setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NSD_INFO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdInfoId").getter(getter(ListSolNetworkOperationsMetadata::nsdInfoId))
            .setter(setter(Builder::nsdInfoId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdInfoId").build()).build();

    private static final SdkField<String> VNF_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfInstanceId").getter(getter(ListSolNetworkOperationsMetadata::vnfInstanceId))
            .setter(setter(Builder::vnfInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfInstanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            LAST_MODIFIED_FIELD, NSD_INFO_ID_FIELD, VNF_INSTANCE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final Instant lastModified;

    private final String nsdInfoId;

    private final String vnfInstanceId;

    private ListSolNetworkOperationsMetadata(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.lastModified = builder.lastModified;
        this.nsdInfoId = builder.nsdInfoId;
        this.vnfInstanceId = builder.vnfInstanceId;
    }

    /**
     * <p>
     * The date that the resource was created.
     * </p>
     * 
     * @return The date that the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date that the resource was last modified.
     * </p>
     * 
     * @return The date that the resource was last modified.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The network service descriptor id used for the operation.
     * </p>
     * <p>
     * Only present if the updateType is <code>UPDATE_NS</code>.
     * </p>
     * 
     * @return The network service descriptor id used for the operation.</p>
     *         <p>
     *         Only present if the updateType is <code>UPDATE_NS</code>.
     */
    public final String nsdInfoId() {
        return nsdInfoId;
    }

    /**
     * <p>
     * The network function id used for the operation.
     * </p>
     * <p>
     * Only present if the updateType is <code>MODIFY_VNF_INFO</code>.
     * </p>
     * 
     * @return The network function id used for the operation.</p>
     *         <p>
     *         Only present if the updateType is <code>MODIFY_VNF_INFO</code>.
     */
    public final String vnfInstanceId() {
        return vnfInstanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(nsdInfoId());
        hashCode = 31 * hashCode + Objects.hashCode(vnfInstanceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolNetworkOperationsMetadata)) {
            return false;
        }
        ListSolNetworkOperationsMetadata other = (ListSolNetworkOperationsMetadata) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastModified(), other.lastModified())
                && Objects.equals(nsdInfoId(), other.nsdInfoId()) && Objects.equals(vnfInstanceId(), other.vnfInstanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSolNetworkOperationsMetadata").add("CreatedAt", createdAt())
                .add("LastModified", lastModified()).add("NsdInfoId", nsdInfoId()).add("VnfInstanceId", vnfInstanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "nsdInfoId":
            return Optional.ofNullable(clazz.cast(nsdInfoId()));
        case "vnfInstanceId":
            return Optional.ofNullable(clazz.cast(vnfInstanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSolNetworkOperationsMetadata, T> g) {
        return obj -> g.apply((ListSolNetworkOperationsMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListSolNetworkOperationsMetadata> {
        /**
         * <p>
         * The date that the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date that the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date that the resource was last modified.
         * </p>
         * 
         * @param lastModified
         *        The date that the resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * The network service descriptor id used for the operation.
         * </p>
         * <p>
         * Only present if the updateType is <code>UPDATE_NS</code>.
         * </p>
         * 
         * @param nsdInfoId
         *        The network service descriptor id used for the operation.</p>
         *        <p>
         *        Only present if the updateType is <code>UPDATE_NS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdInfoId(String nsdInfoId);

        /**
         * <p>
         * The network function id used for the operation.
         * </p>
         * <p>
         * Only present if the updateType is <code>MODIFY_VNF_INFO</code>.
         * </p>
         * 
         * @param vnfInstanceId
         *        The network function id used for the operation.</p>
         *        <p>
         *        Only present if the updateType is <code>MODIFY_VNF_INFO</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfInstanceId(String vnfInstanceId);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private Instant lastModified;

        private String nsdInfoId;

        private String vnfInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolNetworkOperationsMetadata model) {
            createdAt(model.createdAt);
            lastModified(model.lastModified);
            nsdInfoId(model.nsdInfoId);
            vnfInstanceId(model.vnfInstanceId);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getNsdInfoId() {
            return nsdInfoId;
        }

        public final void setNsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
        }

        @Override
        public final Builder nsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
            return this;
        }

        public final String getVnfInstanceId() {
            return vnfInstanceId;
        }

        public final void setVnfInstanceId(String vnfInstanceId) {
            this.vnfInstanceId = vnfInstanceId;
        }

        @Override
        public final Builder vnfInstanceId(String vnfInstanceId) {
            this.vnfInstanceId = vnfInstanceId;
            return this;
        }

        @Override
        public ListSolNetworkOperationsMetadata build() {
            return new ListSolNetworkOperationsMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
