/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata related to the configuration properties used during update of a specific network function in a network
 * instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVnfInfoMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ModifyVnfInfoMetadata.Builder, ModifyVnfInfoMetadata> {
    private static final SdkField<Document> VNF_CONFIGURABLE_PROPERTIES_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT).memberName("vnfConfigurableProperties")
            .getter(getter(ModifyVnfInfoMetadata::vnfConfigurableProperties)).setter(setter(Builder::vnfConfigurableProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfConfigurableProperties").build())
            .build();

    private static final SdkField<String> VNF_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfInstanceId").getter(getter(ModifyVnfInfoMetadata::vnfInstanceId))
            .setter(setter(Builder::vnfInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfInstanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VNF_CONFIGURABLE_PROPERTIES_FIELD, VNF_INSTANCE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Document vnfConfigurableProperties;

    private final String vnfInstanceId;

    private ModifyVnfInfoMetadata(BuilderImpl builder) {
        this.vnfConfigurableProperties = builder.vnfConfigurableProperties;
        this.vnfInstanceId = builder.vnfInstanceId;
    }

    /**
     * <p>
     * The configurable properties used during update of the network function instance.
     * </p>
     * 
     * @return The configurable properties used during update of the network function instance.
     */
    public final Document vnfConfigurableProperties() {
        return vnfConfigurableProperties;
    }

    /**
     * <p>
     * The network function instance that was updated in the network instance.
     * </p>
     * 
     * @return The network function instance that was updated in the network instance.
     */
    public final String vnfInstanceId() {
        return vnfInstanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vnfConfigurableProperties());
        hashCode = 31 * hashCode + Objects.hashCode(vnfInstanceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVnfInfoMetadata)) {
            return false;
        }
        ModifyVnfInfoMetadata other = (ModifyVnfInfoMetadata) obj;
        return Objects.equals(vnfConfigurableProperties(), other.vnfConfigurableProperties())
                && Objects.equals(vnfInstanceId(), other.vnfInstanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVnfInfoMetadata").add("VnfConfigurableProperties", vnfConfigurableProperties())
                .add("VnfInstanceId", vnfInstanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vnfConfigurableProperties":
            return Optional.ofNullable(clazz.cast(vnfConfigurableProperties()));
        case "vnfInstanceId":
            return Optional.ofNullable(clazz.cast(vnfInstanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVnfInfoMetadata, T> g) {
        return obj -> g.apply((ModifyVnfInfoMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModifyVnfInfoMetadata> {
        /**
         * <p>
         * The configurable properties used during update of the network function instance.
         * </p>
         * 
         * @param vnfConfigurableProperties
         *        The configurable properties used during update of the network function instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfConfigurableProperties(Document vnfConfigurableProperties);

        /**
         * <p>
         * The network function instance that was updated in the network instance.
         * </p>
         * 
         * @param vnfInstanceId
         *        The network function instance that was updated in the network instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfInstanceId(String vnfInstanceId);
    }

    static final class BuilderImpl implements Builder {
        private Document vnfConfigurableProperties;

        private String vnfInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVnfInfoMetadata model) {
            vnfConfigurableProperties(model.vnfConfigurableProperties);
            vnfInstanceId(model.vnfInstanceId);
        }

        public final Document getVnfConfigurableProperties() {
            return vnfConfigurableProperties;
        }

        public final void setVnfConfigurableProperties(Document vnfConfigurableProperties) {
            this.vnfConfigurableProperties = vnfConfigurableProperties;
        }

        @Override
        public final Builder vnfConfigurableProperties(Document vnfConfigurableProperties) {
            this.vnfConfigurableProperties = vnfConfigurableProperties;
            return this;
        }

        public final String getVnfInstanceId() {
            return vnfInstanceId;
        }

        public final void setVnfInstanceId(String vnfInstanceId) {
            this.vnfInstanceId = vnfInstanceId;
        }

        @Override
        public final Builder vnfInstanceId(String vnfInstanceId) {
            this.vnfInstanceId = vnfInstanceId;
            return this;
        }

        @Override
        public ModifyVnfInfoMetadata build() {
            return new ModifyVnfInfoMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
