/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.tnb.model.TagMapCopier;
import software.amazon.awssdk.services.tnb.model.TnbRequest;
import software.amazon.awssdk.services.tnb.model.UpdateSolNetworkModify;
import software.amazon.awssdk.services.tnb.model.UpdateSolNetworkServiceData;
import software.amazon.awssdk.services.tnb.model.UpdateSolNetworkType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSolNetworkInstanceRequest
extends TnbRequest
implements ToCopyableBuilder<Builder, UpdateSolNetworkInstanceRequest> {
    private static final SdkField<UpdateSolNetworkModify> MODIFY_VNF_INFO_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modifyVnfInfoData").getter(UpdateSolNetworkInstanceRequest.getter(UpdateSolNetworkInstanceRequest::modifyVnfInfoData)).setter(UpdateSolNetworkInstanceRequest.setter(Builder::modifyVnfInfoData)).constructor(UpdateSolNetworkModify::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifyVnfInfoData").build()}).build();
    private static final SdkField<String> NS_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsInstanceId").getter(UpdateSolNetworkInstanceRequest.getter(UpdateSolNetworkInstanceRequest::nsInstanceId)).setter(UpdateSolNetworkInstanceRequest.setter(Builder::nsInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("nsInstanceId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(UpdateSolNetworkInstanceRequest.getter(UpdateSolNetworkInstanceRequest::tags)).setter(UpdateSolNetworkInstanceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<UpdateSolNetworkServiceData> UPDATE_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("updateNs").getter(UpdateSolNetworkInstanceRequest.getter(UpdateSolNetworkInstanceRequest::updateNs)).setter(UpdateSolNetworkInstanceRequest.setter(Builder::updateNs)).constructor(UpdateSolNetworkServiceData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateNs").build()}).build();
    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateType").getter(UpdateSolNetworkInstanceRequest.getter(UpdateSolNetworkInstanceRequest::updateTypeAsString)).setter(UpdateSolNetworkInstanceRequest.setter(Builder::updateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODIFY_VNF_INFO_DATA_FIELD, NS_INSTANCE_ID_FIELD, TAGS_FIELD, UPDATE_NS_FIELD, UPDATE_TYPE_FIELD));
    private final UpdateSolNetworkModify modifyVnfInfoData;
    private final String nsInstanceId;
    private final Map<String, String> tags;
    private final UpdateSolNetworkServiceData updateNs;
    private final String updateType;

    private UpdateSolNetworkInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.modifyVnfInfoData = builder.modifyVnfInfoData;
        this.nsInstanceId = builder.nsInstanceId;
        this.tags = builder.tags;
        this.updateNs = builder.updateNs;
        this.updateType = builder.updateType;
    }

    public final UpdateSolNetworkModify modifyVnfInfoData() {
        return this.modifyVnfInfoData;
    }

    public final String nsInstanceId() {
        return this.nsInstanceId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final UpdateSolNetworkServiceData updateNs() {
        return this.updateNs;
    }

    public final UpdateSolNetworkType updateType() {
        return UpdateSolNetworkType.fromValue(this.updateType);
    }

    public final String updateTypeAsString() {
        return this.updateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modifyVnfInfoData());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateNs());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSolNetworkInstanceRequest)) {
            return false;
        }
        UpdateSolNetworkInstanceRequest other = (UpdateSolNetworkInstanceRequest)((Object)obj);
        return Objects.equals(this.modifyVnfInfoData(), other.modifyVnfInfoData()) && Objects.equals(this.nsInstanceId(), other.nsInstanceId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.updateNs(), other.updateNs()) && Objects.equals(this.updateTypeAsString(), other.updateTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSolNetworkInstanceRequest").add("ModifyVnfInfoData", (Object)this.modifyVnfInfoData()).add("NsInstanceId", (Object)this.nsInstanceId()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("UpdateNs", (Object)this.updateNs()).add("UpdateType", (Object)this.updateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modifyVnfInfoData": {
                return Optional.ofNullable(clazz.cast(this.modifyVnfInfoData()));
            }
            case "nsInstanceId": {
                return Optional.ofNullable(clazz.cast(this.nsInstanceId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "updateNs": {
                return Optional.ofNullable(clazz.cast(this.updateNs()));
            }
            case "updateType": {
                return Optional.ofNullable(clazz.cast(this.updateTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSolNetworkInstanceRequest, T> g) {
        return obj -> g.apply((UpdateSolNetworkInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbRequest.BuilderImpl
    implements Builder {
        private UpdateSolNetworkModify modifyVnfInfoData;
        private String nsInstanceId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private UpdateSolNetworkServiceData updateNs;
        private String updateType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSolNetworkInstanceRequest model) {
            super(model);
            this.modifyVnfInfoData(model.modifyVnfInfoData);
            this.nsInstanceId(model.nsInstanceId);
            this.tags(model.tags);
            this.updateNs(model.updateNs);
            this.updateType(model.updateType);
        }

        public final UpdateSolNetworkModify.Builder getModifyVnfInfoData() {
            return this.modifyVnfInfoData != null ? this.modifyVnfInfoData.toBuilder() : null;
        }

        public final void setModifyVnfInfoData(UpdateSolNetworkModify.BuilderImpl modifyVnfInfoData) {
            this.modifyVnfInfoData = modifyVnfInfoData != null ? modifyVnfInfoData.build() : null;
        }

        @Override
        public final Builder modifyVnfInfoData(UpdateSolNetworkModify modifyVnfInfoData) {
            this.modifyVnfInfoData = modifyVnfInfoData;
            return this;
        }

        public final String getNsInstanceId() {
            return this.nsInstanceId;
        }

        public final void setNsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
        }

        @Override
        public final Builder nsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final UpdateSolNetworkServiceData.Builder getUpdateNs() {
            return this.updateNs != null ? this.updateNs.toBuilder() : null;
        }

        public final void setUpdateNs(UpdateSolNetworkServiceData.BuilderImpl updateNs) {
            this.updateNs = updateNs != null ? updateNs.build() : null;
        }

        @Override
        public final Builder updateNs(UpdateSolNetworkServiceData updateNs) {
            this.updateNs = updateNs;
            return this;
        }

        public final String getUpdateType() {
            return this.updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(UpdateSolNetworkType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSolNetworkInstanceRequest build() {
            return new UpdateSolNetworkInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TnbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSolNetworkInstanceRequest> {
        public Builder modifyVnfInfoData(UpdateSolNetworkModify var1);

        default public Builder modifyVnfInfoData(Consumer<UpdateSolNetworkModify.Builder> modifyVnfInfoData) {
            return this.modifyVnfInfoData((UpdateSolNetworkModify)((UpdateSolNetworkModify.Builder)UpdateSolNetworkModify.builder().applyMutation(modifyVnfInfoData)).build());
        }

        public Builder nsInstanceId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder updateNs(UpdateSolNetworkServiceData var1);

        default public Builder updateNs(Consumer<UpdateSolNetworkServiceData.Builder> updateNs) {
            return this.updateNs((UpdateSolNetworkServiceData)((UpdateSolNetworkServiceData.Builder)UpdateSolNetworkServiceData.builder().applyMutation(updateNs)).build());
        }

        public Builder updateType(String var1);

        public Builder updateType(UpdateSolNetworkType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

