/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.tnb.model.PackageContentType;
import software.amazon.awssdk.services.tnb.model.TnbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidateSolNetworkPackageContentRequest
extends TnbRequest
implements ToCopyableBuilder<Builder, ValidateSolNetworkPackageContentRequest> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(ValidateSolNetworkPackageContentRequest.getter(ValidateSolNetworkPackageContentRequest::contentTypeAsString)).setter(ValidateSolNetworkPackageContentRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<SdkBytes> FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("file").getter(ValidateSolNetworkPackageContentRequest.getter(ValidateSolNetworkPackageContentRequest::file)).setter(ValidateSolNetworkPackageContentRequest.setter(Builder::file)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> NSD_INFO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdInfoId").getter(ValidateSolNetworkPackageContentRequest.getter(ValidateSolNetworkPackageContentRequest::nsdInfoId)).setter(ValidateSolNetworkPackageContentRequest.setter(Builder::nsdInfoId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("nsdInfoId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, FILE_FIELD, NSD_INFO_ID_FIELD));
    private final String contentType;
    private final SdkBytes file;
    private final String nsdInfoId;

    private ValidateSolNetworkPackageContentRequest(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.file = builder.file;
        this.nsdInfoId = builder.nsdInfoId;
    }

    public final PackageContentType contentType() {
        return PackageContentType.fromValue(this.contentType);
    }

    public final String contentTypeAsString() {
        return this.contentType;
    }

    public final SdkBytes file() {
        return this.file;
    }

    public final String nsdInfoId() {
        return this.nsdInfoId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.file());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdInfoId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateSolNetworkPackageContentRequest)) {
            return false;
        }
        ValidateSolNetworkPackageContentRequest other = (ValidateSolNetworkPackageContentRequest)((Object)obj);
        return Objects.equals(this.contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(this.file(), other.file()) && Objects.equals(this.nsdInfoId(), other.nsdInfoId());
    }

    public final String toString() {
        return ToString.builder((String)"ValidateSolNetworkPackageContentRequest").add("ContentType", (Object)this.contentTypeAsString()).add("File", (Object)(this.file() == null ? null : "*** Sensitive Data Redacted ***")).add("NsdInfoId", (Object)this.nsdInfoId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentTypeAsString()));
            }
            case "file": {
                return Optional.ofNullable(clazz.cast(this.file()));
            }
            case "nsdInfoId": {
                return Optional.ofNullable(clazz.cast(this.nsdInfoId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateSolNetworkPackageContentRequest, T> g) {
        return obj -> g.apply((ValidateSolNetworkPackageContentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbRequest.BuilderImpl
    implements Builder {
        private String contentType;
        private SdkBytes file;
        private String nsdInfoId;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateSolNetworkPackageContentRequest model) {
            super(model);
            this.contentType(model.contentType);
            this.file(model.file);
            this.nsdInfoId(model.nsdInfoId);
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(PackageContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final ByteBuffer getFile() {
            return this.file == null ? null : this.file.asByteBuffer();
        }

        public final void setFile(ByteBuffer file) {
            this.file(file == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)file));
        }

        @Override
        public final Builder file(SdkBytes file) {
            this.file = file;
            return this;
        }

        public final String getNsdInfoId() {
            return this.nsdInfoId;
        }

        public final void setNsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
        }

        @Override
        public final Builder nsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ValidateSolNetworkPackageContentRequest build() {
            return new ValidateSolNetworkPackageContentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TnbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ValidateSolNetworkPackageContentRequest> {
        public Builder contentType(String var1);

        public Builder contentType(PackageContentType var1);

        public Builder file(SdkBytes var1);

        public Builder nsdInfoId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

