/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSolFunctionPackageResponse extends TnbResponse implements
        ToCopyableBuilder<CreateSolFunctionPackageResponse.Builder, CreateSolFunctionPackageResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateSolFunctionPackageResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateSolFunctionPackageResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ONBOARDING_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("onboardingState").getter(getter(CreateSolFunctionPackageResponse::onboardingStateAsString))
            .setter(setter(Builder::onboardingState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onboardingState").build()).build();

    private static final SdkField<String> OPERATIONAL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationalState").getter(getter(CreateSolFunctionPackageResponse::operationalStateAsString))
            .setter(setter(Builder::operationalState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationalState").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateSolFunctionPackageResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> USAGE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageState").getter(getter(CreateSolFunctionPackageResponse::usageStateAsString))
            .setter(setter(Builder::usageState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            ONBOARDING_STATE_FIELD, OPERATIONAL_STATE_FIELD, TAGS_FIELD, USAGE_STATE_FIELD));

    private final String arn;

    private final String id;

    private final String onboardingState;

    private final String operationalState;

    private final Map<String, String> tags;

    private final String usageState;

    private CreateSolFunctionPackageResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.onboardingState = builder.onboardingState;
        this.operationalState = builder.operationalState;
        this.tags = builder.tags;
        this.usageState = builder.usageState;
    }

    /**
     * <p>
     * Function package ARN.
     * </p>
     * 
     * @return Function package ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * ID of the function package.
     * </p>
     * 
     * @return ID of the function package.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Onboarding state of the function package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #onboardingState}
     * will return {@link OnboardingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #onboardingStateAsString}.
     * </p>
     * 
     * @return Onboarding state of the function package.
     * @see OnboardingState
     */
    public final OnboardingState onboardingState() {
        return OnboardingState.fromValue(onboardingState);
    }

    /**
     * <p>
     * Onboarding state of the function package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #onboardingState}
     * will return {@link OnboardingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #onboardingStateAsString}.
     * </p>
     * 
     * @return Onboarding state of the function package.
     * @see OnboardingState
     */
    public final String onboardingStateAsString() {
        return onboardingState;
    }

    /**
     * <p>
     * Operational state of the function package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationalState}
     * will return {@link OperationalState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operationalStateAsString}.
     * </p>
     * 
     * @return Operational state of the function package.
     * @see OperationalState
     */
    public final OperationalState operationalState() {
        return OperationalState.fromValue(operationalState);
    }

    /**
     * <p>
     * Operational state of the function package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationalState}
     * will return {@link OperationalState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operationalStateAsString}.
     * </p>
     * 
     * @return Operational state of the function package.
     * @see OperationalState
     */
    public final String operationalStateAsString() {
        return operationalState;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
     *         optional value. You can use tags to search and filter your resources or track your Amazon Web Services
     *         costs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Usage state of the function package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usageState} will
     * return {@link UsageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageStateAsString}.
     * </p>
     * 
     * @return Usage state of the function package.
     * @see UsageState
     */
    public final UsageState usageState() {
        return UsageState.fromValue(usageState);
    }

    /**
     * <p>
     * Usage state of the function package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usageState} will
     * return {@link UsageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageStateAsString}.
     * </p>
     * 
     * @return Usage state of the function package.
     * @see UsageState
     */
    public final String usageStateAsString() {
        return usageState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(onboardingStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(operationalStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(usageStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSolFunctionPackageResponse)) {
            return false;
        }
        CreateSolFunctionPackageResponse other = (CreateSolFunctionPackageResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(onboardingStateAsString(), other.onboardingStateAsString())
                && Objects.equals(operationalStateAsString(), other.operationalStateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(usageStateAsString(), other.usageStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSolFunctionPackageResponse").add("Arn", arn()).add("Id", id())
                .add("OnboardingState", onboardingStateAsString()).add("OperationalState", operationalStateAsString())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").add("UsageState", usageStateAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "onboardingState":
            return Optional.ofNullable(clazz.cast(onboardingStateAsString()));
        case "operationalState":
            return Optional.ofNullable(clazz.cast(operationalStateAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "usageState":
            return Optional.ofNullable(clazz.cast(usageStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSolFunctionPackageResponse, T> g) {
        return obj -> g.apply((CreateSolFunctionPackageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TnbResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSolFunctionPackageResponse> {
        /**
         * <p>
         * Function package ARN.
         * </p>
         * 
         * @param arn
         *        Function package ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * ID of the function package.
         * </p>
         * 
         * @param id
         *        ID of the function package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Onboarding state of the function package.
         * </p>
         * 
         * @param onboardingState
         *        Onboarding state of the function package.
         * @see OnboardingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnboardingState
         */
        Builder onboardingState(String onboardingState);

        /**
         * <p>
         * Onboarding state of the function package.
         * </p>
         * 
         * @param onboardingState
         *        Onboarding state of the function package.
         * @see OnboardingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnboardingState
         */
        Builder onboardingState(OnboardingState onboardingState);

        /**
         * <p>
         * Operational state of the function package.
         * </p>
         * 
         * @param operationalState
         *        Operational state of the function package.
         * @see OperationalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationalState
         */
        Builder operationalState(String operationalState);

        /**
         * <p>
         * Operational state of the function package.
         * </p>
         * 
         * @param operationalState
         *        Operational state of the function package.
         * @see OperationalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationalState
         */
        Builder operationalState(OperationalState operationalState);

        /**
         * <p>
         * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         * optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
         * </p>
         * 
         * @param tags
         *        A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         *        optional value. You can use tags to search and filter your resources or track your Amazon Web Services
         *        costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Usage state of the function package.
         * </p>
         * 
         * @param usageState
         *        Usage state of the function package.
         * @see UsageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageState
         */
        Builder usageState(String usageState);

        /**
         * <p>
         * Usage state of the function package.
         * </p>
         * 
         * @param usageState
         *        Usage state of the function package.
         * @see UsageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageState
         */
        Builder usageState(UsageState usageState);
    }

    static final class BuilderImpl extends TnbResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String onboardingState;

        private String operationalState;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String usageState;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSolFunctionPackageResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            onboardingState(model.onboardingState);
            operationalState(model.operationalState);
            tags(model.tags);
            usageState(model.usageState);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getOnboardingState() {
            return onboardingState;
        }

        public final void setOnboardingState(String onboardingState) {
            this.onboardingState = onboardingState;
        }

        @Override
        public final Builder onboardingState(String onboardingState) {
            this.onboardingState = onboardingState;
            return this;
        }

        @Override
        public final Builder onboardingState(OnboardingState onboardingState) {
            this.onboardingState(onboardingState == null ? null : onboardingState.toString());
            return this;
        }

        public final String getOperationalState() {
            return operationalState;
        }

        public final void setOperationalState(String operationalState) {
            this.operationalState = operationalState;
        }

        @Override
        public final Builder operationalState(String operationalState) {
            this.operationalState = operationalState;
            return this;
        }

        @Override
        public final Builder operationalState(OperationalState operationalState) {
            this.operationalState(operationalState == null ? null : operationalState.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getUsageState() {
            return usageState;
        }

        public final void setUsageState(String usageState) {
            this.usageState = usageState;
        }

        @Override
        public final Builder usageState(String usageState) {
            this.usageState = usageState;
            return this;
        }

        @Override
        public final Builder usageState(UsageState usageState) {
            this.usageState(usageState == null ? null : usageState.toString());
            return this;
        }

        @Override
        public CreateSolFunctionPackageResponse build() {
            return new CreateSolFunctionPackageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
