/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Update metadata in a function package.
 * </p>
 * <p>
 * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI
 * standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how
 * the network functions should run on your network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSolFunctionPackageContentMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<PutSolFunctionPackageContentMetadata.Builder, PutSolFunctionPackageContentMetadata> {
    private static final SdkField<FunctionArtifactMeta> VNFD_FIELD = SdkField
            .<FunctionArtifactMeta> builder(MarshallingType.SDK_POJO).memberName("vnfd")
            .getter(getter(PutSolFunctionPackageContentMetadata::vnfd)).setter(setter(Builder::vnfd))
            .constructor(FunctionArtifactMeta::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfd").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VNFD_FIELD));

    private static final long serialVersionUID = 1L;

    private final FunctionArtifactMeta vnfd;

    private PutSolFunctionPackageContentMetadata(BuilderImpl builder) {
        this.vnfd = builder.vnfd;
    }

    /**
     * Returns the value of the Vnfd property for this object.
     * 
     * @return The value of the Vnfd property for this object.
     */
    public final FunctionArtifactMeta vnfd() {
        return vnfd;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vnfd());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSolFunctionPackageContentMetadata)) {
            return false;
        }
        PutSolFunctionPackageContentMetadata other = (PutSolFunctionPackageContentMetadata) obj;
        return Objects.equals(vnfd(), other.vnfd());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSolFunctionPackageContentMetadata").add("Vnfd", vnfd()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vnfd":
            return Optional.ofNullable(clazz.cast(vnfd()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSolFunctionPackageContentMetadata, T> g) {
        return obj -> g.apply((PutSolFunctionPackageContentMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PutSolFunctionPackageContentMetadata> {
        /**
         * Sets the value of the Vnfd property for this object.
         *
         * @param vnfd
         *        The new value for the Vnfd property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfd(FunctionArtifactMeta vnfd);

        /**
         * Sets the value of the Vnfd property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FunctionArtifactMeta.Builder} avoiding
         * the need to create one manually via {@link FunctionArtifactMeta#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunctionArtifactMeta.Builder#build()} is called immediately and
         * its result is passed to {@link #vnfd(FunctionArtifactMeta)}.
         * 
         * @param vnfd
         *        a consumer that will call methods on {@link FunctionArtifactMeta.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vnfd(FunctionArtifactMeta)
         */
        default Builder vnfd(Consumer<FunctionArtifactMeta.Builder> vnfd) {
            return vnfd(FunctionArtifactMeta.builder().applyMutation(vnfd).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FunctionArtifactMeta vnfd;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSolFunctionPackageContentMetadata model) {
            vnfd(model.vnfd);
        }

        public final FunctionArtifactMeta.Builder getVnfd() {
            return vnfd != null ? vnfd.toBuilder() : null;
        }

        public final void setVnfd(FunctionArtifactMeta.BuilderImpl vnfd) {
            this.vnfd = vnfd != null ? vnfd.build() : null;
        }

        @Override
        public final Builder vnfd(FunctionArtifactMeta vnfd) {
            this.vnfd = vnfd;
            return this;
        }

        @Override
        public PutSolFunctionPackageContentMetadata build() {
            return new PutSolFunctionPackageContentMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
