/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSolNetworkPackageContentRequest extends TnbRequest implements
        ToCopyableBuilder<PutSolNetworkPackageContentRequest.Builder, PutSolNetworkPackageContentRequest> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(PutSolNetworkPackageContentRequest::contentTypeAsString))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<SdkBytes> FILE_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("file")
            .getter(getter(PutSolNetworkPackageContentRequest::file))
            .setter(setter(Builder::file))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<String> NSD_INFO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdInfoId").getter(getter(PutSolNetworkPackageContentRequest::nsdInfoId))
            .setter(setter(Builder::nsdInfoId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("nsdInfoId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            FILE_FIELD, NSD_INFO_ID_FIELD));

    private final String contentType;

    private final SdkBytes file;

    private final String nsdInfoId;

    private PutSolNetworkPackageContentRequest(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.file = builder.file;
        this.nsdInfoId = builder.nsdInfoId;
    }

    /**
     * <p>
     * Network package content type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link PackageContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return Network package content type.
     * @see PackageContentType
     */
    public final PackageContentType contentType() {
        return PackageContentType.fromValue(contentType);
    }

    /**
     * <p>
     * Network package content type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link PackageContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return Network package content type.
     * @see PackageContentType
     */
    public final String contentTypeAsString() {
        return contentType;
    }

    /**
     * <p>
     * Network package file.
     * </p>
     * 
     * @return Network package file.
     */
    public final SdkBytes file() {
        return file;
    }

    /**
     * <p>
     * Network service descriptor info ID.
     * </p>
     * 
     * @return Network service descriptor info ID.
     */
    public final String nsdInfoId() {
        return nsdInfoId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(file());
        hashCode = 31 * hashCode + Objects.hashCode(nsdInfoId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSolNetworkPackageContentRequest)) {
            return false;
        }
        PutSolNetworkPackageContentRequest other = (PutSolNetworkPackageContentRequest) obj;
        return Objects.equals(contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(file(), other.file())
                && Objects.equals(nsdInfoId(), other.nsdInfoId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSolNetworkPackageContentRequest").add("ContentType", contentTypeAsString())
                .add("File", file() == null ? null : "*** Sensitive Data Redacted ***").add("NsdInfoId", nsdInfoId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        case "file":
            return Optional.ofNullable(clazz.cast(file()));
        case "nsdInfoId":
            return Optional.ofNullable(clazz.cast(nsdInfoId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSolNetworkPackageContentRequest, T> g) {
        return obj -> g.apply((PutSolNetworkPackageContentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TnbRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutSolNetworkPackageContentRequest> {
        /**
         * <p>
         * Network package content type.
         * </p>
         * 
         * @param contentType
         *        Network package content type.
         * @see PackageContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageContentType
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Network package content type.
         * </p>
         * 
         * @param contentType
         *        Network package content type.
         * @see PackageContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageContentType
         */
        Builder contentType(PackageContentType contentType);

        /**
         * <p>
         * Network package file.
         * </p>
         * 
         * @param file
         *        Network package file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(SdkBytes file);

        /**
         * <p>
         * Network service descriptor info ID.
         * </p>
         * 
         * @param nsdInfoId
         *        Network service descriptor info ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdInfoId(String nsdInfoId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TnbRequest.BuilderImpl implements Builder {
        private String contentType;

        private SdkBytes file;

        private String nsdInfoId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSolNetworkPackageContentRequest model) {
            super(model);
            contentType(model.contentType);
            file(model.file);
            nsdInfoId(model.nsdInfoId);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(PackageContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final ByteBuffer getFile() {
            return file == null ? null : file.asByteBuffer();
        }

        public final void setFile(ByteBuffer file) {
            file(file == null ? null : SdkBytes.fromByteBuffer(file));
        }

        @Override
        public final Builder file(SdkBytes file) {
            this.file = file;
            return this;
        }

        public final String getNsdInfoId() {
            return nsdInfoId;
        }

        public final void setNsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
        }

        @Override
        public final Builder nsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSolNetworkPackageContentRequest build() {
            return new PutSolNetworkPackageContentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
