/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information parameters and/or the configurable properties for a network descriptor used for update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSolNetworkServiceData implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateSolNetworkServiceData.Builder, UpdateSolNetworkServiceData> {
    private static final SdkField<Document> ADDITIONAL_PARAMS_FOR_NS_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT).memberName("additionalParamsForNs")
            .getter(getter(UpdateSolNetworkServiceData::additionalParamsForNs)).setter(setter(Builder::additionalParamsForNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalParamsForNs").build())
            .build();

    private static final SdkField<String> NSD_INFO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdInfoId").getter(getter(UpdateSolNetworkServiceData::nsdInfoId)).setter(setter(Builder::nsdInfoId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdInfoId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADDITIONAL_PARAMS_FOR_NS_FIELD, NSD_INFO_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Document additionalParamsForNs;

    private final String nsdInfoId;

    private UpdateSolNetworkServiceData(BuilderImpl builder) {
        this.additionalParamsForNs = builder.additionalParamsForNs;
        this.nsdInfoId = builder.nsdInfoId;
    }

    /**
     * <p>
     * Values for the configurable properties declared in the network service descriptor.
     * </p>
     * 
     * @return Values for the configurable properties declared in the network service descriptor.
     */
    public final Document additionalParamsForNs() {
        return additionalParamsForNs;
    }

    /**
     * <p>
     * ID of the network service descriptor.
     * </p>
     * 
     * @return ID of the network service descriptor.
     */
    public final String nsdInfoId() {
        return nsdInfoId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(additionalParamsForNs());
        hashCode = 31 * hashCode + Objects.hashCode(nsdInfoId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSolNetworkServiceData)) {
            return false;
        }
        UpdateSolNetworkServiceData other = (UpdateSolNetworkServiceData) obj;
        return Objects.equals(additionalParamsForNs(), other.additionalParamsForNs())
                && Objects.equals(nsdInfoId(), other.nsdInfoId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSolNetworkServiceData").add("AdditionalParamsForNs", additionalParamsForNs())
                .add("NsdInfoId", nsdInfoId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalParamsForNs":
            return Optional.ofNullable(clazz.cast(additionalParamsForNs()));
        case "nsdInfoId":
            return Optional.ofNullable(clazz.cast(nsdInfoId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSolNetworkServiceData, T> g) {
        return obj -> g.apply((UpdateSolNetworkServiceData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateSolNetworkServiceData> {
        /**
         * <p>
         * Values for the configurable properties declared in the network service descriptor.
         * </p>
         * 
         * @param additionalParamsForNs
         *        Values for the configurable properties declared in the network service descriptor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalParamsForNs(Document additionalParamsForNs);

        /**
         * <p>
         * ID of the network service descriptor.
         * </p>
         * 
         * @param nsdInfoId
         *        ID of the network service descriptor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdInfoId(String nsdInfoId);
    }

    static final class BuilderImpl implements Builder {
        private Document additionalParamsForNs;

        private String nsdInfoId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSolNetworkServiceData model) {
            additionalParamsForNs(model.additionalParamsForNs);
            nsdInfoId(model.nsdInfoId);
        }

        public final Document getAdditionalParamsForNs() {
            return additionalParamsForNs;
        }

        public final void setAdditionalParamsForNs(Document additionalParamsForNs) {
            this.additionalParamsForNs = additionalParamsForNs;
        }

        @Override
        public final Builder additionalParamsForNs(Document additionalParamsForNs) {
            this.additionalParamsForNs = additionalParamsForNs;
            return this;
        }

        public final String getNsdInfoId() {
            return nsdInfoId;
        }

        public final void setNsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
        }

        @Override
        public final Builder nsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
            return this;
        }

        @Override
        public UpdateSolNetworkServiceData build() {
            return new UpdateSolNetworkServiceData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
