/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.tnb.model.OnboardingState;
import software.amazon.awssdk.services.tnb.model.OperationalState;
import software.amazon.awssdk.services.tnb.model.TagMapCopier;
import software.amazon.awssdk.services.tnb.model.TnbResponse;
import software.amazon.awssdk.services.tnb.model.UsageState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSolFunctionPackageResponse
extends TnbResponse
implements ToCopyableBuilder<Builder, CreateSolFunctionPackageResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateSolFunctionPackageResponse.getter(CreateSolFunctionPackageResponse::arn)).setter(CreateSolFunctionPackageResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateSolFunctionPackageResponse.getter(CreateSolFunctionPackageResponse::id)).setter(CreateSolFunctionPackageResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ONBOARDING_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("onboardingState").getter(CreateSolFunctionPackageResponse.getter(CreateSolFunctionPackageResponse::onboardingStateAsString)).setter(CreateSolFunctionPackageResponse.setter(Builder::onboardingState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onboardingState").build()}).build();
    private static final SdkField<String> OPERATIONAL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationalState").getter(CreateSolFunctionPackageResponse.getter(CreateSolFunctionPackageResponse::operationalStateAsString)).setter(CreateSolFunctionPackageResponse.setter(Builder::operationalState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationalState").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateSolFunctionPackageResponse.getter(CreateSolFunctionPackageResponse::tags)).setter(CreateSolFunctionPackageResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> USAGE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageState").getter(CreateSolFunctionPackageResponse.getter(CreateSolFunctionPackageResponse::usageStateAsString)).setter(CreateSolFunctionPackageResponse.setter(Builder::usageState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, ONBOARDING_STATE_FIELD, OPERATIONAL_STATE_FIELD, TAGS_FIELD, USAGE_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("id", ID_FIELD);
            this.put("onboardingState", ONBOARDING_STATE_FIELD);
            this.put("operationalState", OPERATIONAL_STATE_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("usageState", USAGE_STATE_FIELD);
        }
    });
    private final String arn;
    private final String id;
    private final String onboardingState;
    private final String operationalState;
    private final Map<String, String> tags;
    private final String usageState;

    private CreateSolFunctionPackageResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.onboardingState = builder.onboardingState;
        this.operationalState = builder.operationalState;
        this.tags = builder.tags;
        this.usageState = builder.usageState;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final OnboardingState onboardingState() {
        return OnboardingState.fromValue(this.onboardingState);
    }

    public final String onboardingStateAsString() {
        return this.onboardingState;
    }

    public final OperationalState operationalState() {
        return OperationalState.fromValue(this.operationalState);
    }

    public final String operationalStateAsString() {
        return this.operationalState;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final UsageState usageState() {
        return UsageState.fromValue(this.usageState);
    }

    public final String usageStateAsString() {
        return this.usageState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.onboardingStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationalStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.usageStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSolFunctionPackageResponse)) {
            return false;
        }
        CreateSolFunctionPackageResponse other = (CreateSolFunctionPackageResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.onboardingStateAsString(), other.onboardingStateAsString()) && Objects.equals(this.operationalStateAsString(), other.operationalStateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.usageStateAsString(), other.usageStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSolFunctionPackageResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("OnboardingState", (Object)this.onboardingStateAsString()).add("OperationalState", (Object)this.operationalStateAsString()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("UsageState", (Object)this.usageStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "onboardingState": {
                return Optional.ofNullable(clazz.cast(this.onboardingStateAsString()));
            }
            case "operationalState": {
                return Optional.ofNullable(clazz.cast(this.operationalStateAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "usageState": {
                return Optional.ofNullable(clazz.cast(this.usageStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateSolFunctionPackageResponse, T> g) {
        return obj -> g.apply((CreateSolFunctionPackageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String onboardingState;
        private String operationalState;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String usageState;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSolFunctionPackageResponse model) {
            super(model);
            this.arn(model.arn);
            this.id(model.id);
            this.onboardingState(model.onboardingState);
            this.operationalState(model.operationalState);
            this.tags(model.tags);
            this.usageState(model.usageState);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getOnboardingState() {
            return this.onboardingState;
        }

        public final void setOnboardingState(String onboardingState) {
            this.onboardingState = onboardingState;
        }

        @Override
        public final Builder onboardingState(String onboardingState) {
            this.onboardingState = onboardingState;
            return this;
        }

        @Override
        public final Builder onboardingState(OnboardingState onboardingState) {
            this.onboardingState(onboardingState == null ? null : onboardingState.toString());
            return this;
        }

        public final String getOperationalState() {
            return this.operationalState;
        }

        public final void setOperationalState(String operationalState) {
            this.operationalState = operationalState;
        }

        @Override
        public final Builder operationalState(String operationalState) {
            this.operationalState = operationalState;
            return this;
        }

        @Override
        public final Builder operationalState(OperationalState operationalState) {
            this.operationalState(operationalState == null ? null : operationalState.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getUsageState() {
            return this.usageState;
        }

        public final void setUsageState(String usageState) {
            this.usageState = usageState;
        }

        @Override
        public final Builder usageState(String usageState) {
            this.usageState = usageState;
            return this;
        }

        @Override
        public final Builder usageState(UsageState usageState) {
            this.usageState(usageState == null ? null : usageState.toString());
            return this;
        }

        @Override
        public CreateSolFunctionPackageResponse build() {
            return new CreateSolFunctionPackageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TnbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSolFunctionPackageResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder onboardingState(String var1);

        public Builder onboardingState(OnboardingState var1);

        public Builder operationalState(String var1);

        public Builder operationalState(OperationalState var1);

        public Builder tags(Map<String, String> var1);

        public Builder usageState(String var1);

        public Builder usageState(UsageState var1);
    }
}

