/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionInstanceInfo;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionInstanceResourcesCopier;
import software.amazon.awssdk.services.tnb.model.TnbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSolFunctionInstancesResponse
extends TnbResponse
implements ToCopyableBuilder<Builder, ListSolFunctionInstancesResponse> {
    private static final SdkField<List<ListSolFunctionInstanceInfo>> FUNCTION_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("functionInstances").getter(ListSolFunctionInstancesResponse.getter(ListSolFunctionInstancesResponse::functionInstances)).setter(ListSolFunctionInstancesResponse.setter(Builder::functionInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListSolFunctionInstanceInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSolFunctionInstancesResponse.getter(ListSolFunctionInstancesResponse::nextToken)).setter(ListSolFunctionInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_INSTANCES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("functionInstances", FUNCTION_INSTANCES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ListSolFunctionInstanceInfo> functionInstances;
    private final String nextToken;

    private ListSolFunctionInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.functionInstances = builder.functionInstances;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFunctionInstances() {
        return this.functionInstances != null && !(this.functionInstances instanceof SdkAutoConstructList);
    }

    public final List<ListSolFunctionInstanceInfo> functionInstances() {
        return this.functionInstances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctionInstances() ? this.functionInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolFunctionInstancesResponse)) {
            return false;
        }
        ListSolFunctionInstancesResponse other = (ListSolFunctionInstancesResponse)((Object)obj);
        return this.hasFunctionInstances() == other.hasFunctionInstances() && Objects.equals(this.functionInstances(), other.functionInstances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSolFunctionInstancesResponse").add("FunctionInstances", this.hasFunctionInstances() ? this.functionInstances() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "functionInstances": {
                return Optional.ofNullable(clazz.cast(this.functionInstances()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSolFunctionInstancesResponse, T> g) {
        return obj -> g.apply((ListSolFunctionInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbResponse.BuilderImpl
    implements Builder {
        private List<ListSolFunctionInstanceInfo> functionInstances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolFunctionInstancesResponse model) {
            super(model);
            this.functionInstances(model.functionInstances);
            this.nextToken(model.nextToken);
        }

        public final List<ListSolFunctionInstanceInfo.Builder> getFunctionInstances() {
            List<ListSolFunctionInstanceInfo.Builder> result = ListSolFunctionInstanceResourcesCopier.copyToBuilder(this.functionInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFunctionInstances(Collection<ListSolFunctionInstanceInfo.BuilderImpl> functionInstances) {
            this.functionInstances = ListSolFunctionInstanceResourcesCopier.copyFromBuilder(functionInstances);
        }

        @Override
        public final Builder functionInstances(Collection<ListSolFunctionInstanceInfo> functionInstances) {
            this.functionInstances = ListSolFunctionInstanceResourcesCopier.copy(functionInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionInstances(ListSolFunctionInstanceInfo ... functionInstances) {
            this.functionInstances(Arrays.asList(functionInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionInstances(Consumer<ListSolFunctionInstanceInfo.Builder> ... functionInstances) {
            this.functionInstances(Stream.of(functionInstances).map(c -> (ListSolFunctionInstanceInfo)((ListSolFunctionInstanceInfo.Builder)ListSolFunctionInstanceInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSolFunctionInstancesResponse build() {
            return new ListSolFunctionInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TnbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSolFunctionInstancesResponse> {
        public Builder functionInstances(Collection<ListSolFunctionInstanceInfo> var1);

        public Builder functionInstances(ListSolFunctionInstanceInfo ... var1);

        public Builder functionInstances(Consumer<ListSolFunctionInstanceInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

