/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.tnb.model.NsdOnboardingState;
import software.amazon.awssdk.services.tnb.model.NsdOperationalState;
import software.amazon.awssdk.services.tnb.model.NsdUsageState;
import software.amazon.awssdk.services.tnb.model.TagMapCopier;
import software.amazon.awssdk.services.tnb.model.TnbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSolNetworkPackageResponse
extends TnbResponse
implements ToCopyableBuilder<Builder, CreateSolNetworkPackageResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateSolNetworkPackageResponse.getter(CreateSolNetworkPackageResponse::arn)).setter(CreateSolNetworkPackageResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateSolNetworkPackageResponse.getter(CreateSolNetworkPackageResponse::id)).setter(CreateSolNetworkPackageResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NSD_ONBOARDING_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdOnboardingState").getter(CreateSolNetworkPackageResponse.getter(CreateSolNetworkPackageResponse::nsdOnboardingStateAsString)).setter(CreateSolNetworkPackageResponse.setter(Builder::nsdOnboardingState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdOnboardingState").build()}).build();
    private static final SdkField<String> NSD_OPERATIONAL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdOperationalState").getter(CreateSolNetworkPackageResponse.getter(CreateSolNetworkPackageResponse::nsdOperationalStateAsString)).setter(CreateSolNetworkPackageResponse.setter(Builder::nsdOperationalState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdOperationalState").build()}).build();
    private static final SdkField<String> NSD_USAGE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdUsageState").getter(CreateSolNetworkPackageResponse.getter(CreateSolNetworkPackageResponse::nsdUsageStateAsString)).setter(CreateSolNetworkPackageResponse.setter(Builder::nsdUsageState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdUsageState").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateSolNetworkPackageResponse.getter(CreateSolNetworkPackageResponse::tags)).setter(CreateSolNetworkPackageResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, NSD_ONBOARDING_STATE_FIELD, NSD_OPERATIONAL_STATE_FIELD, NSD_USAGE_STATE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("id", ID_FIELD);
            this.put("nsdOnboardingState", NSD_ONBOARDING_STATE_FIELD);
            this.put("nsdOperationalState", NSD_OPERATIONAL_STATE_FIELD);
            this.put("nsdUsageState", NSD_USAGE_STATE_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String arn;
    private final String id;
    private final String nsdOnboardingState;
    private final String nsdOperationalState;
    private final String nsdUsageState;
    private final Map<String, String> tags;

    private CreateSolNetworkPackageResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.nsdOnboardingState = builder.nsdOnboardingState;
        this.nsdOperationalState = builder.nsdOperationalState;
        this.nsdUsageState = builder.nsdUsageState;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final NsdOnboardingState nsdOnboardingState() {
        return NsdOnboardingState.fromValue(this.nsdOnboardingState);
    }

    public final String nsdOnboardingStateAsString() {
        return this.nsdOnboardingState;
    }

    public final NsdOperationalState nsdOperationalState() {
        return NsdOperationalState.fromValue(this.nsdOperationalState);
    }

    public final String nsdOperationalStateAsString() {
        return this.nsdOperationalState;
    }

    public final NsdUsageState nsdUsageState() {
        return NsdUsageState.fromValue(this.nsdUsageState);
    }

    public final String nsdUsageStateAsString() {
        return this.nsdUsageState;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdOnboardingStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdOperationalStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdUsageStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSolNetworkPackageResponse)) {
            return false;
        }
        CreateSolNetworkPackageResponse other = (CreateSolNetworkPackageResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.nsdOnboardingStateAsString(), other.nsdOnboardingStateAsString()) && Objects.equals(this.nsdOperationalStateAsString(), other.nsdOperationalStateAsString()) && Objects.equals(this.nsdUsageStateAsString(), other.nsdUsageStateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSolNetworkPackageResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("NsdOnboardingState", (Object)this.nsdOnboardingStateAsString()).add("NsdOperationalState", (Object)this.nsdOperationalStateAsString()).add("NsdUsageState", (Object)this.nsdUsageStateAsString()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "nsdOnboardingState": {
                return Optional.ofNullable(clazz.cast(this.nsdOnboardingStateAsString()));
            }
            case "nsdOperationalState": {
                return Optional.ofNullable(clazz.cast(this.nsdOperationalStateAsString()));
            }
            case "nsdUsageState": {
                return Optional.ofNullable(clazz.cast(this.nsdUsageStateAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateSolNetworkPackageResponse, T> g) {
        return obj -> g.apply((CreateSolNetworkPackageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String nsdOnboardingState;
        private String nsdOperationalState;
        private String nsdUsageState;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSolNetworkPackageResponse model) {
            super(model);
            this.arn(model.arn);
            this.id(model.id);
            this.nsdOnboardingState(model.nsdOnboardingState);
            this.nsdOperationalState(model.nsdOperationalState);
            this.nsdUsageState(model.nsdUsageState);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getNsdOnboardingState() {
            return this.nsdOnboardingState;
        }

        public final void setNsdOnboardingState(String nsdOnboardingState) {
            this.nsdOnboardingState = nsdOnboardingState;
        }

        @Override
        public final Builder nsdOnboardingState(String nsdOnboardingState) {
            this.nsdOnboardingState = nsdOnboardingState;
            return this;
        }

        @Override
        public final Builder nsdOnboardingState(NsdOnboardingState nsdOnboardingState) {
            this.nsdOnboardingState(nsdOnboardingState == null ? null : nsdOnboardingState.toString());
            return this;
        }

        public final String getNsdOperationalState() {
            return this.nsdOperationalState;
        }

        public final void setNsdOperationalState(String nsdOperationalState) {
            this.nsdOperationalState = nsdOperationalState;
        }

        @Override
        public final Builder nsdOperationalState(String nsdOperationalState) {
            this.nsdOperationalState = nsdOperationalState;
            return this;
        }

        @Override
        public final Builder nsdOperationalState(NsdOperationalState nsdOperationalState) {
            this.nsdOperationalState(nsdOperationalState == null ? null : nsdOperationalState.toString());
            return this;
        }

        public final String getNsdUsageState() {
            return this.nsdUsageState;
        }

        public final void setNsdUsageState(String nsdUsageState) {
            this.nsdUsageState = nsdUsageState;
        }

        @Override
        public final Builder nsdUsageState(String nsdUsageState) {
            this.nsdUsageState = nsdUsageState;
            return this;
        }

        @Override
        public final Builder nsdUsageState(NsdUsageState nsdUsageState) {
            this.nsdUsageState(nsdUsageState == null ? null : nsdUsageState.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CreateSolNetworkPackageResponse build() {
            return new CreateSolNetworkPackageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TnbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSolNetworkPackageResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder nsdOnboardingState(String var1);

        public Builder nsdOnboardingState(NsdOnboardingState var1);

        public Builder nsdOperationalState(String var1);

        public Builder nsdOperationalState(NsdOperationalState var1);

        public Builder nsdUsageState(String var1);

        public Builder nsdUsageState(NsdUsageState var1);

        public Builder tags(Map<String, String> var1);
    }
}

