/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSolFunctionPackageDescriptorResponse extends TnbResponse implements
        ToCopyableBuilder<GetSolFunctionPackageDescriptorResponse.Builder, GetSolFunctionPackageDescriptorResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(GetSolFunctionPackageDescriptorResponse::contentTypeAsString))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<SdkBytes> VNFD_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("vnfd")
            .getter(getter(GetSolFunctionPackageDescriptorResponse::vnfd))
            .setter(setter(Builder::vnfd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfd").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONTENT_TYPE_FIELD, VNFD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String contentType;

    private final SdkBytes vnfd;

    private GetSolFunctionPackageDescriptorResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.vnfd = builder.vnfd;
    }

    /**
     * <p>
     * Indicates the media type of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link DescriptorContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentTypeAsString}.
     * </p>
     * 
     * @return Indicates the media type of the resource.
     * @see DescriptorContentType
     */
    public final DescriptorContentType contentType() {
        return DescriptorContentType.fromValue(contentType);
    }

    /**
     * <p>
     * Indicates the media type of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link DescriptorContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentTypeAsString}.
     * </p>
     * 
     * @return Indicates the media type of the resource.
     * @see DescriptorContentType
     */
    public final String contentTypeAsString() {
        return contentType;
    }

    /**
     * <p>
     * Contents of the function package descriptor.
     * </p>
     * 
     * @return Contents of the function package descriptor.
     */
    public final SdkBytes vnfd() {
        return vnfd;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vnfd());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolFunctionPackageDescriptorResponse)) {
            return false;
        }
        GetSolFunctionPackageDescriptorResponse other = (GetSolFunctionPackageDescriptorResponse) obj;
        return Objects.equals(contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(vnfd(), other.vnfd());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSolFunctionPackageDescriptorResponse").add("ContentType", contentTypeAsString())
                .add("Vnfd", vnfd()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        case "vnfd":
            return Optional.ofNullable(clazz.cast(vnfd()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("vnfd", VNFD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSolFunctionPackageDescriptorResponse, T> g) {
        return obj -> g.apply((GetSolFunctionPackageDescriptorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TnbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSolFunctionPackageDescriptorResponse> {
        /**
         * <p>
         * Indicates the media type of the resource.
         * </p>
         * 
         * @param contentType
         *        Indicates the media type of the resource.
         * @see DescriptorContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DescriptorContentType
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Indicates the media type of the resource.
         * </p>
         * 
         * @param contentType
         *        Indicates the media type of the resource.
         * @see DescriptorContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DescriptorContentType
         */
        Builder contentType(DescriptorContentType contentType);

        /**
         * <p>
         * Contents of the function package descriptor.
         * </p>
         * 
         * @param vnfd
         *        Contents of the function package descriptor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfd(SdkBytes vnfd);
    }

    static final class BuilderImpl extends TnbResponse.BuilderImpl implements Builder {
        private String contentType;

        private SdkBytes vnfd;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolFunctionPackageDescriptorResponse model) {
            super(model);
            contentType(model.contentType);
            vnfd(model.vnfd);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(DescriptorContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final ByteBuffer getVnfd() {
            return vnfd == null ? null : vnfd.asByteBuffer();
        }

        public final void setVnfd(ByteBuffer vnfd) {
            vnfd(vnfd == null ? null : SdkBytes.fromByteBuffer(vnfd));
        }

        @Override
        public final Builder vnfd(SdkBytes vnfd) {
            this.vnfd = vnfd;
            return this;
        }

        @Override
        public GetSolFunctionPackageDescriptorResponse build() {
            return new GetSolFunctionPackageDescriptorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
