/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of resource associated with a network function.
 * </p>
 * <p>
 * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
 * life-cycle operations (like terminate, update, and delete) can be performed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSolVnfcResourceInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<GetSolVnfcResourceInfo.Builder, GetSolVnfcResourceInfo> {
    private static final SdkField<GetSolVnfcResourceInfoMetadata> METADATA_FIELD = SdkField
            .<GetSolVnfcResourceInfoMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(GetSolVnfcResourceInfo::metadata)).setter(setter(Builder::metadata))
            .constructor(GetSolVnfcResourceInfoMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GetSolVnfcResourceInfoMetadata metadata;

    private GetSolVnfcResourceInfo(BuilderImpl builder) {
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The metadata of the network function compute.
     * </p>
     * 
     * @return The metadata of the network function compute.
     */
    public final GetSolVnfcResourceInfoMetadata metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolVnfcResourceInfo)) {
            return false;
        }
        GetSolVnfcResourceInfo other = (GetSolVnfcResourceInfo) obj;
        return Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSolVnfcResourceInfo").add("Metadata", metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSolVnfcResourceInfo, T> g) {
        return obj -> g.apply((GetSolVnfcResourceInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GetSolVnfcResourceInfo> {
        /**
         * <p>
         * The metadata of the network function compute.
         * </p>
         * 
         * @param metadata
         *        The metadata of the network function compute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(GetSolVnfcResourceInfoMetadata metadata);

        /**
         * <p>
         * The metadata of the network function compute.
         * </p>
         * This is a convenience method that creates an instance of the {@link GetSolVnfcResourceInfoMetadata.Builder}
         * avoiding the need to create one manually via {@link GetSolVnfcResourceInfoMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GetSolVnfcResourceInfoMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(GetSolVnfcResourceInfoMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link GetSolVnfcResourceInfoMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(GetSolVnfcResourceInfoMetadata)
         */
        default Builder metadata(Consumer<GetSolVnfcResourceInfoMetadata.Builder> metadata) {
            return metadata(GetSolVnfcResourceInfoMetadata.builder().applyMutation(metadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GetSolVnfcResourceInfoMetadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolVnfcResourceInfo model) {
            metadata(model.metadata);
        }

        public final GetSolVnfcResourceInfoMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(GetSolVnfcResourceInfoMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(GetSolVnfcResourceInfoMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public GetSolVnfcResourceInfo build() {
            return new GetSolVnfcResourceInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
