/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata related to the configuration properties used during instantiation of the network instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstantiateMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<InstantiateMetadata.Builder, InstantiateMetadata> {
    private static final SdkField<Document> ADDITIONAL_PARAMS_FOR_NS_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT).memberName("additionalParamsForNs")
            .getter(getter(InstantiateMetadata::additionalParamsForNs)).setter(setter(Builder::additionalParamsForNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalParamsForNs").build())
            .build();

    private static final SdkField<String> NSD_INFO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdInfoId").getter(getter(InstantiateMetadata::nsdInfoId)).setter(setter(Builder::nsdInfoId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdInfoId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADDITIONAL_PARAMS_FOR_NS_FIELD, NSD_INFO_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Document additionalParamsForNs;

    private final String nsdInfoId;

    private InstantiateMetadata(BuilderImpl builder) {
        this.additionalParamsForNs = builder.additionalParamsForNs;
        this.nsdInfoId = builder.nsdInfoId;
    }

    /**
     * <p>
     * The configurable properties used during instantiation.
     * </p>
     * 
     * @return The configurable properties used during instantiation.
     */
    public final Document additionalParamsForNs() {
        return additionalParamsForNs;
    }

    /**
     * <p>
     * The network service descriptor used for instantiating the network instance.
     * </p>
     * 
     * @return The network service descriptor used for instantiating the network instance.
     */
    public final String nsdInfoId() {
        return nsdInfoId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(additionalParamsForNs());
        hashCode = 31 * hashCode + Objects.hashCode(nsdInfoId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstantiateMetadata)) {
            return false;
        }
        InstantiateMetadata other = (InstantiateMetadata) obj;
        return Objects.equals(additionalParamsForNs(), other.additionalParamsForNs())
                && Objects.equals(nsdInfoId(), other.nsdInfoId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstantiateMetadata").add("AdditionalParamsForNs", additionalParamsForNs())
                .add("NsdInfoId", nsdInfoId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalParamsForNs":
            return Optional.ofNullable(clazz.cast(additionalParamsForNs()));
        case "nsdInfoId":
            return Optional.ofNullable(clazz.cast(nsdInfoId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("additionalParamsForNs", ADDITIONAL_PARAMS_FOR_NS_FIELD);
        map.put("nsdInfoId", NSD_INFO_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstantiateMetadata, T> g) {
        return obj -> g.apply((InstantiateMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstantiateMetadata> {
        /**
         * <p>
         * The configurable properties used during instantiation.
         * </p>
         * 
         * @param additionalParamsForNs
         *        The configurable properties used during instantiation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalParamsForNs(Document additionalParamsForNs);

        /**
         * <p>
         * The network service descriptor used for instantiating the network instance.
         * </p>
         * 
         * @param nsdInfoId
         *        The network service descriptor used for instantiating the network instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdInfoId(String nsdInfoId);
    }

    static final class BuilderImpl implements Builder {
        private Document additionalParamsForNs;

        private String nsdInfoId;

        private BuilderImpl() {
        }

        private BuilderImpl(InstantiateMetadata model) {
            additionalParamsForNs(model.additionalParamsForNs);
            nsdInfoId(model.nsdInfoId);
        }

        public final Document getAdditionalParamsForNs() {
            return additionalParamsForNs;
        }

        public final void setAdditionalParamsForNs(Document additionalParamsForNs) {
            this.additionalParamsForNs = additionalParamsForNs;
        }

        @Override
        public final Builder additionalParamsForNs(Document additionalParamsForNs) {
            this.additionalParamsForNs = additionalParamsForNs;
            return this;
        }

        public final String getNsdInfoId() {
            return nsdInfoId;
        }

        public final void setNsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
        }

        @Override
        public final Builder nsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
            return this;
        }

        @Override
        public InstantiateMetadata build() {
            return new InstantiateMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
