/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lifecycle management operation details on the network instance.
 * </p>
 * <p>
 * Lifecycle management operations are deploy, update, or delete operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LcmOperationInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<LcmOperationInfo.Builder, LcmOperationInfo> {
    private static final SdkField<String> NS_LCM_OP_OCC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsLcmOpOccId").getter(getter(LcmOperationInfo::nsLcmOpOccId)).setter(setter(Builder::nsLcmOpOccId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsLcmOpOccId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NS_LCM_OP_OCC_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nsLcmOpOccId;

    private LcmOperationInfo(BuilderImpl builder) {
        this.nsLcmOpOccId = builder.nsLcmOpOccId;
    }

    /**
     * <p>
     * The identifier of the network operation.
     * </p>
     * 
     * @return The identifier of the network operation.
     */
    public final String nsLcmOpOccId() {
        return nsLcmOpOccId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nsLcmOpOccId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LcmOperationInfo)) {
            return false;
        }
        LcmOperationInfo other = (LcmOperationInfo) obj;
        return Objects.equals(nsLcmOpOccId(), other.nsLcmOpOccId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LcmOperationInfo").add("NsLcmOpOccId", nsLcmOpOccId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nsLcmOpOccId":
            return Optional.ofNullable(clazz.cast(nsLcmOpOccId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nsLcmOpOccId", NS_LCM_OP_OCC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LcmOperationInfo, T> g) {
        return obj -> g.apply((LcmOperationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LcmOperationInfo> {
        /**
         * <p>
         * The identifier of the network operation.
         * </p>
         * 
         * @param nsLcmOpOccId
         *        The identifier of the network operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsLcmOpOccId(String nsLcmOpOccId);
    }

    static final class BuilderImpl implements Builder {
        private String nsLcmOpOccId;

        private BuilderImpl() {
        }

        private BuilderImpl(LcmOperationInfo model) {
            nsLcmOpOccId(model.nsLcmOpOccId);
        }

        public final String getNsLcmOpOccId() {
            return nsLcmOpOccId;
        }

        public final void setNsLcmOpOccId(String nsLcmOpOccId) {
            this.nsLcmOpOccId = nsLcmOpOccId;
        }

        @Override
        public final Builder nsLcmOpOccId(String nsLcmOpOccId) {
            this.nsLcmOpOccId = nsLcmOpOccId;
            return this;
        }

        @Override
        public LcmOperationInfo build() {
            return new LcmOperationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
