/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of a network package.
 * </p>
 * <p>
 * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
 * deploy and the Amazon Web Services infrastructure you want to deploy them on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSolNetworkPackageInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ListSolNetworkPackageInfo.Builder, ListSolNetworkPackageInfo> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ListSolNetworkPackageInfo::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ListSolNetworkPackageInfo::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<ListSolNetworkPackageMetadata> METADATA_FIELD = SdkField
            .<ListSolNetworkPackageMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(ListSolNetworkPackageInfo::metadata)).setter(setter(Builder::metadata))
            .constructor(ListSolNetworkPackageMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<String> NSD_DESIGNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdDesigner").getter(getter(ListSolNetworkPackageInfo::nsdDesigner))
            .setter(setter(Builder::nsdDesigner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdDesigner").build()).build();

    private static final SdkField<String> NSD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("nsdId")
            .getter(getter(ListSolNetworkPackageInfo::nsdId)).setter(setter(Builder::nsdId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdId").build()).build();

    private static final SdkField<String> NSD_INVARIANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdInvariantId").getter(getter(ListSolNetworkPackageInfo::nsdInvariantId))
            .setter(setter(Builder::nsdInvariantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdInvariantId").build()).build();

    private static final SdkField<String> NSD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdName").getter(getter(ListSolNetworkPackageInfo::nsdName)).setter(setter(Builder::nsdName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdName").build()).build();

    private static final SdkField<String> NSD_ONBOARDING_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdOnboardingState").getter(getter(ListSolNetworkPackageInfo::nsdOnboardingStateAsString))
            .setter(setter(Builder::nsdOnboardingState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdOnboardingState").build())
            .build();

    private static final SdkField<String> NSD_OPERATIONAL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdOperationalState").getter(getter(ListSolNetworkPackageInfo::nsdOperationalStateAsString))
            .setter(setter(Builder::nsdOperationalState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdOperationalState").build())
            .build();

    private static final SdkField<String> NSD_USAGE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdUsageState").getter(getter(ListSolNetworkPackageInfo::nsdUsageStateAsString))
            .setter(setter(Builder::nsdUsageState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdUsageState").build()).build();

    private static final SdkField<String> NSD_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdVersion").getter(getter(ListSolNetworkPackageInfo::nsdVersion)).setter(setter(Builder::nsdVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdVersion").build()).build();

    private static final SdkField<List<String>> VNF_PKG_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vnfPkgIds")
            .getter(getter(ListSolNetworkPackageInfo::vnfPkgIds))
            .setter(setter(Builder::vnfPkgIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfPkgIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            METADATA_FIELD, NSD_DESIGNER_FIELD, NSD_ID_FIELD, NSD_INVARIANT_ID_FIELD, NSD_NAME_FIELD, NSD_ONBOARDING_STATE_FIELD,
            NSD_OPERATIONAL_STATE_FIELD, NSD_USAGE_STATE_FIELD, NSD_VERSION_FIELD, VNF_PKG_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final ListSolNetworkPackageMetadata metadata;

    private final String nsdDesigner;

    private final String nsdId;

    private final String nsdInvariantId;

    private final String nsdName;

    private final String nsdOnboardingState;

    private final String nsdOperationalState;

    private final String nsdUsageState;

    private final String nsdVersion;

    private final List<String> vnfPkgIds;

    private ListSolNetworkPackageInfo(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.metadata = builder.metadata;
        this.nsdDesigner = builder.nsdDesigner;
        this.nsdId = builder.nsdId;
        this.nsdInvariantId = builder.nsdInvariantId;
        this.nsdName = builder.nsdName;
        this.nsdOnboardingState = builder.nsdOnboardingState;
        this.nsdOperationalState = builder.nsdOperationalState;
        this.nsdUsageState = builder.nsdUsageState;
        this.nsdVersion = builder.nsdVersion;
        this.vnfPkgIds = builder.vnfPkgIds;
    }

    /**
     * <p>
     * Network package ARN.
     * </p>
     * 
     * @return Network package ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * ID of the individual network package.
     * </p>
     * 
     * @return ID of the individual network package.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The metadata of the network package.
     * </p>
     * 
     * @return The metadata of the network package.
     */
    public final ListSolNetworkPackageMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * Designer of the onboarded network service descriptor in the network package.
     * </p>
     * 
     * @return Designer of the onboarded network service descriptor in the network package.
     */
    public final String nsdDesigner() {
        return nsdDesigner;
    }

    /**
     * <p>
     * ID of the network service descriptor on which the network package is based.
     * </p>
     * 
     * @return ID of the network service descriptor on which the network package is based.
     */
    public final String nsdId() {
        return nsdId;
    }

    /**
     * <p>
     * Identifies a network service descriptor in a version independent manner.
     * </p>
     * 
     * @return Identifies a network service descriptor in a version independent manner.
     */
    public final String nsdInvariantId() {
        return nsdInvariantId;
    }

    /**
     * <p>
     * Name of the onboarded network service descriptor in the network package.
     * </p>
     * 
     * @return Name of the onboarded network service descriptor in the network package.
     */
    public final String nsdName() {
        return nsdName;
    }

    /**
     * <p>
     * Onboarding state of the network service descriptor in the network package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nsdOnboardingState} will return {@link NsdOnboardingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #nsdOnboardingStateAsString}.
     * </p>
     * 
     * @return Onboarding state of the network service descriptor in the network package.
     * @see NsdOnboardingState
     */
    public final NsdOnboardingState nsdOnboardingState() {
        return NsdOnboardingState.fromValue(nsdOnboardingState);
    }

    /**
     * <p>
     * Onboarding state of the network service descriptor in the network package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nsdOnboardingState} will return {@link NsdOnboardingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #nsdOnboardingStateAsString}.
     * </p>
     * 
     * @return Onboarding state of the network service descriptor in the network package.
     * @see NsdOnboardingState
     */
    public final String nsdOnboardingStateAsString() {
        return nsdOnboardingState;
    }

    /**
     * <p>
     * Operational state of the network service descriptor in the network package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nsdOperationalState} will return {@link NsdOperationalState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nsdOperationalStateAsString}.
     * </p>
     * 
     * @return Operational state of the network service descriptor in the network package.
     * @see NsdOperationalState
     */
    public final NsdOperationalState nsdOperationalState() {
        return NsdOperationalState.fromValue(nsdOperationalState);
    }

    /**
     * <p>
     * Operational state of the network service descriptor in the network package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nsdOperationalState} will return {@link NsdOperationalState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nsdOperationalStateAsString}.
     * </p>
     * 
     * @return Operational state of the network service descriptor in the network package.
     * @see NsdOperationalState
     */
    public final String nsdOperationalStateAsString() {
        return nsdOperationalState;
    }

    /**
     * <p>
     * Usage state of the network service descriptor in the network package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nsdUsageState}
     * will return {@link NsdUsageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nsdUsageStateAsString}.
     * </p>
     * 
     * @return Usage state of the network service descriptor in the network package.
     * @see NsdUsageState
     */
    public final NsdUsageState nsdUsageState() {
        return NsdUsageState.fromValue(nsdUsageState);
    }

    /**
     * <p>
     * Usage state of the network service descriptor in the network package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nsdUsageState}
     * will return {@link NsdUsageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nsdUsageStateAsString}.
     * </p>
     * 
     * @return Usage state of the network service descriptor in the network package.
     * @see NsdUsageState
     */
    public final String nsdUsageStateAsString() {
        return nsdUsageState;
    }

    /**
     * <p>
     * Version of the onboarded network service descriptor in the network package.
     * </p>
     * 
     * @return Version of the onboarded network service descriptor in the network package.
     */
    public final String nsdVersion() {
        return nsdVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the VnfPkgIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVnfPkgIds() {
        return vnfPkgIds != null && !(vnfPkgIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Identifies the function package for the function package descriptor referenced by the onboarded network package.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVnfPkgIds} method.
     * </p>
     * 
     * @return Identifies the function package for the function package descriptor referenced by the onboarded network
     *         package.
     */
    public final List<String> vnfPkgIds() {
        return vnfPkgIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(nsdDesigner());
        hashCode = 31 * hashCode + Objects.hashCode(nsdId());
        hashCode = 31 * hashCode + Objects.hashCode(nsdInvariantId());
        hashCode = 31 * hashCode + Objects.hashCode(nsdName());
        hashCode = 31 * hashCode + Objects.hashCode(nsdOnboardingStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nsdOperationalStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nsdUsageStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nsdVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasVnfPkgIds() ? vnfPkgIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolNetworkPackageInfo)) {
            return false;
        }
        ListSolNetworkPackageInfo other = (ListSolNetworkPackageInfo) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(nsdDesigner(), other.nsdDesigner())
                && Objects.equals(nsdId(), other.nsdId()) && Objects.equals(nsdInvariantId(), other.nsdInvariantId())
                && Objects.equals(nsdName(), other.nsdName())
                && Objects.equals(nsdOnboardingStateAsString(), other.nsdOnboardingStateAsString())
                && Objects.equals(nsdOperationalStateAsString(), other.nsdOperationalStateAsString())
                && Objects.equals(nsdUsageStateAsString(), other.nsdUsageStateAsString())
                && Objects.equals(nsdVersion(), other.nsdVersion()) && hasVnfPkgIds() == other.hasVnfPkgIds()
                && Objects.equals(vnfPkgIds(), other.vnfPkgIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSolNetworkPackageInfo").add("Arn", arn()).add("Id", id()).add("Metadata", metadata())
                .add("NsdDesigner", nsdDesigner()).add("NsdId", nsdId()).add("NsdInvariantId", nsdInvariantId())
                .add("NsdName", nsdName()).add("NsdOnboardingState", nsdOnboardingStateAsString())
                .add("NsdOperationalState", nsdOperationalStateAsString()).add("NsdUsageState", nsdUsageStateAsString())
                .add("NsdVersion", nsdVersion()).add("VnfPkgIds", hasVnfPkgIds() ? vnfPkgIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "nsdDesigner":
            return Optional.ofNullable(clazz.cast(nsdDesigner()));
        case "nsdId":
            return Optional.ofNullable(clazz.cast(nsdId()));
        case "nsdInvariantId":
            return Optional.ofNullable(clazz.cast(nsdInvariantId()));
        case "nsdName":
            return Optional.ofNullable(clazz.cast(nsdName()));
        case "nsdOnboardingState":
            return Optional.ofNullable(clazz.cast(nsdOnboardingStateAsString()));
        case "nsdOperationalState":
            return Optional.ofNullable(clazz.cast(nsdOperationalStateAsString()));
        case "nsdUsageState":
            return Optional.ofNullable(clazz.cast(nsdUsageStateAsString()));
        case "nsdVersion":
            return Optional.ofNullable(clazz.cast(nsdVersion()));
        case "vnfPkgIds":
            return Optional.ofNullable(clazz.cast(vnfPkgIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("nsdDesigner", NSD_DESIGNER_FIELD);
        map.put("nsdId", NSD_ID_FIELD);
        map.put("nsdInvariantId", NSD_INVARIANT_ID_FIELD);
        map.put("nsdName", NSD_NAME_FIELD);
        map.put("nsdOnboardingState", NSD_ONBOARDING_STATE_FIELD);
        map.put("nsdOperationalState", NSD_OPERATIONAL_STATE_FIELD);
        map.put("nsdUsageState", NSD_USAGE_STATE_FIELD);
        map.put("nsdVersion", NSD_VERSION_FIELD);
        map.put("vnfPkgIds", VNF_PKG_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSolNetworkPackageInfo, T> g) {
        return obj -> g.apply((ListSolNetworkPackageInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListSolNetworkPackageInfo> {
        /**
         * <p>
         * Network package ARN.
         * </p>
         * 
         * @param arn
         *        Network package ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * ID of the individual network package.
         * </p>
         * 
         * @param id
         *        ID of the individual network package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The metadata of the network package.
         * </p>
         * 
         * @param metadata
         *        The metadata of the network package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(ListSolNetworkPackageMetadata metadata);

        /**
         * <p>
         * The metadata of the network package.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListSolNetworkPackageMetadata.Builder}
         * avoiding the need to create one manually via {@link ListSolNetworkPackageMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListSolNetworkPackageMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(ListSolNetworkPackageMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link ListSolNetworkPackageMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(ListSolNetworkPackageMetadata)
         */
        default Builder metadata(Consumer<ListSolNetworkPackageMetadata.Builder> metadata) {
            return metadata(ListSolNetworkPackageMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * Designer of the onboarded network service descriptor in the network package.
         * </p>
         * 
         * @param nsdDesigner
         *        Designer of the onboarded network service descriptor in the network package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdDesigner(String nsdDesigner);

        /**
         * <p>
         * ID of the network service descriptor on which the network package is based.
         * </p>
         * 
         * @param nsdId
         *        ID of the network service descriptor on which the network package is based.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdId(String nsdId);

        /**
         * <p>
         * Identifies a network service descriptor in a version independent manner.
         * </p>
         * 
         * @param nsdInvariantId
         *        Identifies a network service descriptor in a version independent manner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdInvariantId(String nsdInvariantId);

        /**
         * <p>
         * Name of the onboarded network service descriptor in the network package.
         * </p>
         * 
         * @param nsdName
         *        Name of the onboarded network service descriptor in the network package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdName(String nsdName);

        /**
         * <p>
         * Onboarding state of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdOnboardingState
         *        Onboarding state of the network service descriptor in the network package.
         * @see NsdOnboardingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdOnboardingState
         */
        Builder nsdOnboardingState(String nsdOnboardingState);

        /**
         * <p>
         * Onboarding state of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdOnboardingState
         *        Onboarding state of the network service descriptor in the network package.
         * @see NsdOnboardingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdOnboardingState
         */
        Builder nsdOnboardingState(NsdOnboardingState nsdOnboardingState);

        /**
         * <p>
         * Operational state of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdOperationalState
         *        Operational state of the network service descriptor in the network package.
         * @see NsdOperationalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdOperationalState
         */
        Builder nsdOperationalState(String nsdOperationalState);

        /**
         * <p>
         * Operational state of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdOperationalState
         *        Operational state of the network service descriptor in the network package.
         * @see NsdOperationalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdOperationalState
         */
        Builder nsdOperationalState(NsdOperationalState nsdOperationalState);

        /**
         * <p>
         * Usage state of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdUsageState
         *        Usage state of the network service descriptor in the network package.
         * @see NsdUsageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdUsageState
         */
        Builder nsdUsageState(String nsdUsageState);

        /**
         * <p>
         * Usage state of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdUsageState
         *        Usage state of the network service descriptor in the network package.
         * @see NsdUsageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdUsageState
         */
        Builder nsdUsageState(NsdUsageState nsdUsageState);

        /**
         * <p>
         * Version of the onboarded network service descriptor in the network package.
         * </p>
         * 
         * @param nsdVersion
         *        Version of the onboarded network service descriptor in the network package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdVersion(String nsdVersion);

        /**
         * <p>
         * Identifies the function package for the function package descriptor referenced by the onboarded network
         * package.
         * </p>
         * 
         * @param vnfPkgIds
         *        Identifies the function package for the function package descriptor referenced by the onboarded
         *        network package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfPkgIds(Collection<String> vnfPkgIds);

        /**
         * <p>
         * Identifies the function package for the function package descriptor referenced by the onboarded network
         * package.
         * </p>
         * 
         * @param vnfPkgIds
         *        Identifies the function package for the function package descriptor referenced by the onboarded
         *        network package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfPkgIds(String... vnfPkgIds);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private ListSolNetworkPackageMetadata metadata;

        private String nsdDesigner;

        private String nsdId;

        private String nsdInvariantId;

        private String nsdName;

        private String nsdOnboardingState;

        private String nsdOperationalState;

        private String nsdUsageState;

        private String nsdVersion;

        private List<String> vnfPkgIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolNetworkPackageInfo model) {
            arn(model.arn);
            id(model.id);
            metadata(model.metadata);
            nsdDesigner(model.nsdDesigner);
            nsdId(model.nsdId);
            nsdInvariantId(model.nsdInvariantId);
            nsdName(model.nsdName);
            nsdOnboardingState(model.nsdOnboardingState);
            nsdOperationalState(model.nsdOperationalState);
            nsdUsageState(model.nsdUsageState);
            nsdVersion(model.nsdVersion);
            vnfPkgIds(model.vnfPkgIds);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ListSolNetworkPackageMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(ListSolNetworkPackageMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(ListSolNetworkPackageMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getNsdDesigner() {
            return nsdDesigner;
        }

        public final void setNsdDesigner(String nsdDesigner) {
            this.nsdDesigner = nsdDesigner;
        }

        @Override
        public final Builder nsdDesigner(String nsdDesigner) {
            this.nsdDesigner = nsdDesigner;
            return this;
        }

        public final String getNsdId() {
            return nsdId;
        }

        public final void setNsdId(String nsdId) {
            this.nsdId = nsdId;
        }

        @Override
        public final Builder nsdId(String nsdId) {
            this.nsdId = nsdId;
            return this;
        }

        public final String getNsdInvariantId() {
            return nsdInvariantId;
        }

        public final void setNsdInvariantId(String nsdInvariantId) {
            this.nsdInvariantId = nsdInvariantId;
        }

        @Override
        public final Builder nsdInvariantId(String nsdInvariantId) {
            this.nsdInvariantId = nsdInvariantId;
            return this;
        }

        public final String getNsdName() {
            return nsdName;
        }

        public final void setNsdName(String nsdName) {
            this.nsdName = nsdName;
        }

        @Override
        public final Builder nsdName(String nsdName) {
            this.nsdName = nsdName;
            return this;
        }

        public final String getNsdOnboardingState() {
            return nsdOnboardingState;
        }

        public final void setNsdOnboardingState(String nsdOnboardingState) {
            this.nsdOnboardingState = nsdOnboardingState;
        }

        @Override
        public final Builder nsdOnboardingState(String nsdOnboardingState) {
            this.nsdOnboardingState = nsdOnboardingState;
            return this;
        }

        @Override
        public final Builder nsdOnboardingState(NsdOnboardingState nsdOnboardingState) {
            this.nsdOnboardingState(nsdOnboardingState == null ? null : nsdOnboardingState.toString());
            return this;
        }

        public final String getNsdOperationalState() {
            return nsdOperationalState;
        }

        public final void setNsdOperationalState(String nsdOperationalState) {
            this.nsdOperationalState = nsdOperationalState;
        }

        @Override
        public final Builder nsdOperationalState(String nsdOperationalState) {
            this.nsdOperationalState = nsdOperationalState;
            return this;
        }

        @Override
        public final Builder nsdOperationalState(NsdOperationalState nsdOperationalState) {
            this.nsdOperationalState(nsdOperationalState == null ? null : nsdOperationalState.toString());
            return this;
        }

        public final String getNsdUsageState() {
            return nsdUsageState;
        }

        public final void setNsdUsageState(String nsdUsageState) {
            this.nsdUsageState = nsdUsageState;
        }

        @Override
        public final Builder nsdUsageState(String nsdUsageState) {
            this.nsdUsageState = nsdUsageState;
            return this;
        }

        @Override
        public final Builder nsdUsageState(NsdUsageState nsdUsageState) {
            this.nsdUsageState(nsdUsageState == null ? null : nsdUsageState.toString());
            return this;
        }

        public final String getNsdVersion() {
            return nsdVersion;
        }

        public final void setNsdVersion(String nsdVersion) {
            this.nsdVersion = nsdVersion;
        }

        @Override
        public final Builder nsdVersion(String nsdVersion) {
            this.nsdVersion = nsdVersion;
            return this;
        }

        public final Collection<String> getVnfPkgIds() {
            if (vnfPkgIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vnfPkgIds;
        }

        public final void setVnfPkgIds(Collection<String> vnfPkgIds) {
            this.vnfPkgIds = VnfPkgIdListCopier.copy(vnfPkgIds);
        }

        @Override
        public final Builder vnfPkgIds(Collection<String> vnfPkgIds) {
            this.vnfPkgIds = VnfPkgIdListCopier.copy(vnfPkgIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vnfPkgIds(String... vnfPkgIds) {
            vnfPkgIds(Arrays.asList(vnfPkgIds));
            return this;
        }

        @Override
        public ListSolNetworkPackageInfo build() {
            return new ListSolNetworkPackageInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
