/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information parameters and/or the configurable properties for a network function.
 * </p>
 * <p>
 * A network function instance is a function in a function package .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSolNetworkModify implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateSolNetworkModify.Builder, UpdateSolNetworkModify> {
    private static final SdkField<Document> VNF_CONFIGURABLE_PROPERTIES_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT).memberName("vnfConfigurableProperties")
            .getter(getter(UpdateSolNetworkModify::vnfConfigurableProperties)).setter(setter(Builder::vnfConfigurableProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfConfigurableProperties").build())
            .build();

    private static final SdkField<String> VNF_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfInstanceId").getter(getter(UpdateSolNetworkModify::vnfInstanceId))
            .setter(setter(Builder::vnfInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfInstanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VNF_CONFIGURABLE_PROPERTIES_FIELD, VNF_INSTANCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Document vnfConfigurableProperties;

    private final String vnfInstanceId;

    private UpdateSolNetworkModify(BuilderImpl builder) {
        this.vnfConfigurableProperties = builder.vnfConfigurableProperties;
        this.vnfInstanceId = builder.vnfInstanceId;
    }

    /**
     * <p>
     * Provides values for the configurable properties declared in the function package descriptor.
     * </p>
     * 
     * @return Provides values for the configurable properties declared in the function package descriptor.
     */
    public final Document vnfConfigurableProperties() {
        return vnfConfigurableProperties;
    }

    /**
     * <p>
     * ID of the network function instance.
     * </p>
     * <p>
     * A network function instance is a function in a function package .
     * </p>
     * 
     * @return ID of the network function instance.</p>
     *         <p>
     *         A network function instance is a function in a function package .
     */
    public final String vnfInstanceId() {
        return vnfInstanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vnfConfigurableProperties());
        hashCode = 31 * hashCode + Objects.hashCode(vnfInstanceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSolNetworkModify)) {
            return false;
        }
        UpdateSolNetworkModify other = (UpdateSolNetworkModify) obj;
        return Objects.equals(vnfConfigurableProperties(), other.vnfConfigurableProperties())
                && Objects.equals(vnfInstanceId(), other.vnfInstanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSolNetworkModify").add("VnfConfigurableProperties", vnfConfigurableProperties())
                .add("VnfInstanceId", vnfInstanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vnfConfigurableProperties":
            return Optional.ofNullable(clazz.cast(vnfConfigurableProperties()));
        case "vnfInstanceId":
            return Optional.ofNullable(clazz.cast(vnfInstanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vnfConfigurableProperties", VNF_CONFIGURABLE_PROPERTIES_FIELD);
        map.put("vnfInstanceId", VNF_INSTANCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSolNetworkModify, T> g) {
        return obj -> g.apply((UpdateSolNetworkModify) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateSolNetworkModify> {
        /**
         * <p>
         * Provides values for the configurable properties declared in the function package descriptor.
         * </p>
         * 
         * @param vnfConfigurableProperties
         *        Provides values for the configurable properties declared in the function package descriptor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfConfigurableProperties(Document vnfConfigurableProperties);

        /**
         * <p>
         * ID of the network function instance.
         * </p>
         * <p>
         * A network function instance is a function in a function package .
         * </p>
         * 
         * @param vnfInstanceId
         *        ID of the network function instance.</p>
         *        <p>
         *        A network function instance is a function in a function package .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfInstanceId(String vnfInstanceId);
    }

    static final class BuilderImpl implements Builder {
        private Document vnfConfigurableProperties;

        private String vnfInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSolNetworkModify model) {
            vnfConfigurableProperties(model.vnfConfigurableProperties);
            vnfInstanceId(model.vnfInstanceId);
        }

        public final Document getVnfConfigurableProperties() {
            return vnfConfigurableProperties;
        }

        public final void setVnfConfigurableProperties(Document vnfConfigurableProperties) {
            this.vnfConfigurableProperties = vnfConfigurableProperties;
        }

        @Override
        public final Builder vnfConfigurableProperties(Document vnfConfigurableProperties) {
            this.vnfConfigurableProperties = vnfConfigurableProperties;
            return this;
        }

        public final String getVnfInstanceId() {
            return vnfInstanceId;
        }

        public final void setVnfInstanceId(String vnfInstanceId) {
            this.vnfInstanceId = vnfInstanceId;
        }

        @Override
        public final Builder vnfInstanceId(String vnfInstanceId) {
            this.vnfInstanceId = vnfInstanceId;
            return this;
        }

        @Override
        public UpdateSolNetworkModify build() {
            return new UpdateSolNetworkModify(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
