/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSolNetworkPackageRequest extends TnbRequest implements
        ToCopyableBuilder<UpdateSolNetworkPackageRequest.Builder, UpdateSolNetworkPackageRequest> {
    private static final SdkField<String> NSD_INFO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdInfoId").getter(getter(UpdateSolNetworkPackageRequest::nsdInfoId)).setter(setter(Builder::nsdInfoId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("nsdInfoId").build()).build();

    private static final SdkField<String> NSD_OPERATIONAL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdOperationalState").getter(getter(UpdateSolNetworkPackageRequest::nsdOperationalStateAsString))
            .setter(setter(Builder::nsdOperationalState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdOperationalState").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NSD_INFO_ID_FIELD,
            NSD_OPERATIONAL_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nsdInfoId;

    private final String nsdOperationalState;

    private UpdateSolNetworkPackageRequest(BuilderImpl builder) {
        super(builder);
        this.nsdInfoId = builder.nsdInfoId;
        this.nsdOperationalState = builder.nsdOperationalState;
    }

    /**
     * <p>
     * ID of the network service descriptor in the network package.
     * </p>
     * 
     * @return ID of the network service descriptor in the network package.
     */
    public final String nsdInfoId() {
        return nsdInfoId;
    }

    /**
     * <p>
     * Operational state of the network service descriptor in the network package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nsdOperationalState} will return {@link NsdOperationalState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nsdOperationalStateAsString}.
     * </p>
     * 
     * @return Operational state of the network service descriptor in the network package.
     * @see NsdOperationalState
     */
    public final NsdOperationalState nsdOperationalState() {
        return NsdOperationalState.fromValue(nsdOperationalState);
    }

    /**
     * <p>
     * Operational state of the network service descriptor in the network package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nsdOperationalState} will return {@link NsdOperationalState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nsdOperationalStateAsString}.
     * </p>
     * 
     * @return Operational state of the network service descriptor in the network package.
     * @see NsdOperationalState
     */
    public final String nsdOperationalStateAsString() {
        return nsdOperationalState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nsdInfoId());
        hashCode = 31 * hashCode + Objects.hashCode(nsdOperationalStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSolNetworkPackageRequest)) {
            return false;
        }
        UpdateSolNetworkPackageRequest other = (UpdateSolNetworkPackageRequest) obj;
        return Objects.equals(nsdInfoId(), other.nsdInfoId())
                && Objects.equals(nsdOperationalStateAsString(), other.nsdOperationalStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSolNetworkPackageRequest").add("NsdInfoId", nsdInfoId())
                .add("NsdOperationalState", nsdOperationalStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nsdInfoId":
            return Optional.ofNullable(clazz.cast(nsdInfoId()));
        case "nsdOperationalState":
            return Optional.ofNullable(clazz.cast(nsdOperationalStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nsdInfoId", NSD_INFO_ID_FIELD);
        map.put("nsdOperationalState", NSD_OPERATIONAL_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSolNetworkPackageRequest, T> g) {
        return obj -> g.apply((UpdateSolNetworkPackageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TnbRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSolNetworkPackageRequest> {
        /**
         * <p>
         * ID of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdInfoId
         *        ID of the network service descriptor in the network package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdInfoId(String nsdInfoId);

        /**
         * <p>
         * Operational state of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdOperationalState
         *        Operational state of the network service descriptor in the network package.
         * @see NsdOperationalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdOperationalState
         */
        Builder nsdOperationalState(String nsdOperationalState);

        /**
         * <p>
         * Operational state of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdOperationalState
         *        Operational state of the network service descriptor in the network package.
         * @see NsdOperationalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdOperationalState
         */
        Builder nsdOperationalState(NsdOperationalState nsdOperationalState);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TnbRequest.BuilderImpl implements Builder {
        private String nsdInfoId;

        private String nsdOperationalState;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSolNetworkPackageRequest model) {
            super(model);
            nsdInfoId(model.nsdInfoId);
            nsdOperationalState(model.nsdOperationalState);
        }

        public final String getNsdInfoId() {
            return nsdInfoId;
        }

        public final void setNsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
        }

        @Override
        public final Builder nsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
            return this;
        }

        public final String getNsdOperationalState() {
            return nsdOperationalState;
        }

        public final void setNsdOperationalState(String nsdOperationalState) {
            this.nsdOperationalState = nsdOperationalState;
        }

        @Override
        public final Builder nsdOperationalState(String nsdOperationalState) {
            this.nsdOperationalState = nsdOperationalState;
            return this;
        }

        @Override
        public final Builder nsdOperationalState(NsdOperationalState nsdOperationalState) {
            this.nsdOperationalState(nsdOperationalState == null ? null : nsdOperationalState.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSolNetworkPackageRequest build() {
            return new UpdateSolNetworkPackageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
