/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.tnb.model.DescriptorContentType;
import software.amazon.awssdk.services.tnb.model.TnbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSolFunctionPackageDescriptorResponse
extends TnbResponse
implements ToCopyableBuilder<Builder, GetSolFunctionPackageDescriptorResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(GetSolFunctionPackageDescriptorResponse.getter(GetSolFunctionPackageDescriptorResponse::contentTypeAsString)).setter(GetSolFunctionPackageDescriptorResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<SdkBytes> VNFD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("vnfd").getter(GetSolFunctionPackageDescriptorResponse.getter(GetSolFunctionPackageDescriptorResponse::vnfd)).setter(GetSolFunctionPackageDescriptorResponse.setter(Builder::vnfd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfd").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, VNFD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSolFunctionPackageDescriptorResponse.memberNameToFieldInitializer();
    private final String contentType;
    private final SdkBytes vnfd;

    private GetSolFunctionPackageDescriptorResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.vnfd = builder.vnfd;
    }

    public final DescriptorContentType contentType() {
        return DescriptorContentType.fromValue(this.contentType);
    }

    public final String contentTypeAsString() {
        return this.contentType;
    }

    public final SdkBytes vnfd() {
        return this.vnfd;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vnfd());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolFunctionPackageDescriptorResponse)) {
            return false;
        }
        GetSolFunctionPackageDescriptorResponse other = (GetSolFunctionPackageDescriptorResponse)((Object)obj);
        return Objects.equals(this.contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(this.vnfd(), other.vnfd());
    }

    public final String toString() {
        return ToString.builder((String)"GetSolFunctionPackageDescriptorResponse").add("ContentType", (Object)this.contentTypeAsString()).add("Vnfd", (Object)this.vnfd()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentTypeAsString()));
            }
            case "vnfd": {
                return Optional.ofNullable(clazz.cast(this.vnfd()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("vnfd", VNFD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSolFunctionPackageDescriptorResponse, T> g) {
        return obj -> g.apply((GetSolFunctionPackageDescriptorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbResponse.BuilderImpl
    implements Builder {
        private String contentType;
        private SdkBytes vnfd;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolFunctionPackageDescriptorResponse model) {
            super(model);
            this.contentType(model.contentType);
            this.vnfd(model.vnfd);
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(DescriptorContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final ByteBuffer getVnfd() {
            return this.vnfd == null ? null : this.vnfd.asByteBuffer();
        }

        public final void setVnfd(ByteBuffer vnfd) {
            this.vnfd(vnfd == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)vnfd));
        }

        @Override
        public final Builder vnfd(SdkBytes vnfd) {
            this.vnfd = vnfd;
            return this;
        }

        @Override
        public GetSolFunctionPackageDescriptorResponse build() {
            return new GetSolFunctionPackageDescriptorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TnbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSolFunctionPackageDescriptorResponse> {
        public Builder contentType(String var1);

        public Builder contentType(DescriptorContentType var1);

        public Builder vnfd(SdkBytes var1);
    }
}

