/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionInstanceMetadata;
import software.amazon.awssdk.services.tnb.model.GetSolVnfInfo;
import software.amazon.awssdk.services.tnb.model.TagMapCopier;
import software.amazon.awssdk.services.tnb.model.TnbResponse;
import software.amazon.awssdk.services.tnb.model.VnfInstantiationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSolFunctionInstanceResponse
extends TnbResponse
implements ToCopyableBuilder<Builder, GetSolFunctionInstanceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetSolFunctionInstanceResponse.getter(GetSolFunctionInstanceResponse::arn)).setter(GetSolFunctionInstanceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetSolFunctionInstanceResponse.getter(GetSolFunctionInstanceResponse::id)).setter(GetSolFunctionInstanceResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<GetSolVnfInfo> INSTANTIATED_VNF_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instantiatedVnfInfo").getter(GetSolFunctionInstanceResponse.getter(GetSolFunctionInstanceResponse::instantiatedVnfInfo)).setter(GetSolFunctionInstanceResponse.setter(Builder::instantiatedVnfInfo)).constructor(GetSolVnfInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instantiatedVnfInfo").build()}).build();
    private static final SdkField<String> INSTANTIATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instantiationState").getter(GetSolFunctionInstanceResponse.getter(GetSolFunctionInstanceResponse::instantiationStateAsString)).setter(GetSolFunctionInstanceResponse.setter(Builder::instantiationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instantiationState").build()}).build();
    private static final SdkField<GetSolFunctionInstanceMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(GetSolFunctionInstanceResponse.getter(GetSolFunctionInstanceResponse::metadata)).setter(GetSolFunctionInstanceResponse.setter(Builder::metadata)).constructor(GetSolFunctionInstanceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<String> NS_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsInstanceId").getter(GetSolFunctionInstanceResponse.getter(GetSolFunctionInstanceResponse::nsInstanceId)).setter(GetSolFunctionInstanceResponse.setter(Builder::nsInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsInstanceId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetSolFunctionInstanceResponse.getter(GetSolFunctionInstanceResponse::tags)).setter(GetSolFunctionInstanceResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> VNF_PKG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vnfPkgId").getter(GetSolFunctionInstanceResponse.getter(GetSolFunctionInstanceResponse::vnfPkgId)).setter(GetSolFunctionInstanceResponse.setter(Builder::vnfPkgId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfPkgId").build()}).build();
    private static final SdkField<String> VNF_PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vnfProductName").getter(GetSolFunctionInstanceResponse.getter(GetSolFunctionInstanceResponse::vnfProductName)).setter(GetSolFunctionInstanceResponse.setter(Builder::vnfProductName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfProductName").build()}).build();
    private static final SdkField<String> VNF_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vnfProvider").getter(GetSolFunctionInstanceResponse.getter(GetSolFunctionInstanceResponse::vnfProvider)).setter(GetSolFunctionInstanceResponse.setter(Builder::vnfProvider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfProvider").build()}).build();
    private static final SdkField<String> VNFD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vnfdId").getter(GetSolFunctionInstanceResponse.getter(GetSolFunctionInstanceResponse::vnfdId)).setter(GetSolFunctionInstanceResponse.setter(Builder::vnfdId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfdId").build()}).build();
    private static final SdkField<String> VNFD_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vnfdVersion").getter(GetSolFunctionInstanceResponse.getter(GetSolFunctionInstanceResponse::vnfdVersion)).setter(GetSolFunctionInstanceResponse.setter(Builder::vnfdVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfdVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, INSTANTIATED_VNF_INFO_FIELD, INSTANTIATION_STATE_FIELD, METADATA_FIELD, NS_INSTANCE_ID_FIELD, TAGS_FIELD, VNF_PKG_ID_FIELD, VNF_PRODUCT_NAME_FIELD, VNF_PROVIDER_FIELD, VNFD_ID_FIELD, VNFD_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSolFunctionInstanceResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String id;
    private final GetSolVnfInfo instantiatedVnfInfo;
    private final String instantiationState;
    private final GetSolFunctionInstanceMetadata metadata;
    private final String nsInstanceId;
    private final Map<String, String> tags;
    private final String vnfPkgId;
    private final String vnfProductName;
    private final String vnfProvider;
    private final String vnfdId;
    private final String vnfdVersion;

    private GetSolFunctionInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.instantiatedVnfInfo = builder.instantiatedVnfInfo;
        this.instantiationState = builder.instantiationState;
        this.metadata = builder.metadata;
        this.nsInstanceId = builder.nsInstanceId;
        this.tags = builder.tags;
        this.vnfPkgId = builder.vnfPkgId;
        this.vnfProductName = builder.vnfProductName;
        this.vnfProvider = builder.vnfProvider;
        this.vnfdId = builder.vnfdId;
        this.vnfdVersion = builder.vnfdVersion;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final GetSolVnfInfo instantiatedVnfInfo() {
        return this.instantiatedVnfInfo;
    }

    public final VnfInstantiationState instantiationState() {
        return VnfInstantiationState.fromValue(this.instantiationState);
    }

    public final String instantiationStateAsString() {
        return this.instantiationState;
    }

    public final GetSolFunctionInstanceMetadata metadata() {
        return this.metadata;
    }

    public final String nsInstanceId() {
        return this.nsInstanceId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String vnfPkgId() {
        return this.vnfPkgId;
    }

    public final String vnfProductName() {
        return this.vnfProductName;
    }

    public final String vnfProvider() {
        return this.vnfProvider;
    }

    public final String vnfdId() {
        return this.vnfdId;
    }

    public final String vnfdVersion() {
        return this.vnfdVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.instantiatedVnfInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.instantiationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vnfPkgId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vnfProductName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vnfProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.vnfdId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vnfdVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolFunctionInstanceResponse)) {
            return false;
        }
        GetSolFunctionInstanceResponse other = (GetSolFunctionInstanceResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.instantiatedVnfInfo(), other.instantiatedVnfInfo()) && Objects.equals(this.instantiationStateAsString(), other.instantiationStateAsString()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.nsInstanceId(), other.nsInstanceId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vnfPkgId(), other.vnfPkgId()) && Objects.equals(this.vnfProductName(), other.vnfProductName()) && Objects.equals(this.vnfProvider(), other.vnfProvider()) && Objects.equals(this.vnfdId(), other.vnfdId()) && Objects.equals(this.vnfdVersion(), other.vnfdVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetSolFunctionInstanceResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("InstantiatedVnfInfo", (Object)this.instantiatedVnfInfo()).add("InstantiationState", (Object)this.instantiationStateAsString()).add("Metadata", (Object)this.metadata()).add("NsInstanceId", (Object)this.nsInstanceId()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("VnfPkgId", (Object)this.vnfPkgId()).add("VnfProductName", (Object)this.vnfProductName()).add("VnfProvider", (Object)this.vnfProvider()).add("VnfdId", (Object)this.vnfdId()).add("VnfdVersion", (Object)this.vnfdVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "instantiatedVnfInfo": {
                return Optional.ofNullable(clazz.cast(this.instantiatedVnfInfo()));
            }
            case "instantiationState": {
                return Optional.ofNullable(clazz.cast(this.instantiationStateAsString()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "nsInstanceId": {
                return Optional.ofNullable(clazz.cast(this.nsInstanceId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "vnfPkgId": {
                return Optional.ofNullable(clazz.cast(this.vnfPkgId()));
            }
            case "vnfProductName": {
                return Optional.ofNullable(clazz.cast(this.vnfProductName()));
            }
            case "vnfProvider": {
                return Optional.ofNullable(clazz.cast(this.vnfProvider()));
            }
            case "vnfdId": {
                return Optional.ofNullable(clazz.cast(this.vnfdId()));
            }
            case "vnfdVersion": {
                return Optional.ofNullable(clazz.cast(this.vnfdVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("instantiatedVnfInfo", INSTANTIATED_VNF_INFO_FIELD);
        map.put("instantiationState", INSTANTIATION_STATE_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("nsInstanceId", NS_INSTANCE_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("vnfPkgId", VNF_PKG_ID_FIELD);
        map.put("vnfProductName", VNF_PRODUCT_NAME_FIELD);
        map.put("vnfProvider", VNF_PROVIDER_FIELD);
        map.put("vnfdId", VNFD_ID_FIELD);
        map.put("vnfdVersion", VNFD_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSolFunctionInstanceResponse, T> g) {
        return obj -> g.apply((GetSolFunctionInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private GetSolVnfInfo instantiatedVnfInfo;
        private String instantiationState;
        private GetSolFunctionInstanceMetadata metadata;
        private String nsInstanceId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String vnfPkgId;
        private String vnfProductName;
        private String vnfProvider;
        private String vnfdId;
        private String vnfdVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolFunctionInstanceResponse model) {
            super(model);
            this.arn(model.arn);
            this.id(model.id);
            this.instantiatedVnfInfo(model.instantiatedVnfInfo);
            this.instantiationState(model.instantiationState);
            this.metadata(model.metadata);
            this.nsInstanceId(model.nsInstanceId);
            this.tags(model.tags);
            this.vnfPkgId(model.vnfPkgId);
            this.vnfProductName(model.vnfProductName);
            this.vnfProvider(model.vnfProvider);
            this.vnfdId(model.vnfdId);
            this.vnfdVersion(model.vnfdVersion);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final GetSolVnfInfo.Builder getInstantiatedVnfInfo() {
            return this.instantiatedVnfInfo != null ? this.instantiatedVnfInfo.toBuilder() : null;
        }

        public final void setInstantiatedVnfInfo(GetSolVnfInfo.BuilderImpl instantiatedVnfInfo) {
            this.instantiatedVnfInfo = instantiatedVnfInfo != null ? instantiatedVnfInfo.build() : null;
        }

        @Override
        public final Builder instantiatedVnfInfo(GetSolVnfInfo instantiatedVnfInfo) {
            this.instantiatedVnfInfo = instantiatedVnfInfo;
            return this;
        }

        public final String getInstantiationState() {
            return this.instantiationState;
        }

        public final void setInstantiationState(String instantiationState) {
            this.instantiationState = instantiationState;
        }

        @Override
        public final Builder instantiationState(String instantiationState) {
            this.instantiationState = instantiationState;
            return this;
        }

        @Override
        public final Builder instantiationState(VnfInstantiationState instantiationState) {
            this.instantiationState(instantiationState == null ? null : instantiationState.toString());
            return this;
        }

        public final GetSolFunctionInstanceMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(GetSolFunctionInstanceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(GetSolFunctionInstanceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getNsInstanceId() {
            return this.nsInstanceId;
        }

        public final void setNsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
        }

        @Override
        public final Builder nsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getVnfPkgId() {
            return this.vnfPkgId;
        }

        public final void setVnfPkgId(String vnfPkgId) {
            this.vnfPkgId = vnfPkgId;
        }

        @Override
        public final Builder vnfPkgId(String vnfPkgId) {
            this.vnfPkgId = vnfPkgId;
            return this;
        }

        public final String getVnfProductName() {
            return this.vnfProductName;
        }

        public final void setVnfProductName(String vnfProductName) {
            this.vnfProductName = vnfProductName;
        }

        @Override
        public final Builder vnfProductName(String vnfProductName) {
            this.vnfProductName = vnfProductName;
            return this;
        }

        public final String getVnfProvider() {
            return this.vnfProvider;
        }

        public final void setVnfProvider(String vnfProvider) {
            this.vnfProvider = vnfProvider;
        }

        @Override
        public final Builder vnfProvider(String vnfProvider) {
            this.vnfProvider = vnfProvider;
            return this;
        }

        public final String getVnfdId() {
            return this.vnfdId;
        }

        public final void setVnfdId(String vnfdId) {
            this.vnfdId = vnfdId;
        }

        @Override
        public final Builder vnfdId(String vnfdId) {
            this.vnfdId = vnfdId;
            return this;
        }

        public final String getVnfdVersion() {
            return this.vnfdVersion;
        }

        public final void setVnfdVersion(String vnfdVersion) {
            this.vnfdVersion = vnfdVersion;
        }

        @Override
        public final Builder vnfdVersion(String vnfdVersion) {
            this.vnfdVersion = vnfdVersion;
            return this;
        }

        @Override
        public GetSolFunctionInstanceResponse build() {
            return new GetSolFunctionInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TnbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSolFunctionInstanceResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder instantiatedVnfInfo(GetSolVnfInfo var1);

        default public Builder instantiatedVnfInfo(Consumer<GetSolVnfInfo.Builder> instantiatedVnfInfo) {
            return this.instantiatedVnfInfo((GetSolVnfInfo)((GetSolVnfInfo.Builder)GetSolVnfInfo.builder().applyMutation(instantiatedVnfInfo)).build());
        }

        public Builder instantiationState(String var1);

        public Builder instantiationState(VnfInstantiationState var1);

        public Builder metadata(GetSolFunctionInstanceMetadata var1);

        default public Builder metadata(Consumer<GetSolFunctionInstanceMetadata.Builder> metadata) {
            return this.metadata((GetSolFunctionInstanceMetadata)((GetSolFunctionInstanceMetadata.Builder)GetSolFunctionInstanceMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder nsInstanceId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder vnfPkgId(String var1);

        public Builder vnfProductName(String var1);

        public Builder vnfProvider(String var1);

        public Builder vnfdId(String var1);

        public Builder vnfdVersion(String var1);
    }
}

