/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSolNetworkOperationResponse extends TnbResponse implements
        ToCopyableBuilder<GetSolNetworkOperationResponse.Builder, GetSolNetworkOperationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetSolNetworkOperationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<ProblemDetails> ERROR_FIELD = SdkField.<ProblemDetails> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(GetSolNetworkOperationResponse::error)).setter(setter(Builder::error))
            .constructor(ProblemDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetSolNetworkOperationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> LCM_OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lcmOperationType").getter(getter(GetSolNetworkOperationResponse::lcmOperationTypeAsString))
            .setter(setter(Builder::lcmOperationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lcmOperationType").build()).build();

    private static final SdkField<GetSolNetworkOperationMetadata> METADATA_FIELD = SdkField
            .<GetSolNetworkOperationMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(GetSolNetworkOperationResponse::metadata)).setter(setter(Builder::metadata))
            .constructor(GetSolNetworkOperationMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<String> NS_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsInstanceId").getter(getter(GetSolNetworkOperationResponse::nsInstanceId))
            .setter(setter(Builder::nsInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsInstanceId").build()).build();

    private static final SdkField<String> OPERATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationState").getter(getter(GetSolNetworkOperationResponse::operationStateAsString))
            .setter(setter(Builder::operationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationState").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetSolNetworkOperationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<GetSolNetworkOperationTaskDetails>> TASKS_FIELD = SdkField
            .<List<GetSolNetworkOperationTaskDetails>> builder(MarshallingType.LIST)
            .memberName("tasks")
            .getter(getter(GetSolNetworkOperationResponse::tasks))
            .setter(setter(Builder::tasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GetSolNetworkOperationTaskDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(GetSolNetworkOperationTaskDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updateType").getter(getter(GetSolNetworkOperationResponse::updateTypeAsString))
            .setter(setter(Builder::updateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ERROR_FIELD,
            ID_FIELD, LCM_OPERATION_TYPE_FIELD, METADATA_FIELD, NS_INSTANCE_ID_FIELD, OPERATION_STATE_FIELD, TAGS_FIELD,
            TASKS_FIELD, UPDATE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final ProblemDetails error;

    private final String id;

    private final String lcmOperationType;

    private final GetSolNetworkOperationMetadata metadata;

    private final String nsInstanceId;

    private final String operationState;

    private final Map<String, String> tags;

    private final List<GetSolNetworkOperationTaskDetails> tasks;

    private final String updateType;

    private GetSolNetworkOperationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.error = builder.error;
        this.id = builder.id;
        this.lcmOperationType = builder.lcmOperationType;
        this.metadata = builder.metadata;
        this.nsInstanceId = builder.nsInstanceId;
        this.operationState = builder.operationState;
        this.tags = builder.tags;
        this.tasks = builder.tasks;
        this.updateType = builder.updateType;
    }

    /**
     * <p>
     * Network operation ARN.
     * </p>
     * 
     * @return Network operation ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Error related to this specific network operation occurrence.
     * </p>
     * 
     * @return Error related to this specific network operation occurrence.
     */
    public final ProblemDetails error() {
        return error;
    }

    /**
     * <p>
     * ID of this network operation occurrence.
     * </p>
     * 
     * @return ID of this network operation occurrence.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Type of the operation represented by this occurrence.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lcmOperationType}
     * will return {@link LcmOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lcmOperationTypeAsString}.
     * </p>
     * 
     * @return Type of the operation represented by this occurrence.
     * @see LcmOperationType
     */
    public final LcmOperationType lcmOperationType() {
        return LcmOperationType.fromValue(lcmOperationType);
    }

    /**
     * <p>
     * Type of the operation represented by this occurrence.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lcmOperationType}
     * will return {@link LcmOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lcmOperationTypeAsString}.
     * </p>
     * 
     * @return Type of the operation represented by this occurrence.
     * @see LcmOperationType
     */
    public final String lcmOperationTypeAsString() {
        return lcmOperationType;
    }

    /**
     * <p>
     * Metadata of this network operation occurrence.
     * </p>
     * 
     * @return Metadata of this network operation occurrence.
     */
    public final GetSolNetworkOperationMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * ID of the network operation instance.
     * </p>
     * 
     * @return ID of the network operation instance.
     */
    public final String nsInstanceId() {
        return nsInstanceId;
    }

    /**
     * <p>
     * The state of the network operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationState}
     * will return {@link NsLcmOperationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationStateAsString}.
     * </p>
     * 
     * @return The state of the network operation.
     * @see NsLcmOperationState
     */
    public final NsLcmOperationState operationState() {
        return NsLcmOperationState.fromValue(operationState);
    }

    /**
     * <p>
     * The state of the network operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationState}
     * will return {@link NsLcmOperationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationStateAsString}.
     * </p>
     * 
     * @return The state of the network operation.
     * @see NsLcmOperationState
     */
    public final String operationStateAsString() {
        return operationState;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
     *         optional value. You can use tags to search and filter your resources or track your Amazon Web Services
     *         costs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tasks property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTasks() {
        return tasks != null && !(tasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * All tasks associated with this operation occurrence.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTasks} method.
     * </p>
     * 
     * @return All tasks associated with this operation occurrence.
     */
    public final List<GetSolNetworkOperationTaskDetails> tasks() {
        return tasks;
    }

    /**
     * <p>
     * Type of the update. Only present if the network operation lcmOperationType is <code>UPDATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link UpdateSolNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateTypeAsString}.
     * </p>
     * 
     * @return Type of the update. Only present if the network operation lcmOperationType is <code>UPDATE</code>.
     * @see UpdateSolNetworkType
     */
    public final UpdateSolNetworkType updateType() {
        return UpdateSolNetworkType.fromValue(updateType);
    }

    /**
     * <p>
     * Type of the update. Only present if the network operation lcmOperationType is <code>UPDATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link UpdateSolNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateTypeAsString}.
     * </p>
     * 
     * @return Type of the update. Only present if the network operation lcmOperationType is <code>UPDATE</code>.
     * @see UpdateSolNetworkType
     */
    public final String updateTypeAsString() {
        return updateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lcmOperationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(nsInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(operationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTasks() ? tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updateTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolNetworkOperationResponse)) {
            return false;
        }
        GetSolNetworkOperationResponse other = (GetSolNetworkOperationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(error(), other.error()) && Objects.equals(id(), other.id())
                && Objects.equals(lcmOperationTypeAsString(), other.lcmOperationTypeAsString())
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(nsInstanceId(), other.nsInstanceId())
                && Objects.equals(operationStateAsString(), other.operationStateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasTasks() == other.hasTasks()
                && Objects.equals(tasks(), other.tasks()) && Objects.equals(updateTypeAsString(), other.updateTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSolNetworkOperationResponse").add("Arn", arn()).add("Error", error()).add("Id", id())
                .add("LcmOperationType", lcmOperationTypeAsString()).add("Metadata", metadata())
                .add("NsInstanceId", nsInstanceId()).add("OperationState", operationStateAsString())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").add("Tasks", hasTasks() ? tasks() : null)
                .add("UpdateType", updateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lcmOperationType":
            return Optional.ofNullable(clazz.cast(lcmOperationTypeAsString()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "nsInstanceId":
            return Optional.ofNullable(clazz.cast(nsInstanceId()));
        case "operationState":
            return Optional.ofNullable(clazz.cast(operationStateAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "tasks":
            return Optional.ofNullable(clazz.cast(tasks()));
        case "updateType":
            return Optional.ofNullable(clazz.cast(updateTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("id", ID_FIELD);
        map.put("lcmOperationType", LCM_OPERATION_TYPE_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("nsInstanceId", NS_INSTANCE_ID_FIELD);
        map.put("operationState", OPERATION_STATE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("tasks", TASKS_FIELD);
        map.put("updateType", UPDATE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSolNetworkOperationResponse, T> g) {
        return obj -> g.apply((GetSolNetworkOperationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TnbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSolNetworkOperationResponse> {
        /**
         * <p>
         * Network operation ARN.
         * </p>
         * 
         * @param arn
         *        Network operation ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Error related to this specific network operation occurrence.
         * </p>
         * 
         * @param error
         *        Error related to this specific network operation occurrence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ProblemDetails error);

        /**
         * <p>
         * Error related to this specific network operation occurrence.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProblemDetails.Builder} avoiding the need
         * to create one manually via {@link ProblemDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProblemDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #error(ProblemDetails)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ProblemDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ProblemDetails)
         */
        default Builder error(Consumer<ProblemDetails.Builder> error) {
            return error(ProblemDetails.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * ID of this network operation occurrence.
         * </p>
         * 
         * @param id
         *        ID of this network operation occurrence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Type of the operation represented by this occurrence.
         * </p>
         * 
         * @param lcmOperationType
         *        Type of the operation represented by this occurrence.
         * @see LcmOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LcmOperationType
         */
        Builder lcmOperationType(String lcmOperationType);

        /**
         * <p>
         * Type of the operation represented by this occurrence.
         * </p>
         * 
         * @param lcmOperationType
         *        Type of the operation represented by this occurrence.
         * @see LcmOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LcmOperationType
         */
        Builder lcmOperationType(LcmOperationType lcmOperationType);

        /**
         * <p>
         * Metadata of this network operation occurrence.
         * </p>
         * 
         * @param metadata
         *        Metadata of this network operation occurrence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(GetSolNetworkOperationMetadata metadata);

        /**
         * <p>
         * Metadata of this network operation occurrence.
         * </p>
         * This is a convenience method that creates an instance of the {@link GetSolNetworkOperationMetadata.Builder}
         * avoiding the need to create one manually via {@link GetSolNetworkOperationMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GetSolNetworkOperationMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(GetSolNetworkOperationMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link GetSolNetworkOperationMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(GetSolNetworkOperationMetadata)
         */
        default Builder metadata(Consumer<GetSolNetworkOperationMetadata.Builder> metadata) {
            return metadata(GetSolNetworkOperationMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * ID of the network operation instance.
         * </p>
         * 
         * @param nsInstanceId
         *        ID of the network operation instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsInstanceId(String nsInstanceId);

        /**
         * <p>
         * The state of the network operation.
         * </p>
         * 
         * @param operationState
         *        The state of the network operation.
         * @see NsLcmOperationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsLcmOperationState
         */
        Builder operationState(String operationState);

        /**
         * <p>
         * The state of the network operation.
         * </p>
         * 
         * @param operationState
         *        The state of the network operation.
         * @see NsLcmOperationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsLcmOperationState
         */
        Builder operationState(NsLcmOperationState operationState);

        /**
         * <p>
         * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         * optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
         * </p>
         * 
         * @param tags
         *        A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         *        optional value. You can use tags to search and filter your resources or track your Amazon Web Services
         *        costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * All tasks associated with this operation occurrence.
         * </p>
         * 
         * @param tasks
         *        All tasks associated with this operation occurrence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(Collection<GetSolNetworkOperationTaskDetails> tasks);

        /**
         * <p>
         * All tasks associated with this operation occurrence.
         * </p>
         * 
         * @param tasks
         *        All tasks associated with this operation occurrence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(GetSolNetworkOperationTaskDetails... tasks);

        /**
         * <p>
         * All tasks associated with this operation occurrence.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.tnb.model.GetSolNetworkOperationTaskDetails.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.tnb.model.GetSolNetworkOperationTaskDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.tnb.model.GetSolNetworkOperationTaskDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #tasks(List<GetSolNetworkOperationTaskDetails>)}.
         * 
         * @param tasks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.tnb.model.GetSolNetworkOperationTaskDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tasks(java.util.Collection<GetSolNetworkOperationTaskDetails>)
         */
        Builder tasks(Consumer<GetSolNetworkOperationTaskDetails.Builder>... tasks);

        /**
         * <p>
         * Type of the update. Only present if the network operation lcmOperationType is <code>UPDATE</code>.
         * </p>
         * 
         * @param updateType
         *        Type of the update. Only present if the network operation lcmOperationType is <code>UPDATE</code>.
         * @see UpdateSolNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateSolNetworkType
         */
        Builder updateType(String updateType);

        /**
         * <p>
         * Type of the update. Only present if the network operation lcmOperationType is <code>UPDATE</code>.
         * </p>
         * 
         * @param updateType
         *        Type of the update. Only present if the network operation lcmOperationType is <code>UPDATE</code>.
         * @see UpdateSolNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateSolNetworkType
         */
        Builder updateType(UpdateSolNetworkType updateType);
    }

    static final class BuilderImpl extends TnbResponse.BuilderImpl implements Builder {
        private String arn;

        private ProblemDetails error;

        private String id;

        private String lcmOperationType;

        private GetSolNetworkOperationMetadata metadata;

        private String nsInstanceId;

        private String operationState;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<GetSolNetworkOperationTaskDetails> tasks = DefaultSdkAutoConstructList.getInstance();

        private String updateType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolNetworkOperationResponse model) {
            super(model);
            arn(model.arn);
            error(model.error);
            id(model.id);
            lcmOperationType(model.lcmOperationType);
            metadata(model.metadata);
            nsInstanceId(model.nsInstanceId);
            operationState(model.operationState);
            tags(model.tags);
            tasks(model.tasks);
            updateType(model.updateType);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final ProblemDetails.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ProblemDetails.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ProblemDetails error) {
            this.error = error;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLcmOperationType() {
            return lcmOperationType;
        }

        public final void setLcmOperationType(String lcmOperationType) {
            this.lcmOperationType = lcmOperationType;
        }

        @Override
        public final Builder lcmOperationType(String lcmOperationType) {
            this.lcmOperationType = lcmOperationType;
            return this;
        }

        @Override
        public final Builder lcmOperationType(LcmOperationType lcmOperationType) {
            this.lcmOperationType(lcmOperationType == null ? null : lcmOperationType.toString());
            return this;
        }

        public final GetSolNetworkOperationMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(GetSolNetworkOperationMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(GetSolNetworkOperationMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getNsInstanceId() {
            return nsInstanceId;
        }

        public final void setNsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
        }

        @Override
        public final Builder nsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
            return this;
        }

        public final String getOperationState() {
            return operationState;
        }

        public final void setOperationState(String operationState) {
            this.operationState = operationState;
        }

        @Override
        public final Builder operationState(String operationState) {
            this.operationState = operationState;
            return this;
        }

        @Override
        public final Builder operationState(NsLcmOperationState operationState) {
            this.operationState(operationState == null ? null : operationState.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<GetSolNetworkOperationTaskDetails.Builder> getTasks() {
            List<GetSolNetworkOperationTaskDetails.Builder> result = GetSolNetworkOperationTasksListCopier
                    .copyToBuilder(this.tasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTasks(Collection<GetSolNetworkOperationTaskDetails.BuilderImpl> tasks) {
            this.tasks = GetSolNetworkOperationTasksListCopier.copyFromBuilder(tasks);
        }

        @Override
        public final Builder tasks(Collection<GetSolNetworkOperationTaskDetails> tasks) {
            this.tasks = GetSolNetworkOperationTasksListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(GetSolNetworkOperationTaskDetails... tasks) {
            tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<GetSolNetworkOperationTaskDetails.Builder>... tasks) {
            tasks(Stream.of(tasks).map(c -> GetSolNetworkOperationTaskDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getUpdateType() {
            return updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(UpdateSolNetworkType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        @Override
        public GetSolNetworkOperationResponse build() {
            return new GetSolNetworkOperationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
