/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSolNetworkPackageContentResponse extends TnbResponse implements
        ToCopyableBuilder<GetSolNetworkPackageContentResponse.Builder, GetSolNetworkPackageContentResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(GetSolNetworkPackageContentResponse::contentTypeAsString))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<SdkBytes> NSD_CONTENT_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("nsdContent")
            .getter(getter(GetSolNetworkPackageContentResponse::nsdContent))
            .setter(setter(Builder::nsdContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdContent").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            NSD_CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String contentType;

    private final SdkBytes nsdContent;

    private GetSolNetworkPackageContentResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.nsdContent = builder.nsdContent;
    }

    /**
     * <p>
     * Indicates the media type of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link PackageContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return Indicates the media type of the resource.
     * @see PackageContentType
     */
    public final PackageContentType contentType() {
        return PackageContentType.fromValue(contentType);
    }

    /**
     * <p>
     * Indicates the media type of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link PackageContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return Indicates the media type of the resource.
     * @see PackageContentType
     */
    public final String contentTypeAsString() {
        return contentType;
    }

    /**
     * <p>
     * Content of the network service descriptor in the network package.
     * </p>
     * 
     * @return Content of the network service descriptor in the network package.
     */
    public final SdkBytes nsdContent() {
        return nsdContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nsdContent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolNetworkPackageContentResponse)) {
            return false;
        }
        GetSolNetworkPackageContentResponse other = (GetSolNetworkPackageContentResponse) obj;
        return Objects.equals(contentTypeAsString(), other.contentTypeAsString())
                && Objects.equals(nsdContent(), other.nsdContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSolNetworkPackageContentResponse").add("ContentType", contentTypeAsString())
                .add("NsdContent", nsdContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        case "nsdContent":
            return Optional.ofNullable(clazz.cast(nsdContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("nsdContent", NSD_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSolNetworkPackageContentResponse, T> g) {
        return obj -> g.apply((GetSolNetworkPackageContentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TnbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSolNetworkPackageContentResponse> {
        /**
         * <p>
         * Indicates the media type of the resource.
         * </p>
         * 
         * @param contentType
         *        Indicates the media type of the resource.
         * @see PackageContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageContentType
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Indicates the media type of the resource.
         * </p>
         * 
         * @param contentType
         *        Indicates the media type of the resource.
         * @see PackageContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageContentType
         */
        Builder contentType(PackageContentType contentType);

        /**
         * <p>
         * Content of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdContent
         *        Content of the network service descriptor in the network package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdContent(SdkBytes nsdContent);
    }

    static final class BuilderImpl extends TnbResponse.BuilderImpl implements Builder {
        private String contentType;

        private SdkBytes nsdContent;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolNetworkPackageContentResponse model) {
            super(model);
            contentType(model.contentType);
            nsdContent(model.nsdContent);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(PackageContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final ByteBuffer getNsdContent() {
            return nsdContent == null ? null : nsdContent.asByteBuffer();
        }

        public final void setNsdContent(ByteBuffer nsdContent) {
            nsdContent(nsdContent == null ? null : SdkBytes.fromByteBuffer(nsdContent));
        }

        @Override
        public final Builder nsdContent(SdkBytes nsdContent) {
            this.nsdContent = nsdContent;
            return this;
        }

        @Override
        public GetSolNetworkPackageContentResponse build() {
            return new GetSolNetworkPackageContentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
