/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata of a network function.
 * </p>
 * <p>
 * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
 * life-cycle operations (like terminate, update, and delete) can be performed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSolVnfcResourceInfoMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<GetSolVnfcResourceInfoMetadata.Builder, GetSolVnfcResourceInfoMetadata> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(GetSolVnfcResourceInfoMetadata::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> HELM_CHART_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("helmChart").getter(getter(GetSolVnfcResourceInfoMetadata::helmChart)).setter(setter(Builder::helmChart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("helmChart").build()).build();

    private static final SdkField<String> NODE_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeGroup").getter(getter(GetSolVnfcResourceInfoMetadata::nodeGroup)).setter(setter(Builder::nodeGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD,
            HELM_CHART_FIELD, NODE_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cluster;

    private final String helmChart;

    private final String nodeGroup;

    private GetSolVnfcResourceInfoMetadata(BuilderImpl builder) {
        this.cluster = builder.cluster;
        this.helmChart = builder.helmChart;
        this.nodeGroup = builder.nodeGroup;
    }

    /**
     * <p>
     * Information about the cluster.
     * </p>
     * 
     * @return Information about the cluster.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * <p>
     * Information about the helm chart.
     * </p>
     * 
     * @return Information about the helm chart.
     */
    public final String helmChart() {
        return helmChart;
    }

    /**
     * <p>
     * Information about the node group.
     * </p>
     * 
     * @return Information about the node group.
     */
    public final String nodeGroup() {
        return nodeGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(helmChart());
        hashCode = 31 * hashCode + Objects.hashCode(nodeGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolVnfcResourceInfoMetadata)) {
            return false;
        }
        GetSolVnfcResourceInfoMetadata other = (GetSolVnfcResourceInfoMetadata) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(helmChart(), other.helmChart())
                && Objects.equals(nodeGroup(), other.nodeGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSolVnfcResourceInfoMetadata").add("Cluster", cluster()).add("HelmChart", helmChart())
                .add("NodeGroup", nodeGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "helmChart":
            return Optional.ofNullable(clazz.cast(helmChart()));
        case "nodeGroup":
            return Optional.ofNullable(clazz.cast(nodeGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cluster", CLUSTER_FIELD);
        map.put("helmChart", HELM_CHART_FIELD);
        map.put("nodeGroup", NODE_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSolVnfcResourceInfoMetadata, T> g) {
        return obj -> g.apply((GetSolVnfcResourceInfoMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GetSolVnfcResourceInfoMetadata> {
        /**
         * <p>
         * Information about the cluster.
         * </p>
         * 
         * @param cluster
         *        Information about the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * Information about the helm chart.
         * </p>
         * 
         * @param helmChart
         *        Information about the helm chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder helmChart(String helmChart);

        /**
         * <p>
         * Information about the node group.
         * </p>
         * 
         * @param nodeGroup
         *        Information about the node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroup(String nodeGroup);
    }

    static final class BuilderImpl implements Builder {
        private String cluster;

        private String helmChart;

        private String nodeGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolVnfcResourceInfoMetadata model) {
            cluster(model.cluster);
            helmChart(model.helmChart);
            nodeGroup(model.nodeGroup);
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getHelmChart() {
            return helmChart;
        }

        public final void setHelmChart(String helmChart) {
            this.helmChart = helmChart;
        }

        @Override
        public final Builder helmChart(String helmChart) {
            this.helmChart = helmChart;
            return this;
        }

        public final String getNodeGroup() {
            return nodeGroup;
        }

        public final void setNodeGroup(String nodeGroup) {
            this.nodeGroup = nodeGroup;
        }

        @Override
        public final Builder nodeGroup(String nodeGroup) {
            this.nodeGroup = nodeGroup;
            return this;
        }

        @Override
        public GetSolVnfcResourceInfoMetadata build() {
            return new GetSolVnfcResourceInfoMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
