/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a function package.
 * </p>
 * <p>
 * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI
 * standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how
 * the network functions should run on your network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSolFunctionPackageInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ListSolFunctionPackageInfo.Builder, ListSolFunctionPackageInfo> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ListSolFunctionPackageInfo::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ListSolFunctionPackageInfo::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<ListSolFunctionPackageMetadata> METADATA_FIELD = SdkField
            .<ListSolFunctionPackageMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(ListSolFunctionPackageInfo::metadata)).setter(setter(Builder::metadata))
            .constructor(ListSolFunctionPackageMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<String> ONBOARDING_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("onboardingState").getter(getter(ListSolFunctionPackageInfo::onboardingStateAsString))
            .setter(setter(Builder::onboardingState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onboardingState").build()).build();

    private static final SdkField<String> OPERATIONAL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationalState").getter(getter(ListSolFunctionPackageInfo::operationalStateAsString))
            .setter(setter(Builder::operationalState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationalState").build()).build();

    private static final SdkField<String> USAGE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageState").getter(getter(ListSolFunctionPackageInfo::usageStateAsString))
            .setter(setter(Builder::usageState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageState").build()).build();

    private static final SdkField<String> VNF_PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfProductName").getter(getter(ListSolFunctionPackageInfo::vnfProductName))
            .setter(setter(Builder::vnfProductName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfProductName").build()).build();

    private static final SdkField<String> VNF_PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfProvider").getter(getter(ListSolFunctionPackageInfo::vnfProvider))
            .setter(setter(Builder::vnfProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfProvider").build()).build();

    private static final SdkField<String> VNFD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vnfdId")
            .getter(getter(ListSolFunctionPackageInfo::vnfdId)).setter(setter(Builder::vnfdId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfdId").build()).build();

    private static final SdkField<String> VNFD_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfdVersion").getter(getter(ListSolFunctionPackageInfo::vnfdVersion))
            .setter(setter(Builder::vnfdVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfdVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            METADATA_FIELD, ONBOARDING_STATE_FIELD, OPERATIONAL_STATE_FIELD, USAGE_STATE_FIELD, VNF_PRODUCT_NAME_FIELD,
            VNF_PROVIDER_FIELD, VNFD_ID_FIELD, VNFD_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final ListSolFunctionPackageMetadata metadata;

    private final String onboardingState;

    private final String operationalState;

    private final String usageState;

    private final String vnfProductName;

    private final String vnfProvider;

    private final String vnfdId;

    private final String vnfdVersion;

    private ListSolFunctionPackageInfo(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.metadata = builder.metadata;
        this.onboardingState = builder.onboardingState;
        this.operationalState = builder.operationalState;
        this.usageState = builder.usageState;
        this.vnfProductName = builder.vnfProductName;
        this.vnfProvider = builder.vnfProvider;
        this.vnfdId = builder.vnfdId;
        this.vnfdVersion = builder.vnfdVersion;
    }

    /**
     * <p>
     * Function package ARN.
     * </p>
     * 
     * @return Function package ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * ID of the function package.
     * </p>
     * 
     * @return ID of the function package.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The metadata of the function package.
     * </p>
     * 
     * @return The metadata of the function package.
     */
    public final ListSolFunctionPackageMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * Onboarding state of the function package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #onboardingState}
     * will return {@link OnboardingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #onboardingStateAsString}.
     * </p>
     * 
     * @return Onboarding state of the function package.
     * @see OnboardingState
     */
    public final OnboardingState onboardingState() {
        return OnboardingState.fromValue(onboardingState);
    }

    /**
     * <p>
     * Onboarding state of the function package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #onboardingState}
     * will return {@link OnboardingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #onboardingStateAsString}.
     * </p>
     * 
     * @return Onboarding state of the function package.
     * @see OnboardingState
     */
    public final String onboardingStateAsString() {
        return onboardingState;
    }

    /**
     * <p>
     * Operational state of the function package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationalState}
     * will return {@link OperationalState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operationalStateAsString}.
     * </p>
     * 
     * @return Operational state of the function package.
     * @see OperationalState
     */
    public final OperationalState operationalState() {
        return OperationalState.fromValue(operationalState);
    }

    /**
     * <p>
     * Operational state of the function package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationalState}
     * will return {@link OperationalState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operationalStateAsString}.
     * </p>
     * 
     * @return Operational state of the function package.
     * @see OperationalState
     */
    public final String operationalStateAsString() {
        return operationalState;
    }

    /**
     * <p>
     * Usage state of the function package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usageState} will
     * return {@link UsageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageStateAsString}.
     * </p>
     * 
     * @return Usage state of the function package.
     * @see UsageState
     */
    public final UsageState usageState() {
        return UsageState.fromValue(usageState);
    }

    /**
     * <p>
     * Usage state of the function package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usageState} will
     * return {@link UsageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageStateAsString}.
     * </p>
     * 
     * @return Usage state of the function package.
     * @see UsageState
     */
    public final String usageStateAsString() {
        return usageState;
    }

    /**
     * <p>
     * The product name for the network function.
     * </p>
     * 
     * @return The product name for the network function.
     */
    public final String vnfProductName() {
        return vnfProductName;
    }

    /**
     * <p>
     * Provider of the function package and the function package descriptor.
     * </p>
     * 
     * @return Provider of the function package and the function package descriptor.
     */
    public final String vnfProvider() {
        return vnfProvider;
    }

    /**
     * <p>
     * Identifies the function package and the function package descriptor.
     * </p>
     * 
     * @return Identifies the function package and the function package descriptor.
     */
    public final String vnfdId() {
        return vnfdId;
    }

    /**
     * <p>
     * Identifies the version of the function package descriptor.
     * </p>
     * 
     * @return Identifies the version of the function package descriptor.
     */
    public final String vnfdVersion() {
        return vnfdVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(onboardingStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(operationalStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(usageStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vnfProductName());
        hashCode = 31 * hashCode + Objects.hashCode(vnfProvider());
        hashCode = 31 * hashCode + Objects.hashCode(vnfdId());
        hashCode = 31 * hashCode + Objects.hashCode(vnfdVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolFunctionPackageInfo)) {
            return false;
        }
        ListSolFunctionPackageInfo other = (ListSolFunctionPackageInfo) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(metadata(), other.metadata())
                && Objects.equals(onboardingStateAsString(), other.onboardingStateAsString())
                && Objects.equals(operationalStateAsString(), other.operationalStateAsString())
                && Objects.equals(usageStateAsString(), other.usageStateAsString())
                && Objects.equals(vnfProductName(), other.vnfProductName()) && Objects.equals(vnfProvider(), other.vnfProvider())
                && Objects.equals(vnfdId(), other.vnfdId()) && Objects.equals(vnfdVersion(), other.vnfdVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSolFunctionPackageInfo").add("Arn", arn()).add("Id", id()).add("Metadata", metadata())
                .add("OnboardingState", onboardingStateAsString()).add("OperationalState", operationalStateAsString())
                .add("UsageState", usageStateAsString()).add("VnfProductName", vnfProductName())
                .add("VnfProvider", vnfProvider()).add("VnfdId", vnfdId()).add("VnfdVersion", vnfdVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "onboardingState":
            return Optional.ofNullable(clazz.cast(onboardingStateAsString()));
        case "operationalState":
            return Optional.ofNullable(clazz.cast(operationalStateAsString()));
        case "usageState":
            return Optional.ofNullable(clazz.cast(usageStateAsString()));
        case "vnfProductName":
            return Optional.ofNullable(clazz.cast(vnfProductName()));
        case "vnfProvider":
            return Optional.ofNullable(clazz.cast(vnfProvider()));
        case "vnfdId":
            return Optional.ofNullable(clazz.cast(vnfdId()));
        case "vnfdVersion":
            return Optional.ofNullable(clazz.cast(vnfdVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("onboardingState", ONBOARDING_STATE_FIELD);
        map.put("operationalState", OPERATIONAL_STATE_FIELD);
        map.put("usageState", USAGE_STATE_FIELD);
        map.put("vnfProductName", VNF_PRODUCT_NAME_FIELD);
        map.put("vnfProvider", VNF_PROVIDER_FIELD);
        map.put("vnfdId", VNFD_ID_FIELD);
        map.put("vnfdVersion", VNFD_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSolFunctionPackageInfo, T> g) {
        return obj -> g.apply((ListSolFunctionPackageInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListSolFunctionPackageInfo> {
        /**
         * <p>
         * Function package ARN.
         * </p>
         * 
         * @param arn
         *        Function package ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * ID of the function package.
         * </p>
         * 
         * @param id
         *        ID of the function package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The metadata of the function package.
         * </p>
         * 
         * @param metadata
         *        The metadata of the function package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(ListSolFunctionPackageMetadata metadata);

        /**
         * <p>
         * The metadata of the function package.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListSolFunctionPackageMetadata.Builder}
         * avoiding the need to create one manually via {@link ListSolFunctionPackageMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListSolFunctionPackageMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(ListSolFunctionPackageMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link ListSolFunctionPackageMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(ListSolFunctionPackageMetadata)
         */
        default Builder metadata(Consumer<ListSolFunctionPackageMetadata.Builder> metadata) {
            return metadata(ListSolFunctionPackageMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * Onboarding state of the function package.
         * </p>
         * 
         * @param onboardingState
         *        Onboarding state of the function package.
         * @see OnboardingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnboardingState
         */
        Builder onboardingState(String onboardingState);

        /**
         * <p>
         * Onboarding state of the function package.
         * </p>
         * 
         * @param onboardingState
         *        Onboarding state of the function package.
         * @see OnboardingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnboardingState
         */
        Builder onboardingState(OnboardingState onboardingState);

        /**
         * <p>
         * Operational state of the function package.
         * </p>
         * 
         * @param operationalState
         *        Operational state of the function package.
         * @see OperationalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationalState
         */
        Builder operationalState(String operationalState);

        /**
         * <p>
         * Operational state of the function package.
         * </p>
         * 
         * @param operationalState
         *        Operational state of the function package.
         * @see OperationalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationalState
         */
        Builder operationalState(OperationalState operationalState);

        /**
         * <p>
         * Usage state of the function package.
         * </p>
         * 
         * @param usageState
         *        Usage state of the function package.
         * @see UsageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageState
         */
        Builder usageState(String usageState);

        /**
         * <p>
         * Usage state of the function package.
         * </p>
         * 
         * @param usageState
         *        Usage state of the function package.
         * @see UsageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageState
         */
        Builder usageState(UsageState usageState);

        /**
         * <p>
         * The product name for the network function.
         * </p>
         * 
         * @param vnfProductName
         *        The product name for the network function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfProductName(String vnfProductName);

        /**
         * <p>
         * Provider of the function package and the function package descriptor.
         * </p>
         * 
         * @param vnfProvider
         *        Provider of the function package and the function package descriptor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfProvider(String vnfProvider);

        /**
         * <p>
         * Identifies the function package and the function package descriptor.
         * </p>
         * 
         * @param vnfdId
         *        Identifies the function package and the function package descriptor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfdId(String vnfdId);

        /**
         * <p>
         * Identifies the version of the function package descriptor.
         * </p>
         * 
         * @param vnfdVersion
         *        Identifies the version of the function package descriptor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfdVersion(String vnfdVersion);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private ListSolFunctionPackageMetadata metadata;

        private String onboardingState;

        private String operationalState;

        private String usageState;

        private String vnfProductName;

        private String vnfProvider;

        private String vnfdId;

        private String vnfdVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolFunctionPackageInfo model) {
            arn(model.arn);
            id(model.id);
            metadata(model.metadata);
            onboardingState(model.onboardingState);
            operationalState(model.operationalState);
            usageState(model.usageState);
            vnfProductName(model.vnfProductName);
            vnfProvider(model.vnfProvider);
            vnfdId(model.vnfdId);
            vnfdVersion(model.vnfdVersion);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ListSolFunctionPackageMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(ListSolFunctionPackageMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(ListSolFunctionPackageMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getOnboardingState() {
            return onboardingState;
        }

        public final void setOnboardingState(String onboardingState) {
            this.onboardingState = onboardingState;
        }

        @Override
        public final Builder onboardingState(String onboardingState) {
            this.onboardingState = onboardingState;
            return this;
        }

        @Override
        public final Builder onboardingState(OnboardingState onboardingState) {
            this.onboardingState(onboardingState == null ? null : onboardingState.toString());
            return this;
        }

        public final String getOperationalState() {
            return operationalState;
        }

        public final void setOperationalState(String operationalState) {
            this.operationalState = operationalState;
        }

        @Override
        public final Builder operationalState(String operationalState) {
            this.operationalState = operationalState;
            return this;
        }

        @Override
        public final Builder operationalState(OperationalState operationalState) {
            this.operationalState(operationalState == null ? null : operationalState.toString());
            return this;
        }

        public final String getUsageState() {
            return usageState;
        }

        public final void setUsageState(String usageState) {
            this.usageState = usageState;
        }

        @Override
        public final Builder usageState(String usageState) {
            this.usageState = usageState;
            return this;
        }

        @Override
        public final Builder usageState(UsageState usageState) {
            this.usageState(usageState == null ? null : usageState.toString());
            return this;
        }

        public final String getVnfProductName() {
            return vnfProductName;
        }

        public final void setVnfProductName(String vnfProductName) {
            this.vnfProductName = vnfProductName;
        }

        @Override
        public final Builder vnfProductName(String vnfProductName) {
            this.vnfProductName = vnfProductName;
            return this;
        }

        public final String getVnfProvider() {
            return vnfProvider;
        }

        public final void setVnfProvider(String vnfProvider) {
            this.vnfProvider = vnfProvider;
        }

        @Override
        public final Builder vnfProvider(String vnfProvider) {
            this.vnfProvider = vnfProvider;
            return this;
        }

        public final String getVnfdId() {
            return vnfdId;
        }

        public final void setVnfdId(String vnfdId) {
            this.vnfdId = vnfdId;
        }

        @Override
        public final Builder vnfdId(String vnfdId) {
            this.vnfdId = vnfdId;
            return this;
        }

        public final String getVnfdVersion() {
            return vnfdVersion;
        }

        public final void setVnfdVersion(String vnfdVersion) {
            this.vnfdVersion = vnfdVersion;
        }

        @Override
        public final Builder vnfdVersion(String vnfdVersion) {
            this.vnfdVersion = vnfdVersion;
            return this;
        }

        @Override
        public ListSolFunctionPackageInfo build() {
            return new ListSolFunctionPackageInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
