/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.tnb.TnbClient;
import software.amazon.awssdk.services.tnb.internal.UserAgentUtils;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkPackageInfo;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesResponse;

public class ListSolNetworkPackagesIterable
implements SdkIterable<ListSolNetworkPackagesResponse> {
    private final TnbClient client;
    private final ListSolNetworkPackagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSolNetworkPackagesIterable(TnbClient client, ListSolNetworkPackagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSolNetworkPackagesResponseFetcher();
    }

    public Iterator<ListSolNetworkPackagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListSolNetworkPackageInfo> networkPackages() {
        Function<ListSolNetworkPackagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkPackages() != null) {
                return response.networkPackages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSolNetworkPackagesResponseFetcher
    implements SyncPageFetcher<ListSolNetworkPackagesResponse> {
        private ListSolNetworkPackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListSolNetworkPackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSolNetworkPackagesResponse nextPage(ListSolNetworkPackagesResponse previousPage) {
            if (previousPage == null) {
                return ListSolNetworkPackagesIterable.this.client.listSolNetworkPackages(ListSolNetworkPackagesIterable.this.firstRequest);
            }
            return ListSolNetworkPackagesIterable.this.client.listSolNetworkPackages((ListSolNetworkPackagesRequest)((Object)ListSolNetworkPackagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

