/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSolFunctionInstanceResponse extends TnbResponse implements
        ToCopyableBuilder<GetSolFunctionInstanceResponse.Builder, GetSolFunctionInstanceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetSolFunctionInstanceResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetSolFunctionInstanceResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<GetSolVnfInfo> INSTANTIATED_VNF_INFO_FIELD = SdkField
            .<GetSolVnfInfo> builder(MarshallingType.SDK_POJO).memberName("instantiatedVnfInfo")
            .getter(getter(GetSolFunctionInstanceResponse::instantiatedVnfInfo)).setter(setter(Builder::instantiatedVnfInfo))
            .constructor(GetSolVnfInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instantiatedVnfInfo").build())
            .build();

    private static final SdkField<String> INSTANTIATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instantiationState").getter(getter(GetSolFunctionInstanceResponse::instantiationStateAsString))
            .setter(setter(Builder::instantiationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instantiationState").build())
            .build();

    private static final SdkField<GetSolFunctionInstanceMetadata> METADATA_FIELD = SdkField
            .<GetSolFunctionInstanceMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(GetSolFunctionInstanceResponse::metadata)).setter(setter(Builder::metadata))
            .constructor(GetSolFunctionInstanceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<String> NS_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsInstanceId").getter(getter(GetSolFunctionInstanceResponse::nsInstanceId))
            .setter(setter(Builder::nsInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsInstanceId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetSolFunctionInstanceResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> VNF_PKG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfPkgId").getter(getter(GetSolFunctionInstanceResponse::vnfPkgId)).setter(setter(Builder::vnfPkgId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfPkgId").build()).build();

    private static final SdkField<String> VNF_PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfProductName").getter(getter(GetSolFunctionInstanceResponse::vnfProductName))
            .setter(setter(Builder::vnfProductName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfProductName").build()).build();

    private static final SdkField<String> VNF_PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfProvider").getter(getter(GetSolFunctionInstanceResponse::vnfProvider))
            .setter(setter(Builder::vnfProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfProvider").build()).build();

    private static final SdkField<String> VNFD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vnfdId")
            .getter(getter(GetSolFunctionInstanceResponse::vnfdId)).setter(setter(Builder::vnfdId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfdId").build()).build();

    private static final SdkField<String> VNFD_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfdVersion").getter(getter(GetSolFunctionInstanceResponse::vnfdVersion))
            .setter(setter(Builder::vnfdVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfdVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            INSTANTIATED_VNF_INFO_FIELD, INSTANTIATION_STATE_FIELD, METADATA_FIELD, NS_INSTANCE_ID_FIELD, TAGS_FIELD,
            VNF_PKG_ID_FIELD, VNF_PRODUCT_NAME_FIELD, VNF_PROVIDER_FIELD, VNFD_ID_FIELD, VNFD_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String id;

    private final GetSolVnfInfo instantiatedVnfInfo;

    private final String instantiationState;

    private final GetSolFunctionInstanceMetadata metadata;

    private final String nsInstanceId;

    private final Map<String, String> tags;

    private final String vnfPkgId;

    private final String vnfProductName;

    private final String vnfProvider;

    private final String vnfdId;

    private final String vnfdVersion;

    private GetSolFunctionInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.instantiatedVnfInfo = builder.instantiatedVnfInfo;
        this.instantiationState = builder.instantiationState;
        this.metadata = builder.metadata;
        this.nsInstanceId = builder.nsInstanceId;
        this.tags = builder.tags;
        this.vnfPkgId = builder.vnfPkgId;
        this.vnfProductName = builder.vnfProductName;
        this.vnfProvider = builder.vnfProvider;
        this.vnfdId = builder.vnfdId;
        this.vnfdVersion = builder.vnfdVersion;
    }

    /**
     * <p>
     * Network function instance ARN.
     * </p>
     * 
     * @return Network function instance ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Network function instance ID.
     * </p>
     * 
     * @return Network function instance ID.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the InstantiatedVnfInfo property for this object.
     * 
     * @return The value of the InstantiatedVnfInfo property for this object.
     */
    public final GetSolVnfInfo instantiatedVnfInfo() {
        return instantiatedVnfInfo;
    }

    /**
     * <p>
     * Network function instantiation state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instantiationState} will return {@link VnfInstantiationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #instantiationStateAsString}.
     * </p>
     * 
     * @return Network function instantiation state.
     * @see VnfInstantiationState
     */
    public final VnfInstantiationState instantiationState() {
        return VnfInstantiationState.fromValue(instantiationState);
    }

    /**
     * <p>
     * Network function instantiation state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instantiationState} will return {@link VnfInstantiationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #instantiationStateAsString}.
     * </p>
     * 
     * @return Network function instantiation state.
     * @see VnfInstantiationState
     */
    public final String instantiationStateAsString() {
        return instantiationState;
    }

    /**
     * Returns the value of the Metadata property for this object.
     * 
     * @return The value of the Metadata property for this object.
     */
    public final GetSolFunctionInstanceMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * Network instance ID.
     * </p>
     * 
     * @return Network instance ID.
     */
    public final String nsInstanceId() {
        return nsInstanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
     *         optional value. You can use tags to search and filter your resources or track your Amazon Web Services
     *         costs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Function package ID.
     * </p>
     * 
     * @return Function package ID.
     */
    public final String vnfPkgId() {
        return vnfPkgId;
    }

    /**
     * <p>
     * Network function product name.
     * </p>
     * 
     * @return Network function product name.
     */
    public final String vnfProductName() {
        return vnfProductName;
    }

    /**
     * <p>
     * Network function provider.
     * </p>
     * 
     * @return Network function provider.
     */
    public final String vnfProvider() {
        return vnfProvider;
    }

    /**
     * <p>
     * Function package descriptor ID.
     * </p>
     * 
     * @return Function package descriptor ID.
     */
    public final String vnfdId() {
        return vnfdId;
    }

    /**
     * <p>
     * Function package descriptor version.
     * </p>
     * 
     * @return Function package descriptor version.
     */
    public final String vnfdVersion() {
        return vnfdVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(instantiatedVnfInfo());
        hashCode = 31 * hashCode + Objects.hashCode(instantiationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(nsInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vnfPkgId());
        hashCode = 31 * hashCode + Objects.hashCode(vnfProductName());
        hashCode = 31 * hashCode + Objects.hashCode(vnfProvider());
        hashCode = 31 * hashCode + Objects.hashCode(vnfdId());
        hashCode = 31 * hashCode + Objects.hashCode(vnfdVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolFunctionInstanceResponse)) {
            return false;
        }
        GetSolFunctionInstanceResponse other = (GetSolFunctionInstanceResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(instantiatedVnfInfo(), other.instantiatedVnfInfo())
                && Objects.equals(instantiationStateAsString(), other.instantiationStateAsString())
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(nsInstanceId(), other.nsInstanceId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(vnfPkgId(), other.vnfPkgId()) && Objects.equals(vnfProductName(), other.vnfProductName())
                && Objects.equals(vnfProvider(), other.vnfProvider()) && Objects.equals(vnfdId(), other.vnfdId())
                && Objects.equals(vnfdVersion(), other.vnfdVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSolFunctionInstanceResponse").add("Arn", arn()).add("Id", id())
                .add("InstantiatedVnfInfo", instantiatedVnfInfo()).add("InstantiationState", instantiationStateAsString())
                .add("Metadata", metadata()).add("NsInstanceId", nsInstanceId())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").add("VnfPkgId", vnfPkgId())
                .add("VnfProductName", vnfProductName()).add("VnfProvider", vnfProvider()).add("VnfdId", vnfdId())
                .add("VnfdVersion", vnfdVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "instantiatedVnfInfo":
            return Optional.ofNullable(clazz.cast(instantiatedVnfInfo()));
        case "instantiationState":
            return Optional.ofNullable(clazz.cast(instantiationStateAsString()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "nsInstanceId":
            return Optional.ofNullable(clazz.cast(nsInstanceId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "vnfPkgId":
            return Optional.ofNullable(clazz.cast(vnfPkgId()));
        case "vnfProductName":
            return Optional.ofNullable(clazz.cast(vnfProductName()));
        case "vnfProvider":
            return Optional.ofNullable(clazz.cast(vnfProvider()));
        case "vnfdId":
            return Optional.ofNullable(clazz.cast(vnfdId()));
        case "vnfdVersion":
            return Optional.ofNullable(clazz.cast(vnfdVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("instantiatedVnfInfo", INSTANTIATED_VNF_INFO_FIELD);
        map.put("instantiationState", INSTANTIATION_STATE_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("nsInstanceId", NS_INSTANCE_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("vnfPkgId", VNF_PKG_ID_FIELD);
        map.put("vnfProductName", VNF_PRODUCT_NAME_FIELD);
        map.put("vnfProvider", VNF_PROVIDER_FIELD);
        map.put("vnfdId", VNFD_ID_FIELD);
        map.put("vnfdVersion", VNFD_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSolFunctionInstanceResponse, T> g) {
        return obj -> g.apply((GetSolFunctionInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TnbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSolFunctionInstanceResponse> {
        /**
         * <p>
         * Network function instance ARN.
         * </p>
         * 
         * @param arn
         *        Network function instance ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Network function instance ID.
         * </p>
         * 
         * @param id
         *        Network function instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the InstantiatedVnfInfo property for this object.
         *
         * @param instantiatedVnfInfo
         *        The new value for the InstantiatedVnfInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instantiatedVnfInfo(GetSolVnfInfo instantiatedVnfInfo);

        /**
         * Sets the value of the InstantiatedVnfInfo property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GetSolVnfInfo.Builder} avoiding the need
         * to create one manually via {@link GetSolVnfInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GetSolVnfInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #instantiatedVnfInfo(GetSolVnfInfo)}.
         * 
         * @param instantiatedVnfInfo
         *        a consumer that will call methods on {@link GetSolVnfInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instantiatedVnfInfo(GetSolVnfInfo)
         */
        default Builder instantiatedVnfInfo(Consumer<GetSolVnfInfo.Builder> instantiatedVnfInfo) {
            return instantiatedVnfInfo(GetSolVnfInfo.builder().applyMutation(instantiatedVnfInfo).build());
        }

        /**
         * <p>
         * Network function instantiation state.
         * </p>
         * 
         * @param instantiationState
         *        Network function instantiation state.
         * @see VnfInstantiationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VnfInstantiationState
         */
        Builder instantiationState(String instantiationState);

        /**
         * <p>
         * Network function instantiation state.
         * </p>
         * 
         * @param instantiationState
         *        Network function instantiation state.
         * @see VnfInstantiationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VnfInstantiationState
         */
        Builder instantiationState(VnfInstantiationState instantiationState);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * @param metadata
         *        The new value for the Metadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(GetSolFunctionInstanceMetadata metadata);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GetSolFunctionInstanceMetadata.Builder}
         * avoiding the need to create one manually via {@link GetSolFunctionInstanceMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GetSolFunctionInstanceMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(GetSolFunctionInstanceMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link GetSolFunctionInstanceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(GetSolFunctionInstanceMetadata)
         */
        default Builder metadata(Consumer<GetSolFunctionInstanceMetadata.Builder> metadata) {
            return metadata(GetSolFunctionInstanceMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * Network instance ID.
         * </p>
         * 
         * @param nsInstanceId
         *        Network instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsInstanceId(String nsInstanceId);

        /**
         * <p>
         * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         * optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
         * </p>
         * 
         * @param tags
         *        A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         *        optional value. You can use tags to search and filter your resources or track your Amazon Web Services
         *        costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Function package ID.
         * </p>
         * 
         * @param vnfPkgId
         *        Function package ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfPkgId(String vnfPkgId);

        /**
         * <p>
         * Network function product name.
         * </p>
         * 
         * @param vnfProductName
         *        Network function product name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfProductName(String vnfProductName);

        /**
         * <p>
         * Network function provider.
         * </p>
         * 
         * @param vnfProvider
         *        Network function provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfProvider(String vnfProvider);

        /**
         * <p>
         * Function package descriptor ID.
         * </p>
         * 
         * @param vnfdId
         *        Function package descriptor ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfdId(String vnfdId);

        /**
         * <p>
         * Function package descriptor version.
         * </p>
         * 
         * @param vnfdVersion
         *        Function package descriptor version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfdVersion(String vnfdVersion);
    }

    static final class BuilderImpl extends TnbResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private GetSolVnfInfo instantiatedVnfInfo;

        private String instantiationState;

        private GetSolFunctionInstanceMetadata metadata;

        private String nsInstanceId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String vnfPkgId;

        private String vnfProductName;

        private String vnfProvider;

        private String vnfdId;

        private String vnfdVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolFunctionInstanceResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            instantiatedVnfInfo(model.instantiatedVnfInfo);
            instantiationState(model.instantiationState);
            metadata(model.metadata);
            nsInstanceId(model.nsInstanceId);
            tags(model.tags);
            vnfPkgId(model.vnfPkgId);
            vnfProductName(model.vnfProductName);
            vnfProvider(model.vnfProvider);
            vnfdId(model.vnfdId);
            vnfdVersion(model.vnfdVersion);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final GetSolVnfInfo.Builder getInstantiatedVnfInfo() {
            return instantiatedVnfInfo != null ? instantiatedVnfInfo.toBuilder() : null;
        }

        public final void setInstantiatedVnfInfo(GetSolVnfInfo.BuilderImpl instantiatedVnfInfo) {
            this.instantiatedVnfInfo = instantiatedVnfInfo != null ? instantiatedVnfInfo.build() : null;
        }

        @Override
        public final Builder instantiatedVnfInfo(GetSolVnfInfo instantiatedVnfInfo) {
            this.instantiatedVnfInfo = instantiatedVnfInfo;
            return this;
        }

        public final String getInstantiationState() {
            return instantiationState;
        }

        public final void setInstantiationState(String instantiationState) {
            this.instantiationState = instantiationState;
        }

        @Override
        public final Builder instantiationState(String instantiationState) {
            this.instantiationState = instantiationState;
            return this;
        }

        @Override
        public final Builder instantiationState(VnfInstantiationState instantiationState) {
            this.instantiationState(instantiationState == null ? null : instantiationState.toString());
            return this;
        }

        public final GetSolFunctionInstanceMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(GetSolFunctionInstanceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(GetSolFunctionInstanceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getNsInstanceId() {
            return nsInstanceId;
        }

        public final void setNsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
        }

        @Override
        public final Builder nsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getVnfPkgId() {
            return vnfPkgId;
        }

        public final void setVnfPkgId(String vnfPkgId) {
            this.vnfPkgId = vnfPkgId;
        }

        @Override
        public final Builder vnfPkgId(String vnfPkgId) {
            this.vnfPkgId = vnfPkgId;
            return this;
        }

        public final String getVnfProductName() {
            return vnfProductName;
        }

        public final void setVnfProductName(String vnfProductName) {
            this.vnfProductName = vnfProductName;
        }

        @Override
        public final Builder vnfProductName(String vnfProductName) {
            this.vnfProductName = vnfProductName;
            return this;
        }

        public final String getVnfProvider() {
            return vnfProvider;
        }

        public final void setVnfProvider(String vnfProvider) {
            this.vnfProvider = vnfProvider;
        }

        @Override
        public final Builder vnfProvider(String vnfProvider) {
            this.vnfProvider = vnfProvider;
            return this;
        }

        public final String getVnfdId() {
            return vnfdId;
        }

        public final void setVnfdId(String vnfdId) {
            this.vnfdId = vnfdId;
        }

        @Override
        public final Builder vnfdId(String vnfdId) {
            this.vnfdId = vnfdId;
            return this;
        }

        public final String getVnfdVersion() {
            return vnfdVersion;
        }

        public final void setVnfdVersion(String vnfdVersion) {
            this.vnfdVersion = vnfdVersion;
        }

        @Override
        public final Builder vnfdVersion(String vnfdVersion) {
            this.vnfdVersion = vnfdVersion;
            return this;
        }

        @Override
        public GetSolFunctionInstanceResponse build() {
            return new GetSolFunctionInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
