/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSolNetworkInstanceRequest extends TnbRequest implements
        ToCopyableBuilder<UpdateSolNetworkInstanceRequest.Builder, UpdateSolNetworkInstanceRequest> {
    private static final SdkField<UpdateSolNetworkModify> MODIFY_VNF_INFO_DATA_FIELD = SdkField
            .<UpdateSolNetworkModify> builder(MarshallingType.SDK_POJO).memberName("modifyVnfInfoData")
            .getter(getter(UpdateSolNetworkInstanceRequest::modifyVnfInfoData)).setter(setter(Builder::modifyVnfInfoData))
            .constructor(UpdateSolNetworkModify::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifyVnfInfoData").build()).build();

    private static final SdkField<String> NS_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsInstanceId").getter(getter(UpdateSolNetworkInstanceRequest::nsInstanceId))
            .setter(setter(Builder::nsInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("nsInstanceId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(UpdateSolNetworkInstanceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<UpdateSolNetworkServiceData> UPDATE_NS_FIELD = SdkField
            .<UpdateSolNetworkServiceData> builder(MarshallingType.SDK_POJO).memberName("updateNs")
            .getter(getter(UpdateSolNetworkInstanceRequest::updateNs)).setter(setter(Builder::updateNs))
            .constructor(UpdateSolNetworkServiceData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateNs").build()).build();

    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updateType").getter(getter(UpdateSolNetworkInstanceRequest::updateTypeAsString))
            .setter(setter(Builder::updateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODIFY_VNF_INFO_DATA_FIELD,
            NS_INSTANCE_ID_FIELD, TAGS_FIELD, UPDATE_NS_FIELD, UPDATE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final UpdateSolNetworkModify modifyVnfInfoData;

    private final String nsInstanceId;

    private final Map<String, String> tags;

    private final UpdateSolNetworkServiceData updateNs;

    private final String updateType;

    private UpdateSolNetworkInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.modifyVnfInfoData = builder.modifyVnfInfoData;
        this.nsInstanceId = builder.nsInstanceId;
        this.tags = builder.tags;
        this.updateNs = builder.updateNs;
        this.updateType = builder.updateType;
    }

    /**
     * <p>
     * Identifies the network function information parameters and/or the configurable properties of the network function
     * to be modified.
     * </p>
     * <p>
     * Include this property only if the update type is <code>MODIFY_VNF_INFORMATION</code>.
     * </p>
     * 
     * @return Identifies the network function information parameters and/or the configurable properties of the network
     *         function to be modified.</p>
     *         <p>
     *         Include this property only if the update type is <code>MODIFY_VNF_INFORMATION</code>.
     */
    public final UpdateSolNetworkModify modifyVnfInfoData() {
        return modifyVnfInfoData;
    }

    /**
     * <p>
     * ID of the network instance.
     * </p>
     * 
     * @return ID of the network instance.
     */
    public final String nsInstanceId() {
        return nsInstanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. When you use this API, the tags are only applied to the network operation that is created. These tags are
     * not applied to the network instance. Use tags to search and filter your resources or track your Amazon Web
     * Services costs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
     *         optional value. When you use this API, the tags are only applied to the network operation that is
     *         created. These tags are not applied to the network instance. Use tags to search and filter your resources
     *         or track your Amazon Web Services costs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Identifies the network service descriptor and the configurable properties of the descriptor, to be used for the
     * update.
     * </p>
     * <p>
     * Include this property only if the update type is <code>UPDATE_NS</code>.
     * </p>
     * 
     * @return Identifies the network service descriptor and the configurable properties of the descriptor, to be used
     *         for the update.</p>
     *         <p>
     *         Include this property only if the update type is <code>UPDATE_NS</code>.
     */
    public final UpdateSolNetworkServiceData updateNs() {
        return updateNs;
    }

    /**
     * <p>
     * The type of update.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>MODIFY_VNF_INFORMATION</code> update type, to update a specific network function configuration, in
     * the network instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>UPDATE_NS</code> update type, to update the network instance to a new network service descriptor.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link UpdateSolNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The type of update.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use the <code>MODIFY_VNF_INFORMATION</code> update type, to update a specific network function
     *         configuration, in the network instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the <code>UPDATE_NS</code> update type, to update the network instance to a new network service
     *         descriptor.
     *         </p>
     *         </li>
     * @see UpdateSolNetworkType
     */
    public final UpdateSolNetworkType updateType() {
        return UpdateSolNetworkType.fromValue(updateType);
    }

    /**
     * <p>
     * The type of update.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>MODIFY_VNF_INFORMATION</code> update type, to update a specific network function configuration, in
     * the network instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>UPDATE_NS</code> update type, to update the network instance to a new network service descriptor.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link UpdateSolNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The type of update.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use the <code>MODIFY_VNF_INFORMATION</code> update type, to update a specific network function
     *         configuration, in the network instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the <code>UPDATE_NS</code> update type, to update the network instance to a new network service
     *         descriptor.
     *         </p>
     *         </li>
     * @see UpdateSolNetworkType
     */
    public final String updateTypeAsString() {
        return updateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modifyVnfInfoData());
        hashCode = 31 * hashCode + Objects.hashCode(nsInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updateNs());
        hashCode = 31 * hashCode + Objects.hashCode(updateTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSolNetworkInstanceRequest)) {
            return false;
        }
        UpdateSolNetworkInstanceRequest other = (UpdateSolNetworkInstanceRequest) obj;
        return Objects.equals(modifyVnfInfoData(), other.modifyVnfInfoData())
                && Objects.equals(nsInstanceId(), other.nsInstanceId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(updateNs(), other.updateNs())
                && Objects.equals(updateTypeAsString(), other.updateTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSolNetworkInstanceRequest").add("ModifyVnfInfoData", modifyVnfInfoData())
                .add("NsInstanceId", nsInstanceId()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UpdateNs", updateNs()).add("UpdateType", updateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modifyVnfInfoData":
            return Optional.ofNullable(clazz.cast(modifyVnfInfoData()));
        case "nsInstanceId":
            return Optional.ofNullable(clazz.cast(nsInstanceId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "updateNs":
            return Optional.ofNullable(clazz.cast(updateNs()));
        case "updateType":
            return Optional.ofNullable(clazz.cast(updateTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("modifyVnfInfoData", MODIFY_VNF_INFO_DATA_FIELD);
        map.put("nsInstanceId", NS_INSTANCE_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("updateNs", UPDATE_NS_FIELD);
        map.put("updateType", UPDATE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSolNetworkInstanceRequest, T> g) {
        return obj -> g.apply((UpdateSolNetworkInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TnbRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSolNetworkInstanceRequest> {
        /**
         * <p>
         * Identifies the network function information parameters and/or the configurable properties of the network
         * function to be modified.
         * </p>
         * <p>
         * Include this property only if the update type is <code>MODIFY_VNF_INFORMATION</code>.
         * </p>
         * 
         * @param modifyVnfInfoData
         *        Identifies the network function information parameters and/or the configurable properties of the
         *        network function to be modified.</p>
         *        <p>
         *        Include this property only if the update type is <code>MODIFY_VNF_INFORMATION</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifyVnfInfoData(UpdateSolNetworkModify modifyVnfInfoData);

        /**
         * <p>
         * Identifies the network function information parameters and/or the configurable properties of the network
         * function to be modified.
         * </p>
         * <p>
         * Include this property only if the update type is <code>MODIFY_VNF_INFORMATION</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateSolNetworkModify.Builder} avoiding
         * the need to create one manually via {@link UpdateSolNetworkModify#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateSolNetworkModify.Builder#build()} is called immediately and
         * its result is passed to {@link #modifyVnfInfoData(UpdateSolNetworkModify)}.
         * 
         * @param modifyVnfInfoData
         *        a consumer that will call methods on {@link UpdateSolNetworkModify.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modifyVnfInfoData(UpdateSolNetworkModify)
         */
        default Builder modifyVnfInfoData(Consumer<UpdateSolNetworkModify.Builder> modifyVnfInfoData) {
            return modifyVnfInfoData(UpdateSolNetworkModify.builder().applyMutation(modifyVnfInfoData).build());
        }

        /**
         * <p>
         * ID of the network instance.
         * </p>
         * 
         * @param nsInstanceId
         *        ID of the network instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsInstanceId(String nsInstanceId);

        /**
         * <p>
         * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         * optional value. When you use this API, the tags are only applied to the network operation that is created.
         * These tags are not applied to the network instance. Use tags to search and filter your resources or track
         * your Amazon Web Services costs.
         * </p>
         * 
         * @param tags
         *        A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         *        optional value. When you use this API, the tags are only applied to the network operation that is
         *        created. These tags are not applied to the network instance. Use tags to search and filter your
         *        resources or track your Amazon Web Services costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Identifies the network service descriptor and the configurable properties of the descriptor, to be used for
         * the update.
         * </p>
         * <p>
         * Include this property only if the update type is <code>UPDATE_NS</code>.
         * </p>
         * 
         * @param updateNs
         *        Identifies the network service descriptor and the configurable properties of the descriptor, to be
         *        used for the update.</p>
         *        <p>
         *        Include this property only if the update type is <code>UPDATE_NS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateNs(UpdateSolNetworkServiceData updateNs);

        /**
         * <p>
         * Identifies the network service descriptor and the configurable properties of the descriptor, to be used for
         * the update.
         * </p>
         * <p>
         * Include this property only if the update type is <code>UPDATE_NS</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateSolNetworkServiceData.Builder}
         * avoiding the need to create one manually via {@link UpdateSolNetworkServiceData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateSolNetworkServiceData.Builder#build()} is called
         * immediately and its result is passed to {@link #updateNs(UpdateSolNetworkServiceData)}.
         * 
         * @param updateNs
         *        a consumer that will call methods on {@link UpdateSolNetworkServiceData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateNs(UpdateSolNetworkServiceData)
         */
        default Builder updateNs(Consumer<UpdateSolNetworkServiceData.Builder> updateNs) {
            return updateNs(UpdateSolNetworkServiceData.builder().applyMutation(updateNs).build());
        }

        /**
         * <p>
         * The type of update.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use the <code>MODIFY_VNF_INFORMATION</code> update type, to update a specific network function configuration,
         * in the network instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the <code>UPDATE_NS</code> update type, to update the network instance to a new network service
         * descriptor.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateType
         *        The type of update.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use the <code>MODIFY_VNF_INFORMATION</code> update type, to update a specific network function
         *        configuration, in the network instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the <code>UPDATE_NS</code> update type, to update the network instance to a new network service
         *        descriptor.
         *        </p>
         *        </li>
         * @see UpdateSolNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateSolNetworkType
         */
        Builder updateType(String updateType);

        /**
         * <p>
         * The type of update.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use the <code>MODIFY_VNF_INFORMATION</code> update type, to update a specific network function configuration,
         * in the network instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the <code>UPDATE_NS</code> update type, to update the network instance to a new network service
         * descriptor.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateType
         *        The type of update.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use the <code>MODIFY_VNF_INFORMATION</code> update type, to update a specific network function
         *        configuration, in the network instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the <code>UPDATE_NS</code> update type, to update the network instance to a new network service
         *        descriptor.
         *        </p>
         *        </li>
         * @see UpdateSolNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateSolNetworkType
         */
        Builder updateType(UpdateSolNetworkType updateType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TnbRequest.BuilderImpl implements Builder {
        private UpdateSolNetworkModify modifyVnfInfoData;

        private String nsInstanceId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private UpdateSolNetworkServiceData updateNs;

        private String updateType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSolNetworkInstanceRequest model) {
            super(model);
            modifyVnfInfoData(model.modifyVnfInfoData);
            nsInstanceId(model.nsInstanceId);
            tags(model.tags);
            updateNs(model.updateNs);
            updateType(model.updateType);
        }

        public final UpdateSolNetworkModify.Builder getModifyVnfInfoData() {
            return modifyVnfInfoData != null ? modifyVnfInfoData.toBuilder() : null;
        }

        public final void setModifyVnfInfoData(UpdateSolNetworkModify.BuilderImpl modifyVnfInfoData) {
            this.modifyVnfInfoData = modifyVnfInfoData != null ? modifyVnfInfoData.build() : null;
        }

        @Override
        public final Builder modifyVnfInfoData(UpdateSolNetworkModify modifyVnfInfoData) {
            this.modifyVnfInfoData = modifyVnfInfoData;
            return this;
        }

        public final String getNsInstanceId() {
            return nsInstanceId;
        }

        public final void setNsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
        }

        @Override
        public final Builder nsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final UpdateSolNetworkServiceData.Builder getUpdateNs() {
            return updateNs != null ? updateNs.toBuilder() : null;
        }

        public final void setUpdateNs(UpdateSolNetworkServiceData.BuilderImpl updateNs) {
            this.updateNs = updateNs != null ? updateNs.build() : null;
        }

        @Override
        public final Builder updateNs(UpdateSolNetworkServiceData updateNs) {
            this.updateNs = updateNs;
            return this;
        }

        public final String getUpdateType() {
            return updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(UpdateSolNetworkType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSolNetworkInstanceRequest build() {
            return new UpdateSolNetworkInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
