/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTranscriptionJobsResponse extends TranscribeResponse implements
        ToCopyableBuilder<ListTranscriptionJobsResponse.Builder, ListTranscriptionJobsResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTranscriptionJobsResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTranscriptionJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<TranscriptionJobSummary>> TRANSCRIPTION_JOB_SUMMARIES_FIELD = SdkField
            .<List<TranscriptionJobSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListTranscriptionJobsResponse::transcriptionJobSummaries))
            .setter(setter(Builder::transcriptionJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TranscriptionJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TranscriptionJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            NEXT_TOKEN_FIELD, TRANSCRIPTION_JOB_SUMMARIES_FIELD));

    private final String status;

    private final String nextToken;

    private final List<TranscriptionJobSummary> transcriptionJobSummaries;

    private ListTranscriptionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.transcriptionJobSummaries = builder.transcriptionJobSummaries;
    }

    /**
     * <p>
     * The requested status of the jobs returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TranscriptionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The requested status of the jobs returned.
     * @see TranscriptionJobStatus
     */
    public TranscriptionJobStatus status() {
        return TranscriptionJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The requested status of the jobs returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TranscriptionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The requested status of the jobs returned.
     * @see TranscriptionJobStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The <code>ListTranscriptionJobs</code> operation returns a page of jobs at a time. The maximum size of the page
     * is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the page size, Amazon
     * Transcribe returns the <code>NextPage</code> token. Include the token in the next request to the
     * <code>ListTranscriptionJobs</code> operation to return in the next page of jobs.
     * </p>
     * 
     * @return The <code>ListTranscriptionJobs</code> operation returns a page of jobs at a time. The maximum size of
     *         the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the
     *         page size, Amazon Transcribe returns the <code>NextPage</code> token. Include the token in the next
     *         request to the <code>ListTranscriptionJobs</code> operation to return in the next page of jobs.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A list of objects containing summary information for a transcription job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of objects containing summary information for a transcription job.
     */
    public List<TranscriptionJobSummary> transcriptionJobSummaries() {
        return transcriptionJobSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(transcriptionJobSummaries());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTranscriptionJobsResponse)) {
            return false;
        }
        ListTranscriptionJobsResponse other = (ListTranscriptionJobsResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(transcriptionJobSummaries(), other.transcriptionJobSummaries());
    }

    @Override
    public String toString() {
        return ToString.builder("ListTranscriptionJobsResponse").add("Status", statusAsString()).add("NextToken", nextToken())
                .add("TranscriptionJobSummaries", transcriptionJobSummaries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TranscriptionJobSummaries":
            return Optional.ofNullable(clazz.cast(transcriptionJobSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTranscriptionJobsResponse, T> g) {
        return obj -> g.apply((ListTranscriptionJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTranscriptionJobsResponse> {
        /**
         * <p>
         * The requested status of the jobs returned.
         * </p>
         * 
         * @param status
         *        The requested status of the jobs returned.
         * @see TranscriptionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptionJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The requested status of the jobs returned.
         * </p>
         * 
         * @param status
         *        The requested status of the jobs returned.
         * @see TranscriptionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptionJobStatus
         */
        Builder status(TranscriptionJobStatus status);

        /**
         * <p>
         * The <code>ListTranscriptionJobs</code> operation returns a page of jobs at a time. The maximum size of the
         * page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the page size,
         * Amazon Transcribe returns the <code>NextPage</code> token. Include the token in the next request to the
         * <code>ListTranscriptionJobs</code> operation to return in the next page of jobs.
         * </p>
         * 
         * @param nextToken
         *        The <code>ListTranscriptionJobs</code> operation returns a page of jobs at a time. The maximum size of
         *        the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the
         *        page size, Amazon Transcribe returns the <code>NextPage</code> token. Include the token in the next
         *        request to the <code>ListTranscriptionJobs</code> operation to return in the next page of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of objects containing summary information for a transcription job.
         * </p>
         * 
         * @param transcriptionJobSummaries
         *        A list of objects containing summary information for a transcription job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptionJobSummaries(Collection<TranscriptionJobSummary> transcriptionJobSummaries);

        /**
         * <p>
         * A list of objects containing summary information for a transcription job.
         * </p>
         * 
         * @param transcriptionJobSummaries
         *        A list of objects containing summary information for a transcription job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptionJobSummaries(TranscriptionJobSummary... transcriptionJobSummaries);

        /**
         * <p>
         * A list of objects containing summary information for a transcription job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TranscriptionJobSummary>.Builder} avoiding
         * the need to create one manually via {@link List<TranscriptionJobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TranscriptionJobSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #transcriptionJobSummaries(List<TranscriptionJobSummary>)}.
         * 
         * @param transcriptionJobSummaries
         *        a consumer that will call methods on {@link List<TranscriptionJobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcriptionJobSummaries(List<TranscriptionJobSummary>)
         */
        Builder transcriptionJobSummaries(Consumer<TranscriptionJobSummary.Builder>... transcriptionJobSummaries);
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private String status;

        private String nextToken;

        private List<TranscriptionJobSummary> transcriptionJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTranscriptionJobsResponse model) {
            super(model);
            status(model.status);
            nextToken(model.nextToken);
            transcriptionJobSummaries(model.transcriptionJobSummaries);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TranscriptionJobStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<TranscriptionJobSummary.Builder> getTranscriptionJobSummaries() {
            return transcriptionJobSummaries != null ? transcriptionJobSummaries.stream().map(TranscriptionJobSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder transcriptionJobSummaries(Collection<TranscriptionJobSummary> transcriptionJobSummaries) {
            this.transcriptionJobSummaries = TranscriptionJobSummariesCopier.copy(transcriptionJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transcriptionJobSummaries(TranscriptionJobSummary... transcriptionJobSummaries) {
            transcriptionJobSummaries(Arrays.asList(transcriptionJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transcriptionJobSummaries(Consumer<TranscriptionJobSummary.Builder>... transcriptionJobSummaries) {
            transcriptionJobSummaries(Stream.of(transcriptionJobSummaries)
                    .map(c -> TranscriptionJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTranscriptionJobSummaries(Collection<TranscriptionJobSummary.BuilderImpl> transcriptionJobSummaries) {
            this.transcriptionJobSummaries = TranscriptionJobSummariesCopier.copyFromBuilder(transcriptionJobSummaries);
        }

        @Override
        public ListTranscriptionJobsResponse build() {
            return new ListTranscriptionJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
