/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTranscriptionJobRequest extends TranscribeRequest implements
        ToCopyableBuilder<StartTranscriptionJobRequest.Builder, StartTranscriptionJobRequest> {
    private static final SdkField<String> TRANSCRIPTION_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartTranscriptionJobRequest::transcriptionJobName)).setter(setter(Builder::transcriptionJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobName").build())
            .build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartTranscriptionJobRequest::languageCodeAsString)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StartTranscriptionJobRequest::mediaSampleRateHertz)).setter(setter(Builder::mediaSampleRateHertz))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaSampleRateHertz").build())
            .build();

    private static final SdkField<String> MEDIA_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartTranscriptionJobRequest::mediaFormatAsString)).setter(setter(Builder::mediaFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaFormat").build()).build();

    private static final SdkField<Media> MEDIA_FIELD = SdkField.<Media> builder(MarshallingType.SDK_POJO)
            .getter(getter(StartTranscriptionJobRequest::media)).setter(setter(Builder::media)).constructor(Media::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Media").build()).build();

    private static final SdkField<String> OUTPUT_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartTranscriptionJobRequest::outputBucketName)).setter(setter(Builder::outputBucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBucketName").build()).build();

    private static final SdkField<Settings> SETTINGS_FIELD = SdkField.<Settings> builder(MarshallingType.SDK_POJO)
            .getter(getter(StartTranscriptionJobRequest::settings)).setter(setter(Builder::settings))
            .constructor(Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPTION_JOB_NAME_FIELD,
            LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_FORMAT_FIELD, MEDIA_FIELD, OUTPUT_BUCKET_NAME_FIELD,
            SETTINGS_FIELD));

    private final String transcriptionJobName;

    private final String languageCode;

    private final Integer mediaSampleRateHertz;

    private final String mediaFormat;

    private final Media media;

    private final String outputBucketName;

    private final Settings settings;

    private StartTranscriptionJobRequest(BuilderImpl builder) {
        super(builder);
        this.transcriptionJobName = builder.transcriptionJobName;
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaFormat = builder.mediaFormat;
        this.media = builder.media;
        this.outputBucketName = builder.outputBucketName;
        this.settings = builder.settings;
    }

    /**
     * <p>
     * The name of the job. Note that you can't use the strings "." or ".." by themselves as the job name. The name must
     * also be unique within an AWS account.
     * </p>
     * 
     * @return The name of the job. Note that you can't use the strings "." or ".." by themselves as the job name. The
     *         name must also be unique within an AWS account.
     */
    public String transcriptionJobName() {
        return transcriptionJobName;
    }

    /**
     * <p>
     * The language code for the language used in the input media file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code for the language used in the input media file.
     * @see LanguageCode
     */
    public LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code for the language used in the input media file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code for the language used in the input media file.
     * @see LanguageCode
     */
    public String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The sample rate, in Hertz, of the audio track in the input media file.
     * </p>
     * 
     * @return The sample rate, in Hertz, of the audio track in the input media file.
     */
    public Integer mediaSampleRateHertz() {
        return mediaSampleRateHertz;
    }

    /**
     * <p>
     * The format of the input media file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaFormat} will
     * return {@link MediaFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaFormatAsString}.
     * </p>
     * 
     * @return The format of the input media file.
     * @see MediaFormat
     */
    public MediaFormat mediaFormat() {
        return MediaFormat.fromValue(mediaFormat);
    }

    /**
     * <p>
     * The format of the input media file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaFormat} will
     * return {@link MediaFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaFormatAsString}.
     * </p>
     * 
     * @return The format of the input media file.
     * @see MediaFormat
     */
    public String mediaFormatAsString() {
        return mediaFormat;
    }

    /**
     * <p>
     * An object that describes the input media for a transcription job.
     * </p>
     * 
     * @return An object that describes the input media for a transcription job.
     */
    public Media media() {
        return media;
    }

    /**
     * <p>
     * The location where the transcription is stored.
     * </p>
     * <p>
     * If you set the <code>OutputBucketName</code>, Amazon Transcribe puts the transcription in the specified S3
     * bucket. When you call the <a>GetTranscriptionJob</a> operation, the operation returns this location in the
     * <code>TranscriptFileUri</code> field. The S3 bucket must have permissions that allow Amazon Transcribe to put
     * files in the bucket. For more information, see <a href=
     * "https://docs.aws.amazon.com/transcribe/latest/dg/access-control-managing-permissions.html#auth-role-iam-user"
     * >Permissions Required for IAM User Roles</a>.
     * </p>
     * <p>
     * If you don't set the <code>OutputBucketName</code>, Amazon Transcribe generates a pre-signed URL, a shareable URL
     * that provides secure access to your transcription, and returns it in the <code>TranscriptFileUri</code> field.
     * Use this URL to download the transcription.
     * </p>
     * 
     * @return The location where the transcription is stored.</p>
     *         <p>
     *         If you set the <code>OutputBucketName</code>, Amazon Transcribe puts the transcription in the specified
     *         S3 bucket. When you call the <a>GetTranscriptionJob</a> operation, the operation returns this location in
     *         the <code>TranscriptFileUri</code> field. The S3 bucket must have permissions that allow Amazon
     *         Transcribe to put files in the bucket. For more information, see <a href=
     *         "https://docs.aws.amazon.com/transcribe/latest/dg/access-control-managing-permissions.html#auth-role-iam-user"
     *         >Permissions Required for IAM User Roles</a>.
     *         </p>
     *         <p>
     *         If you don't set the <code>OutputBucketName</code>, Amazon Transcribe generates a pre-signed URL, a
     *         shareable URL that provides secure access to your transcription, and returns it in the
     *         <code>TranscriptFileUri</code> field. Use this URL to download the transcription.
     */
    public String outputBucketName() {
        return outputBucketName;
    }

    /**
     * <p>
     * A <code>Settings</code> object that provides optional settings for a transcription job.
     * </p>
     * 
     * @return A <code>Settings</code> object that provides optional settings for a transcription job.
     */
    public Settings settings() {
        return settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcriptionJobName());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(mediaFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(media());
        hashCode = 31 * hashCode + Objects.hashCode(outputBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTranscriptionJobRequest)) {
            return false;
        }
        StartTranscriptionJobRequest other = (StartTranscriptionJobRequest) obj;
        return Objects.equals(transcriptionJobName(), other.transcriptionJobName())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(mediaSampleRateHertz(), other.mediaSampleRateHertz())
                && Objects.equals(mediaFormatAsString(), other.mediaFormatAsString()) && Objects.equals(media(), other.media())
                && Objects.equals(outputBucketName(), other.outputBucketName()) && Objects.equals(settings(), other.settings());
    }

    @Override
    public String toString() {
        return ToString.builder("StartTranscriptionJobRequest").add("TranscriptionJobName", transcriptionJobName())
                .add("LanguageCode", languageCodeAsString()).add("MediaSampleRateHertz", mediaSampleRateHertz())
                .add("MediaFormat", mediaFormatAsString()).add("Media", media()).add("OutputBucketName", outputBucketName())
                .add("Settings", settings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TranscriptionJobName":
            return Optional.ofNullable(clazz.cast(transcriptionJobName()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "MediaSampleRateHertz":
            return Optional.ofNullable(clazz.cast(mediaSampleRateHertz()));
        case "MediaFormat":
            return Optional.ofNullable(clazz.cast(mediaFormatAsString()));
        case "Media":
            return Optional.ofNullable(clazz.cast(media()));
        case "OutputBucketName":
            return Optional.ofNullable(clazz.cast(outputBucketName()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTranscriptionJobRequest, T> g) {
        return obj -> g.apply((StartTranscriptionJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartTranscriptionJobRequest> {
        /**
         * <p>
         * The name of the job. Note that you can't use the strings "." or ".." by themselves as the job name. The name
         * must also be unique within an AWS account.
         * </p>
         * 
         * @param transcriptionJobName
         *        The name of the job. Note that you can't use the strings "." or ".." by themselves as the job name.
         *        The name must also be unique within an AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptionJobName(String transcriptionJobName);

        /**
         * <p>
         * The language code for the language used in the input media file.
         * </p>
         * 
         * @param languageCode
         *        The language code for the language used in the input media file.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code for the language used in the input media file.
         * </p>
         * 
         * @param languageCode
         *        The language code for the language used in the input media file.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The sample rate, in Hertz, of the audio track in the input media file.
         * </p>
         * 
         * @param mediaSampleRateHertz
         *        The sample rate, in Hertz, of the audio track in the input media file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaSampleRateHertz(Integer mediaSampleRateHertz);

        /**
         * <p>
         * The format of the input media file.
         * </p>
         * 
         * @param mediaFormat
         *        The format of the input media file.
         * @see MediaFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaFormat
         */
        Builder mediaFormat(String mediaFormat);

        /**
         * <p>
         * The format of the input media file.
         * </p>
         * 
         * @param mediaFormat
         *        The format of the input media file.
         * @see MediaFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaFormat
         */
        Builder mediaFormat(MediaFormat mediaFormat);

        /**
         * <p>
         * An object that describes the input media for a transcription job.
         * </p>
         * 
         * @param media
         *        An object that describes the input media for a transcription job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder media(Media media);

        /**
         * <p>
         * An object that describes the input media for a transcription job.
         * </p>
         * This is a convenience that creates an instance of the {@link Media.Builder} avoiding the need to create one
         * manually via {@link Media#builder()}.
         *
         * When the {@link Consumer} completes, {@link Media.Builder#build()} is called immediately and its result is
         * passed to {@link #media(Media)}.
         * 
         * @param media
         *        a consumer that will call methods on {@link Media.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #media(Media)
         */
        default Builder media(Consumer<Media.Builder> media) {
            return media(Media.builder().applyMutation(media).build());
        }

        /**
         * <p>
         * The location where the transcription is stored.
         * </p>
         * <p>
         * If you set the <code>OutputBucketName</code>, Amazon Transcribe puts the transcription in the specified S3
         * bucket. When you call the <a>GetTranscriptionJob</a> operation, the operation returns this location in the
         * <code>TranscriptFileUri</code> field. The S3 bucket must have permissions that allow Amazon Transcribe to put
         * files in the bucket. For more information, see <a href=
         * "https://docs.aws.amazon.com/transcribe/latest/dg/access-control-managing-permissions.html#auth-role-iam-user"
         * >Permissions Required for IAM User Roles</a>.
         * </p>
         * <p>
         * If you don't set the <code>OutputBucketName</code>, Amazon Transcribe generates a pre-signed URL, a shareable
         * URL that provides secure access to your transcription, and returns it in the <code>TranscriptFileUri</code>
         * field. Use this URL to download the transcription.
         * </p>
         * 
         * @param outputBucketName
         *        The location where the transcription is stored.</p>
         *        <p>
         *        If you set the <code>OutputBucketName</code>, Amazon Transcribe puts the transcription in the
         *        specified S3 bucket. When you call the <a>GetTranscriptionJob</a> operation, the operation returns
         *        this location in the <code>TranscriptFileUri</code> field. The S3 bucket must have permissions that
         *        allow Amazon Transcribe to put files in the bucket. For more information, see <a href=
         *        "https://docs.aws.amazon.com/transcribe/latest/dg/access-control-managing-permissions.html#auth-role-iam-user"
         *        >Permissions Required for IAM User Roles</a>.
         *        </p>
         *        <p>
         *        If you don't set the <code>OutputBucketName</code>, Amazon Transcribe generates a pre-signed URL, a
         *        shareable URL that provides secure access to your transcription, and returns it in the
         *        <code>TranscriptFileUri</code> field. Use this URL to download the transcription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputBucketName(String outputBucketName);

        /**
         * <p>
         * A <code>Settings</code> object that provides optional settings for a transcription job.
         * </p>
         * 
         * @param settings
         *        A <code>Settings</code> object that provides optional settings for a transcription job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(Settings settings);

        /**
         * <p>
         * A <code>Settings</code> object that provides optional settings for a transcription job.
         * </p>
         * This is a convenience that creates an instance of the {@link Settings.Builder} avoiding the need to create
         * one manually via {@link Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Settings.Builder#build()} is called immediately and its result is
         * passed to {@link #settings(Settings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(Settings)
         */
        default Builder settings(Consumer<Settings.Builder> settings) {
            return settings(Settings.builder().applyMutation(settings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String transcriptionJobName;

        private String languageCode;

        private Integer mediaSampleRateHertz;

        private String mediaFormat;

        private Media media;

        private String outputBucketName;

        private Settings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTranscriptionJobRequest model) {
            super(model);
            transcriptionJobName(model.transcriptionJobName);
            languageCode(model.languageCode);
            mediaSampleRateHertz(model.mediaSampleRateHertz);
            mediaFormat(model.mediaFormat);
            media(model.media);
            outputBucketName(model.outputBucketName);
            settings(model.settings);
        }

        public final String getTranscriptionJobName() {
            return transcriptionJobName;
        }

        @Override
        public final Builder transcriptionJobName(String transcriptionJobName) {
            this.transcriptionJobName = transcriptionJobName;
            return this;
        }

        public final void setTranscriptionJobName(String transcriptionJobName) {
            this.transcriptionJobName = transcriptionJobName;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Integer getMediaSampleRateHertz() {
            return mediaSampleRateHertz;
        }

        @Override
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        public final String getMediaFormat() {
            return mediaFormat;
        }

        @Override
        public final Builder mediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
            return this;
        }

        @Override
        public final Builder mediaFormat(MediaFormat mediaFormat) {
            this.mediaFormat(mediaFormat.toString());
            return this;
        }

        public final void setMediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
        }

        public final Media.Builder getMedia() {
            return media != null ? media.toBuilder() : null;
        }

        @Override
        public final Builder media(Media media) {
            this.media = media;
            return this;
        }

        public final void setMedia(Media.BuilderImpl media) {
            this.media = media != null ? media.build() : null;
        }

        public final String getOutputBucketName() {
            return outputBucketName;
        }

        @Override
        public final Builder outputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
            return this;
        }

        public final void setOutputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
        }

        public final Settings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(Settings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTranscriptionJobRequest build() {
            return new StartTranscriptionJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
