/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum LanguageCode {
    EN_US("en-US"),

    ES_US("es-US"),

    EN_AU("en-AU"),

    FR_CA("fr-CA"),

    EN_GB("en-GB"),

    DE_DE("de-DE"),

    PT_BR("pt-BR"),

    FR_FR("fr-FR"),

    IT_IT("it-IT"),

    KO_KR("ko-KR"),

    ES_ES("es-ES"),

    EN_IN("en-IN"),

    HI_IN("hi-IN"),

    AR_SA("ar-SA"),

    RU_RU("ru-RU"),

    ZH_CN("zh-CN"),

    NL_NL("nl-NL"),

    ID_ID("id-ID"),

    TA_IN("ta-IN"),

    FA_IR("fa-IR"),

    EN_IE("en-IE"),

    EN_AB("en-AB"),

    EN_WL("en-WL"),

    PT_PT("pt-PT"),

    TE_IN("te-IN"),

    TR_TR("tr-TR"),

    DE_CH("de-CH"),

    HE_IL("he-IL"),

    MS_MY("ms-MY"),

    JA_JP("ja-JP"),

    AR_AE("ar-AE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LanguageCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return LanguageCode corresponding to the value
     */
    public static LanguageCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LanguageCode.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link LanguageCode}s
     */
    public static Set<LanguageCode> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
