/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.TranscribeResponse;
import software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus;
import software.amazon.awssdk.services.transcribe.model.TranscriptionJobSummariesCopier;
import software.amazon.awssdk.services.transcribe.model.TranscriptionJobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTranscriptionJobsResponse
extends TranscribeResponse
implements ToCopyableBuilder<Builder, ListTranscriptionJobsResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTranscriptionJobsResponse.getter(ListTranscriptionJobsResponse::statusAsString)).setter(ListTranscriptionJobsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTranscriptionJobsResponse.getter(ListTranscriptionJobsResponse::nextToken)).setter(ListTranscriptionJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<TranscriptionJobSummary>> TRANSCRIPTION_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListTranscriptionJobsResponse.getter(ListTranscriptionJobsResponse::transcriptionJobSummaries)).setter(ListTranscriptionJobsResponse.setter(Builder::transcriptionJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TranscriptionJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, NEXT_TOKEN_FIELD, TRANSCRIPTION_JOB_SUMMARIES_FIELD));
    private final String status;
    private final String nextToken;
    private final List<TranscriptionJobSummary> transcriptionJobSummaries;

    private ListTranscriptionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.transcriptionJobSummaries = builder.transcriptionJobSummaries;
    }

    public TranscriptionJobStatus status() {
        return TranscriptionJobStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasTranscriptionJobSummaries() {
        return this.transcriptionJobSummaries != null && !(this.transcriptionJobSummaries instanceof SdkAutoConstructList);
    }

    public List<TranscriptionJobSummary> transcriptionJobSummaries() {
        return this.transcriptionJobSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptionJobSummaries());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTranscriptionJobsResponse)) {
            return false;
        }
        ListTranscriptionJobsResponse other = (ListTranscriptionJobsResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.transcriptionJobSummaries(), other.transcriptionJobSummaries());
    }

    public String toString() {
        return ToString.builder((String)"ListTranscriptionJobsResponse").add("Status", (Object)this.statusAsString()).add("NextToken", (Object)this.nextToken()).add("TranscriptionJobSummaries", this.transcriptionJobSummaries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TranscriptionJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.transcriptionJobSummaries()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTranscriptionJobsResponse, T> g) {
        return obj -> g.apply((ListTranscriptionJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeResponse.BuilderImpl
    implements Builder {
        private String status;
        private String nextToken;
        private List<TranscriptionJobSummary> transcriptionJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTranscriptionJobsResponse model) {
            super(model);
            this.status(model.status);
            this.nextToken(model.nextToken);
            this.transcriptionJobSummaries(model.transcriptionJobSummaries);
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TranscriptionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<TranscriptionJobSummary.Builder> getTranscriptionJobSummaries() {
            return this.transcriptionJobSummaries != null ? (Collection)this.transcriptionJobSummaries.stream().map(TranscriptionJobSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder transcriptionJobSummaries(Collection<TranscriptionJobSummary> transcriptionJobSummaries) {
            this.transcriptionJobSummaries = TranscriptionJobSummariesCopier.copy(transcriptionJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transcriptionJobSummaries(TranscriptionJobSummary ... transcriptionJobSummaries) {
            this.transcriptionJobSummaries(Arrays.asList(transcriptionJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transcriptionJobSummaries(Consumer<TranscriptionJobSummary.Builder> ... transcriptionJobSummaries) {
            this.transcriptionJobSummaries(Stream.of(transcriptionJobSummaries).map(c -> (TranscriptionJobSummary)((TranscriptionJobSummary.Builder)TranscriptionJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTranscriptionJobSummaries(Collection<TranscriptionJobSummary.BuilderImpl> transcriptionJobSummaries) {
            this.transcriptionJobSummaries = TranscriptionJobSummariesCopier.copyFromBuilder(transcriptionJobSummaries);
        }

        @Override
        public ListTranscriptionJobsResponse build() {
            return new ListTranscriptionJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranscribeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTranscriptionJobsResponse> {
        public Builder status(String var1);

        public Builder status(TranscriptionJobStatus var1);

        public Builder nextToken(String var1);

        public Builder transcriptionJobSummaries(Collection<TranscriptionJobSummary> var1);

        public Builder transcriptionJobSummaries(TranscriptionJobSummary ... var1);

        public Builder transcriptionJobSummaries(Consumer<TranscriptionJobSummary.Builder> ... var1);
    }
}

