/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVocabularyFiltersResponse extends TranscribeResponse implements
        ToCopyableBuilder<ListVocabularyFiltersResponse.Builder, ListVocabularyFiltersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListVocabularyFiltersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<VocabularyFilterInfo>> VOCABULARY_FILTERS_FIELD = SdkField
            .<List<VocabularyFilterInfo>> builder(MarshallingType.LIST)
            .getter(getter(ListVocabularyFiltersResponse::vocabularyFilters))
            .setter(setter(Builder::vocabularyFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VocabularyFilterInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(VocabularyFilterInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            VOCABULARY_FILTERS_FIELD));

    private final String nextToken;

    private final List<VocabularyFilterInfo> vocabularyFilters;

    private ListVocabularyFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.vocabularyFilters = builder.vocabularyFilters;
    }

    /**
     * <p>
     * The <code>ListVocabularyFilters</code> operation returns a page of collections at a time. The maximum size of the
     * page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the page size,
     * Amazon Transcribe returns the <code>NextPage</code> token. Include the token in the next request to the
     * <code>ListVocabularyFilters</code> operation to return in the next page of jobs.
     * </p>
     * 
     * @return The <code>ListVocabularyFilters</code> operation returns a page of collections at a time. The maximum
     *         size of the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than
     *         the page size, Amazon Transcribe returns the <code>NextPage</code> token. Include the token in the next
     *         request to the <code>ListVocabularyFilters</code> operation to return in the next page of jobs.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the VocabularyFilters property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVocabularyFilters() {
        return vocabularyFilters != null && !(vocabularyFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of vocabulary filters. It will contain at most <code>MaxResults</code> number of filters. If there are
     * more filters, call the <code>ListVocabularyFilters</code> operation again with the <code>NextToken</code>
     * parameter in the request set to the value of the <code>NextToken</code> field in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVocabularyFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of vocabulary filters. It will contain at most <code>MaxResults</code> number of filters. If
     *         there are more filters, call the <code>ListVocabularyFilters</code> operation again with the
     *         <code>NextToken</code> parameter in the request set to the value of the <code>NextToken</code> field in
     *         the response.
     */
    public List<VocabularyFilterInfo> vocabularyFilters() {
        return vocabularyFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVocabularyFiltersResponse)) {
            return false;
        }
        ListVocabularyFiltersResponse other = (ListVocabularyFiltersResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(vocabularyFilters(), other.vocabularyFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListVocabularyFiltersResponse").add("NextToken", nextToken())
                .add("VocabularyFilters", vocabularyFilters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "VocabularyFilters":
            return Optional.ofNullable(clazz.cast(vocabularyFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVocabularyFiltersResponse, T> g) {
        return obj -> g.apply((ListVocabularyFiltersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListVocabularyFiltersResponse> {
        /**
         * <p>
         * The <code>ListVocabularyFilters</code> operation returns a page of collections at a time. The maximum size of
         * the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the page
         * size, Amazon Transcribe returns the <code>NextPage</code> token. Include the token in the next request to the
         * <code>ListVocabularyFilters</code> operation to return in the next page of jobs.
         * </p>
         * 
         * @param nextToken
         *        The <code>ListVocabularyFilters</code> operation returns a page of collections at a time. The maximum
         *        size of the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list
         *        than the page size, Amazon Transcribe returns the <code>NextPage</code> token. Include the token in
         *        the next request to the <code>ListVocabularyFilters</code> operation to return in the next page of
         *        jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of vocabulary filters. It will contain at most <code>MaxResults</code> number of filters. If there
         * are more filters, call the <code>ListVocabularyFilters</code> operation again with the <code>NextToken</code>
         * parameter in the request set to the value of the <code>NextToken</code> field in the response.
         * </p>
         * 
         * @param vocabularyFilters
         *        The list of vocabulary filters. It will contain at most <code>MaxResults</code> number of filters. If
         *        there are more filters, call the <code>ListVocabularyFilters</code> operation again with the
         *        <code>NextToken</code> parameter in the request set to the value of the <code>NextToken</code> field
         *        in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilters(Collection<VocabularyFilterInfo> vocabularyFilters);

        /**
         * <p>
         * The list of vocabulary filters. It will contain at most <code>MaxResults</code> number of filters. If there
         * are more filters, call the <code>ListVocabularyFilters</code> operation again with the <code>NextToken</code>
         * parameter in the request set to the value of the <code>NextToken</code> field in the response.
         * </p>
         * 
         * @param vocabularyFilters
         *        The list of vocabulary filters. It will contain at most <code>MaxResults</code> number of filters. If
         *        there are more filters, call the <code>ListVocabularyFilters</code> operation again with the
         *        <code>NextToken</code> parameter in the request set to the value of the <code>NextToken</code> field
         *        in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilters(VocabularyFilterInfo... vocabularyFilters);

        /**
         * <p>
         * The list of vocabulary filters. It will contain at most <code>MaxResults</code> number of filters. If there
         * are more filters, call the <code>ListVocabularyFilters</code> operation again with the <code>NextToken</code>
         * parameter in the request set to the value of the <code>NextToken</code> field in the response.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VocabularyFilterInfo>.Builder} avoiding the
         * need to create one manually via {@link List<VocabularyFilterInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VocabularyFilterInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #vocabularyFilters(List<VocabularyFilterInfo>)}.
         * 
         * @param vocabularyFilters
         *        a consumer that will call methods on {@link List<VocabularyFilterInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vocabularyFilters(List<VocabularyFilterInfo>)
         */
        Builder vocabularyFilters(Consumer<VocabularyFilterInfo.Builder>... vocabularyFilters);
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<VocabularyFilterInfo> vocabularyFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVocabularyFiltersResponse model) {
            super(model);
            nextToken(model.nextToken);
            vocabularyFilters(model.vocabularyFilters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VocabularyFilterInfo.Builder> getVocabularyFilters() {
            return vocabularyFilters != null ? vocabularyFilters.stream().map(VocabularyFilterInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vocabularyFilters(Collection<VocabularyFilterInfo> vocabularyFilters) {
            this.vocabularyFilters = VocabularyFiltersCopier.copy(vocabularyFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vocabularyFilters(VocabularyFilterInfo... vocabularyFilters) {
            vocabularyFilters(Arrays.asList(vocabularyFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vocabularyFilters(Consumer<VocabularyFilterInfo.Builder>... vocabularyFilters) {
            vocabularyFilters(Stream.of(vocabularyFilters).map(c -> VocabularyFilterInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVocabularyFilters(Collection<VocabularyFilterInfo.BuilderImpl> vocabularyFilters) {
            this.vocabularyFilters = VocabularyFiltersCopier.copyFromBuilder(vocabularyFilters);
        }

        @Override
        public ListVocabularyFiltersResponse build() {
            return new ListVocabularyFiltersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
