/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a vocabulary filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VocabularyFilterInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<VocabularyFilterInfo.Builder, VocabularyFilterInfo> {
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VocabularyFilterInfo::vocabularyFilterName)).setter(setter(Builder::vocabularyFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build())
            .build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VocabularyFilterInfo::languageCodeAsString)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(VocabularyFilterInfo::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_FILTER_NAME_FIELD,
            LANGUAGE_CODE_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vocabularyFilterName;

    private final String languageCode;

    private final Instant lastModifiedTime;

    private VocabularyFilterInfo(BuilderImpl builder) {
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.languageCode = builder.languageCode;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The name of the vocabulary filter. The name must be unique in the account that holds the filter.
     * </p>
     * 
     * @return The name of the vocabulary filter. The name must be unique in the account that holds the filter.
     */
    public String vocabularyFilterName() {
        return vocabularyFilterName;
    }

    /**
     * <p>
     * The language code of the words in the vocabulary filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the words in the vocabulary filter.
     * @see LanguageCode
     */
    public LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code of the words in the vocabulary filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the words in the vocabulary filter.
     * @see LanguageCode
     */
    public String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The date and time that the vocabulary was last updated.
     * </p>
     * 
     * @return The date and time that the vocabulary was last updated.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VocabularyFilterInfo)) {
            return false;
        }
        VocabularyFilterInfo other = (VocabularyFilterInfo) obj;
        return Objects.equals(vocabularyFilterName(), other.vocabularyFilterName())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VocabularyFilterInfo").add("VocabularyFilterName", vocabularyFilterName())
                .add("LanguageCode", languageCodeAsString()).add("LastModifiedTime", lastModifiedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VocabularyFilterName":
            return Optional.ofNullable(clazz.cast(vocabularyFilterName()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VocabularyFilterInfo, T> g) {
        return obj -> g.apply((VocabularyFilterInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VocabularyFilterInfo> {
        /**
         * <p>
         * The name of the vocabulary filter. The name must be unique in the account that holds the filter.
         * </p>
         * 
         * @param vocabularyFilterName
         *        The name of the vocabulary filter. The name must be unique in the account that holds the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterName(String vocabularyFilterName);

        /**
         * <p>
         * The language code of the words in the vocabulary filter.
         * </p>
         * 
         * @param languageCode
         *        The language code of the words in the vocabulary filter.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code of the words in the vocabulary filter.
         * </p>
         * 
         * @param languageCode
         *        The language code of the words in the vocabulary filter.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The date and time that the vocabulary was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the vocabulary was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String vocabularyFilterName;

        private String languageCode;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VocabularyFilterInfo model) {
            vocabularyFilterName(model.vocabularyFilterName);
            languageCode(model.languageCode);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getVocabularyFilterName() {
            return vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        public final String getLanguageCodeAsString() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public VocabularyFilterInfo build() {
            return new VocabularyFilterInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
