/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LanguageCode {
    EN_US("en-US"),
    ES_US("es-US"),
    EN_AU("en-AU"),
    FR_CA("fr-CA"),
    EN_GB("en-GB"),
    DE_DE("de-DE"),
    PT_BR("pt-BR"),
    FR_FR("fr-FR"),
    IT_IT("it-IT"),
    KO_KR("ko-KR"),
    ES_ES("es-ES"),
    EN_IN("en-IN"),
    HI_IN("hi-IN"),
    AR_SA("ar-SA"),
    RU_RU("ru-RU"),
    ZH_CN("zh-CN"),
    NL_NL("nl-NL"),
    ID_ID("id-ID"),
    TA_IN("ta-IN"),
    FA_IR("fa-IR"),
    EN_IE("en-IE"),
    EN_AB("en-AB"),
    EN_WL("en-WL"),
    PT_PT("pt-PT"),
    TE_IN("te-IN"),
    TR_TR("tr-TR"),
    DE_CH("de-CH"),
    HE_IL("he-IL"),
    MS_MY("ms-MY"),
    JA_JP("ja-JP"),
    AR_AE("ar-AE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LanguageCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LanguageCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LanguageCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LanguageCode> knownValues() {
        return Stream.of(LanguageCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

