/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.transcribe.TranscribeClient;
import software.amazon.awssdk.services.transcribe.model.BadRequestException;
import software.amazon.awssdk.services.transcribe.model.ConflictException;
import software.amazon.awssdk.services.transcribe.model.CreateMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.CreateMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterRequest;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterResponse;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteMedicalTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteMedicalTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteVocabularyFilterRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteVocabularyFilterResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterRequest;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterResponse;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.InternalFailureException;
import software.amazon.awssdk.services.transcribe.model.LimitExceededException;
import software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse;
import software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest;
import software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse;
import software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse;
import software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest;
import software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse;
import software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest;
import software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse;
import software.amazon.awssdk.services.transcribe.model.NotFoundException;
import software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.TranscribeException;
import software.amazon.awssdk.services.transcribe.model.TranscribeRequest;
import software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyFilterRequest;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyFilterResponse;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyResponse;
import software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsIterable;
import software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesIterable;
import software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsIterable;
import software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesIterable;
import software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersIterable;
import software.amazon.awssdk.services.transcribe.transform.CreateMedicalVocabularyRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.CreateVocabularyFilterRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.CreateVocabularyRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.DeleteMedicalTranscriptionJobRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.DeleteMedicalVocabularyRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.DeleteTranscriptionJobRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.DeleteVocabularyFilterRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.DeleteVocabularyRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.GetMedicalTranscriptionJobRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.GetMedicalVocabularyRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.GetTranscriptionJobRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.GetVocabularyFilterRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.GetVocabularyRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.ListMedicalTranscriptionJobsRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.ListMedicalVocabulariesRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.ListTranscriptionJobsRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.ListVocabulariesRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.ListVocabularyFiltersRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.StartMedicalTranscriptionJobRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.StartTranscriptionJobRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.UpdateMedicalVocabularyRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.UpdateVocabularyFilterRequestMarshaller;
import software.amazon.awssdk.services.transcribe.transform.UpdateVocabularyRequestMarshaller;

@SdkInternalApi
final class DefaultTranscribeClient
implements TranscribeClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultTranscribeClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "transcribe";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMedicalVocabularyResponse createMedicalVocabulary(CreateMedicalVocabularyRequest createMedicalVocabularyRequest) throws BadRequestException, LimitExceededException, InternalFailureException, ConflictException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMedicalVocabularyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMedicalVocabulary");
            CreateMedicalVocabularyResponse createMedicalVocabularyResponse = (CreateMedicalVocabularyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMedicalVocabulary").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMedicalVocabularyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateMedicalVocabularyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMedicalVocabularyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, createMedicalVocabularyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVocabularyResponse createVocabulary(CreateVocabularyRequest createVocabularyRequest) throws BadRequestException, LimitExceededException, InternalFailureException, ConflictException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVocabularyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVocabulary");
            CreateVocabularyResponse createVocabularyResponse = (CreateVocabularyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVocabulary").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVocabularyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateVocabularyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVocabularyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, createVocabularyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVocabularyFilterResponse createVocabularyFilter(CreateVocabularyFilterRequest createVocabularyFilterRequest) throws BadRequestException, LimitExceededException, InternalFailureException, ConflictException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVocabularyFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVocabularyFilter");
            CreateVocabularyFilterResponse createVocabularyFilterResponse = (CreateVocabularyFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVocabularyFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVocabularyFilterRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateVocabularyFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVocabularyFilterResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, createVocabularyFilterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMedicalTranscriptionJobResponse deleteMedicalTranscriptionJob(DeleteMedicalTranscriptionJobRequest deleteMedicalTranscriptionJobRequest) throws LimitExceededException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMedicalTranscriptionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMedicalTranscriptionJob");
            DeleteMedicalTranscriptionJobResponse deleteMedicalTranscriptionJobResponse = (DeleteMedicalTranscriptionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMedicalTranscriptionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMedicalTranscriptionJobRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMedicalTranscriptionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMedicalTranscriptionJobResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, deleteMedicalTranscriptionJobRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMedicalVocabularyResponse deleteMedicalVocabulary(DeleteMedicalVocabularyRequest deleteMedicalVocabularyRequest) throws NotFoundException, LimitExceededException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMedicalVocabularyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMedicalVocabulary");
            DeleteMedicalVocabularyResponse deleteMedicalVocabularyResponse = (DeleteMedicalVocabularyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMedicalVocabulary").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMedicalVocabularyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMedicalVocabularyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMedicalVocabularyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, deleteMedicalVocabularyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTranscriptionJobResponse deleteTranscriptionJob(DeleteTranscriptionJobRequest deleteTranscriptionJobRequest) throws LimitExceededException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTranscriptionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTranscriptionJob");
            DeleteTranscriptionJobResponse deleteTranscriptionJobResponse = (DeleteTranscriptionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTranscriptionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTranscriptionJobRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTranscriptionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTranscriptionJobResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, deleteTranscriptionJobRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVocabularyResponse deleteVocabulary(DeleteVocabularyRequest deleteVocabularyRequest) throws NotFoundException, LimitExceededException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVocabularyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVocabulary");
            DeleteVocabularyResponse deleteVocabularyResponse = (DeleteVocabularyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVocabulary").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVocabularyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVocabularyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVocabularyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, deleteVocabularyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVocabularyFilterResponse deleteVocabularyFilter(DeleteVocabularyFilterRequest deleteVocabularyFilterRequest) throws NotFoundException, LimitExceededException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVocabularyFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVocabularyFilter");
            DeleteVocabularyFilterResponse deleteVocabularyFilterResponse = (DeleteVocabularyFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVocabularyFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVocabularyFilterRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVocabularyFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVocabularyFilterResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, deleteVocabularyFilterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMedicalTranscriptionJobResponse getMedicalTranscriptionJob(GetMedicalTranscriptionJobRequest getMedicalTranscriptionJobRequest) throws BadRequestException, LimitExceededException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMedicalTranscriptionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMedicalTranscriptionJob");
            GetMedicalTranscriptionJobResponse getMedicalTranscriptionJobResponse = (GetMedicalTranscriptionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMedicalTranscriptionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMedicalTranscriptionJobRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetMedicalTranscriptionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMedicalTranscriptionJobResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, getMedicalTranscriptionJobRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMedicalVocabularyResponse getMedicalVocabulary(GetMedicalVocabularyRequest getMedicalVocabularyRequest) throws NotFoundException, LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMedicalVocabularyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMedicalVocabulary");
            GetMedicalVocabularyResponse getMedicalVocabularyResponse = (GetMedicalVocabularyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMedicalVocabulary").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMedicalVocabularyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetMedicalVocabularyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMedicalVocabularyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, getMedicalVocabularyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTranscriptionJobResponse getTranscriptionJob(GetTranscriptionJobRequest getTranscriptionJobRequest) throws BadRequestException, LimitExceededException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTranscriptionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTranscriptionJob");
            GetTranscriptionJobResponse getTranscriptionJobResponse = (GetTranscriptionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTranscriptionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTranscriptionJobRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetTranscriptionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTranscriptionJobResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, getTranscriptionJobRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetVocabularyResponse getVocabulary(GetVocabularyRequest getVocabularyRequest) throws NotFoundException, LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVocabularyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVocabulary");
            GetVocabularyResponse getVocabularyResponse = (GetVocabularyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVocabulary").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getVocabularyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetVocabularyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getVocabularyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, getVocabularyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetVocabularyFilterResponse getVocabularyFilter(GetVocabularyFilterRequest getVocabularyFilterRequest) throws NotFoundException, LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVocabularyFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVocabularyFilter");
            GetVocabularyFilterResponse getVocabularyFilterResponse = (GetVocabularyFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVocabularyFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getVocabularyFilterRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetVocabularyFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getVocabularyFilterResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, getVocabularyFilterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMedicalTranscriptionJobsResponse listMedicalTranscriptionJobs(ListMedicalTranscriptionJobsRequest listMedicalTranscriptionJobsRequest) throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMedicalTranscriptionJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMedicalTranscriptionJobs");
            ListMedicalTranscriptionJobsResponse listMedicalTranscriptionJobsResponse = (ListMedicalTranscriptionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMedicalTranscriptionJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMedicalTranscriptionJobsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListMedicalTranscriptionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMedicalTranscriptionJobsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, listMedicalTranscriptionJobsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListMedicalTranscriptionJobsIterable listMedicalTranscriptionJobsPaginator(ListMedicalTranscriptionJobsRequest listMedicalTranscriptionJobsRequest) throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return new ListMedicalTranscriptionJobsIterable(this, this.applyPaginatorUserAgent(listMedicalTranscriptionJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMedicalVocabulariesResponse listMedicalVocabularies(ListMedicalVocabulariesRequest listMedicalVocabulariesRequest) throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMedicalVocabulariesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMedicalVocabularies");
            ListMedicalVocabulariesResponse listMedicalVocabulariesResponse = (ListMedicalVocabulariesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMedicalVocabularies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMedicalVocabulariesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListMedicalVocabulariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMedicalVocabulariesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, listMedicalVocabulariesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListMedicalVocabulariesIterable listMedicalVocabulariesPaginator(ListMedicalVocabulariesRequest listMedicalVocabulariesRequest) throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return new ListMedicalVocabulariesIterable(this, this.applyPaginatorUserAgent(listMedicalVocabulariesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTranscriptionJobsResponse listTranscriptionJobs(ListTranscriptionJobsRequest listTranscriptionJobsRequest) throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTranscriptionJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTranscriptionJobs");
            ListTranscriptionJobsResponse listTranscriptionJobsResponse = (ListTranscriptionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTranscriptionJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTranscriptionJobsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTranscriptionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTranscriptionJobsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, listTranscriptionJobsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListTranscriptionJobsIterable listTranscriptionJobsPaginator(ListTranscriptionJobsRequest listTranscriptionJobsRequest) throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return new ListTranscriptionJobsIterable(this, this.applyPaginatorUserAgent(listTranscriptionJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVocabulariesResponse listVocabularies(ListVocabulariesRequest listVocabulariesRequest) throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVocabulariesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVocabularies");
            ListVocabulariesResponse listVocabulariesResponse = (ListVocabulariesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVocabularies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listVocabulariesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListVocabulariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVocabulariesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, listVocabulariesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListVocabulariesIterable listVocabulariesPaginator(ListVocabulariesRequest listVocabulariesRequest) throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return new ListVocabulariesIterable(this, this.applyPaginatorUserAgent(listVocabulariesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVocabularyFiltersResponse listVocabularyFilters(ListVocabularyFiltersRequest listVocabularyFiltersRequest) throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVocabularyFiltersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVocabularyFilters");
            ListVocabularyFiltersResponse listVocabularyFiltersResponse = (ListVocabularyFiltersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVocabularyFilters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listVocabularyFiltersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListVocabularyFiltersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVocabularyFiltersResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, listVocabularyFiltersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListVocabularyFiltersIterable listVocabularyFiltersPaginator(ListVocabularyFiltersRequest listVocabularyFiltersRequest) throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return new ListVocabularyFiltersIterable(this, this.applyPaginatorUserAgent(listVocabularyFiltersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartMedicalTranscriptionJobResponse startMedicalTranscriptionJob(StartMedicalTranscriptionJobRequest startMedicalTranscriptionJobRequest) throws BadRequestException, LimitExceededException, InternalFailureException, ConflictException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMedicalTranscriptionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMedicalTranscriptionJob");
            StartMedicalTranscriptionJobResponse startMedicalTranscriptionJobResponse = (StartMedicalTranscriptionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMedicalTranscriptionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startMedicalTranscriptionJobRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new StartMedicalTranscriptionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startMedicalTranscriptionJobResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, startMedicalTranscriptionJobRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartTranscriptionJobResponse startTranscriptionJob(StartTranscriptionJobRequest startTranscriptionJobRequest) throws BadRequestException, LimitExceededException, InternalFailureException, ConflictException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTranscriptionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTranscriptionJob");
            StartTranscriptionJobResponse startTranscriptionJobResponse = (StartTranscriptionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTranscriptionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startTranscriptionJobRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new StartTranscriptionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startTranscriptionJobResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, startTranscriptionJobRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateMedicalVocabularyResponse updateMedicalVocabulary(UpdateMedicalVocabularyRequest updateMedicalVocabularyRequest) throws BadRequestException, LimitExceededException, InternalFailureException, NotFoundException, ConflictException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMedicalVocabularyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMedicalVocabulary");
            UpdateMedicalVocabularyResponse updateMedicalVocabularyResponse = (UpdateMedicalVocabularyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMedicalVocabulary").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateMedicalVocabularyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateMedicalVocabularyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateMedicalVocabularyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, updateMedicalVocabularyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateVocabularyResponse updateVocabulary(UpdateVocabularyRequest updateVocabularyRequest) throws BadRequestException, LimitExceededException, InternalFailureException, NotFoundException, ConflictException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVocabularyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVocabulary");
            UpdateVocabularyResponse updateVocabularyResponse = (UpdateVocabularyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVocabulary").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateVocabularyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateVocabularyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateVocabularyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, updateVocabularyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateVocabularyFilterResponse updateVocabularyFilter(UpdateVocabularyFilterRequest updateVocabularyFilterRequest) throws BadRequestException, LimitExceededException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException, TranscribeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVocabularyFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transcribe");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVocabularyFilter");
            UpdateVocabularyFilterResponse updateVocabularyFilterResponse = (UpdateVocabularyFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVocabularyFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateVocabularyFilterRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateVocabularyFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateVocabularyFilterResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultTranscribeClient.resolveMetricPublishers(this.clientConfiguration, updateVocabularyFilterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(TranscribeException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalFailureException").exceptionBuilderSupplier(InternalFailureException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends TranscribeRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.61").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((TranscribeRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

