/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobExecutionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobExecutionSettings> {
    private static final SdkField<Boolean> ALLOW_DEFERRED_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(JobExecutionSettings.getter(JobExecutionSettings::allowDeferredExecution)).setter(JobExecutionSettings.setter(Builder::allowDeferredExecution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowDeferredExecution").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobExecutionSettings.getter(JobExecutionSettings::dataAccessRoleArn)).setter(JobExecutionSettings.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_DEFERRED_EXECUTION_FIELD, DATA_ACCESS_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean allowDeferredExecution;
    private final String dataAccessRoleArn;

    private JobExecutionSettings(BuilderImpl builder) {
        this.allowDeferredExecution = builder.allowDeferredExecution;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
    }

    public Boolean allowDeferredExecution() {
        return this.allowDeferredExecution;
    }

    public String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowDeferredExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionSettings)) {
            return false;
        }
        JobExecutionSettings other = (JobExecutionSettings)obj;
        return Objects.equals(this.allowDeferredExecution(), other.allowDeferredExecution()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn());
    }

    public String toString() {
        return ToString.builder((String)"JobExecutionSettings").add("AllowDeferredExecution", (Object)this.allowDeferredExecution()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowDeferredExecution": {
                return Optional.ofNullable(clazz.cast(this.allowDeferredExecution()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobExecutionSettings, T> g) {
        return obj -> g.apply((JobExecutionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean allowDeferredExecution;
        private String dataAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionSettings model) {
            this.allowDeferredExecution(model.allowDeferredExecution);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
        }

        public final Boolean getAllowDeferredExecution() {
            return this.allowDeferredExecution;
        }

        @Override
        public final Builder allowDeferredExecution(Boolean allowDeferredExecution) {
            this.allowDeferredExecution = allowDeferredExecution;
            return this;
        }

        public final void setAllowDeferredExecution(Boolean allowDeferredExecution) {
            this.allowDeferredExecution = allowDeferredExecution;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        public JobExecutionSettings build() {
            return new JobExecutionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobExecutionSettings> {
        public Builder allowDeferredExecution(Boolean var1);

        public Builder dataAccessRoleArn(String var1);
    }
}

