/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMedicalVocabularyRequest extends TranscribeRequest implements
        ToCopyableBuilder<CreateMedicalVocabularyRequest.Builder, CreateMedicalVocabularyRequest> {
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateMedicalVocabularyRequest::vocabularyName)).setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateMedicalVocabularyRequest::languageCodeAsString)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> VOCABULARY_FILE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateMedicalVocabularyRequest::vocabularyFileUri)).setter(setter(Builder::vocabularyFileUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFileUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_NAME_FIELD,
            LANGUAGE_CODE_FIELD, VOCABULARY_FILE_URI_FIELD));

    private final String vocabularyName;

    private final String languageCode;

    private final String vocabularyFileUri;

    private CreateMedicalVocabularyRequest(BuilderImpl builder) {
        super(builder);
        this.vocabularyName = builder.vocabularyName;
        this.languageCode = builder.languageCode;
        this.vocabularyFileUri = builder.vocabularyFileUri;
    }

    /**
     * <p>
     * The name of the custom vocabulary. This case-sensitive name must be unique within an AWS account. If you try to
     * create a vocabulary with the same name as a previous vocabulary, you get a <code>ConflictException</code> error.
     * </p>
     * 
     * @return The name of the custom vocabulary. This case-sensitive name must be unique within an AWS account. If you
     *         try to create a vocabulary with the same name as a previous vocabulary, you get a
     *         <code>ConflictException</code> error.
     */
    public String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * The language code for the language used for the entries in your custom vocabulary. The language code of your
     * custom vocabulary must match the language code of your transcription job. US English (en-US) is the only language
     * code available for Amazon Transcribe Medical.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code for the language used for the entries in your custom vocabulary. The language code of
     *         your custom vocabulary must match the language code of your transcription job. US English (en-US) is the
     *         only language code available for Amazon Transcribe Medical.
     * @see LanguageCode
     */
    public LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code for the language used for the entries in your custom vocabulary. The language code of your
     * custom vocabulary must match the language code of your transcription job. US English (en-US) is the only language
     * code available for Amazon Transcribe Medical.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code for the language used for the entries in your custom vocabulary. The language code of
     *         your custom vocabulary must match the language code of your transcription job. US English (en-US) is the
     *         only language code available for Amazon Transcribe Medical.
     * @see LanguageCode
     */
    public String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The location in Amazon S3 of the text file you use to define your custom vocabulary. The URI must be in the same
     * AWS Region as the resource that you're calling. Enter information about your <code>VocabularyFileUri</code> in
     * the following format:
     * </p>
     * <p>
     * <code> https://s3.&lt;aws-region&gt;.amazonaws.com/&lt;bucket-name&gt;/&lt;keyprefix&gt;/&lt;objectkey&gt; </code>
     * </p>
     * <p>
     * The following is an example URI for a vocabulary file that is stored in Amazon S3:
     * </p>
     * <p>
     * <code>https://s3.us-east-1.amazonaws.com/AWSDOC-EXAMPLE-BUCKET/vocab.txt</code>
     * </p>
     * <p>
     * For more information about Amazon S3 object names, see <a
     * href="http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in the
     * <i>Amazon S3 Developer Guide</i>.
     * </p>
     * <p>
     * For more information about custom vocabularies, see <a
     * href="http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary-med">Medical Custom
     * Vocabularies</a>.
     * </p>
     * 
     * @return The location in Amazon S3 of the text file you use to define your custom vocabulary. The URI must be in
     *         the same AWS Region as the resource that you're calling. Enter information about your
     *         <code>VocabularyFileUri</code> in the following format:</p>
     *         <p>
     *         <code> https://s3.&lt;aws-region&gt;.amazonaws.com/&lt;bucket-name&gt;/&lt;keyprefix&gt;/&lt;objectkey&gt; </code>
     *         </p>
     *         <p>
     *         The following is an example URI for a vocabulary file that is stored in Amazon S3:
     *         </p>
     *         <p>
     *         <code>https://s3.us-east-1.amazonaws.com/AWSDOC-EXAMPLE-BUCKET/vocab.txt</code>
     *         </p>
     *         <p>
     *         For more information about Amazon S3 object names, see <a
     *         href="http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in
     *         the <i>Amazon S3 Developer Guide</i>.
     *         </p>
     *         <p>
     *         For more information about custom vocabularies, see <a
     *         href="http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary-med">Medical
     *         Custom Vocabularies</a>.
     */
    public String vocabularyFileUri() {
        return vocabularyFileUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFileUri());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMedicalVocabularyRequest)) {
            return false;
        }
        CreateMedicalVocabularyRequest other = (CreateMedicalVocabularyRequest) obj;
        return Objects.equals(vocabularyName(), other.vocabularyName())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(vocabularyFileUri(), other.vocabularyFileUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateMedicalVocabularyRequest").add("VocabularyName", vocabularyName())
                .add("LanguageCode", languageCodeAsString()).add("VocabularyFileUri", vocabularyFileUri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "VocabularyFileUri":
            return Optional.ofNullable(clazz.cast(vocabularyFileUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMedicalVocabularyRequest, T> g) {
        return obj -> g.apply((CreateMedicalVocabularyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMedicalVocabularyRequest> {
        /**
         * <p>
         * The name of the custom vocabulary. This case-sensitive name must be unique within an AWS account. If you try
         * to create a vocabulary with the same name as a previous vocabulary, you get a <code>ConflictException</code>
         * error.
         * </p>
         * 
         * @param vocabularyName
         *        The name of the custom vocabulary. This case-sensitive name must be unique within an AWS account. If
         *        you try to create a vocabulary with the same name as a previous vocabulary, you get a
         *        <code>ConflictException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * The language code for the language used for the entries in your custom vocabulary. The language code of your
         * custom vocabulary must match the language code of your transcription job. US English (en-US) is the only
         * language code available for Amazon Transcribe Medical.
         * </p>
         * 
         * @param languageCode
         *        The language code for the language used for the entries in your custom vocabulary. The language code
         *        of your custom vocabulary must match the language code of your transcription job. US English (en-US)
         *        is the only language code available for Amazon Transcribe Medical.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code for the language used for the entries in your custom vocabulary. The language code of your
         * custom vocabulary must match the language code of your transcription job. US English (en-US) is the only
         * language code available for Amazon Transcribe Medical.
         * </p>
         * 
         * @param languageCode
         *        The language code for the language used for the entries in your custom vocabulary. The language code
         *        of your custom vocabulary must match the language code of your transcription job. US English (en-US)
         *        is the only language code available for Amazon Transcribe Medical.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The location in Amazon S3 of the text file you use to define your custom vocabulary. The URI must be in the
         * same AWS Region as the resource that you're calling. Enter information about your
         * <code>VocabularyFileUri</code> in the following format:
         * </p>
         * <p>
         * <code> https://s3.&lt;aws-region&gt;.amazonaws.com/&lt;bucket-name&gt;/&lt;keyprefix&gt;/&lt;objectkey&gt; </code>
         * </p>
         * <p>
         * The following is an example URI for a vocabulary file that is stored in Amazon S3:
         * </p>
         * <p>
         * <code>https://s3.us-east-1.amazonaws.com/AWSDOC-EXAMPLE-BUCKET/vocab.txt</code>
         * </p>
         * <p>
         * For more information about Amazon S3 object names, see <a
         * href="http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in the
         * <i>Amazon S3 Developer Guide</i>.
         * </p>
         * <p>
         * For more information about custom vocabularies, see <a
         * href="http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary-med">Medical Custom
         * Vocabularies</a>.
         * </p>
         * 
         * @param vocabularyFileUri
         *        The location in Amazon S3 of the text file you use to define your custom vocabulary. The URI must be
         *        in the same AWS Region as the resource that you're calling. Enter information about your
         *        <code>VocabularyFileUri</code> in the following format:</p>
         *        <p>
         *        <code> https://s3.&lt;aws-region&gt;.amazonaws.com/&lt;bucket-name&gt;/&lt;keyprefix&gt;/&lt;objectkey&gt; </code>
         *        </p>
         *        <p>
         *        The following is an example URI for a vocabulary file that is stored in Amazon S3:
         *        </p>
         *        <p>
         *        <code>https://s3.us-east-1.amazonaws.com/AWSDOC-EXAMPLE-BUCKET/vocab.txt</code>
         *        </p>
         *        <p>
         *        For more information about Amazon S3 object names, see <a
         *        href="http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a>
         *        in the <i>Amazon S3 Developer Guide</i>.
         *        </p>
         *        <p>
         *        For more information about custom vocabularies, see <a
         *        href="http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary-med">Medical
         *        Custom Vocabularies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFileUri(String vocabularyFileUri);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String vocabularyName;

        private String languageCode;

        private String vocabularyFileUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMedicalVocabularyRequest model) {
            super(model);
            vocabularyName(model.vocabularyName);
            languageCode(model.languageCode);
            vocabularyFileUri(model.vocabularyFileUri);
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getVocabularyFileUri() {
            return vocabularyFileUri;
        }

        @Override
        public final Builder vocabularyFileUri(String vocabularyFileUri) {
            this.vocabularyFileUri = vocabularyFileUri;
            return this;
        }

        public final void setVocabularyFileUri(String vocabularyFileUri) {
            this.vocabularyFileUri = vocabularyFileUri;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMedicalVocabularyRequest build() {
            return new CreateMedicalVocabularyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
