/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVocabularyRequest extends TranscribeRequest implements
        ToCopyableBuilder<UpdateVocabularyRequest.Builder, UpdateVocabularyRequest> {
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateVocabularyRequest::vocabularyName)).setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateVocabularyRequest::languageCodeAsString)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<List<String>> PHRASES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateVocabularyRequest::phrases))
            .setter(setter(Builder::phrases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phrases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VOCABULARY_FILE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateVocabularyRequest::vocabularyFileUri)).setter(setter(Builder::vocabularyFileUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFileUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_NAME_FIELD,
            LANGUAGE_CODE_FIELD, PHRASES_FIELD, VOCABULARY_FILE_URI_FIELD));

    private final String vocabularyName;

    private final String languageCode;

    private final List<String> phrases;

    private final String vocabularyFileUri;

    private UpdateVocabularyRequest(BuilderImpl builder) {
        super(builder);
        this.vocabularyName = builder.vocabularyName;
        this.languageCode = builder.languageCode;
        this.phrases = builder.phrases;
        this.vocabularyFileUri = builder.vocabularyFileUri;
    }

    /**
     * <p>
     * The name of the vocabulary to update. The name is case sensitive. If you try to update a vocabulary with the same
     * name as a previous vocabulary you will receive a <code>ConflictException</code> error.
     * </p>
     * 
     * @return The name of the vocabulary to update. The name is case sensitive. If you try to update a vocabulary with
     *         the same name as a previous vocabulary you will receive a <code>ConflictException</code> error.
     */
    public String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * The language code of the vocabulary entries.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the vocabulary entries.
     * @see LanguageCode
     */
    public LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code of the vocabulary entries.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the vocabulary entries.
     * @see LanguageCode
     */
    public String languageCodeAsString() {
        return languageCode;
    }

    /**
     * Returns true if the Phrases property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPhrases() {
        return phrases != null && !(phrases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings containing the vocabulary entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPhrases()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of strings containing the vocabulary entries.
     */
    public List<String> phrases() {
        return phrases;
    }

    /**
     * <p>
     * The S3 location of the text file that contains the definition of the custom vocabulary. The URI must be in the
     * same region as the API endpoint that you are calling. The general form is
     * </p>
     * <p>
     * For example:
     * </p>
     * <p>
     * For more information about S3 object names, see <a
     * href="http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in the
     * <i>Amazon S3 Developer Guide</i>.
     * </p>
     * <p>
     * For more information about custom vocabularies, see <a
     * href="http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary">Custom Vocabularies</a>.
     * </p>
     * 
     * @return The S3 location of the text file that contains the definition of the custom vocabulary. The URI must be
     *         in the same region as the API endpoint that you are calling. The general form is </p>
     *         <p>
     *         For example:
     *         </p>
     *         <p>
     *         For more information about S3 object names, see <a
     *         href="http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in
     *         the <i>Amazon S3 Developer Guide</i>.
     *         </p>
     *         <p>
     *         For more information about custom vocabularies, see <a
     *         href="http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary">Custom
     *         Vocabularies</a>.
     */
    public String vocabularyFileUri() {
        return vocabularyFileUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(phrases());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFileUri());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVocabularyRequest)) {
            return false;
        }
        UpdateVocabularyRequest other = (UpdateVocabularyRequest) obj;
        return Objects.equals(vocabularyName(), other.vocabularyName())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(phrases(), other.phrases()) && Objects.equals(vocabularyFileUri(), other.vocabularyFileUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateVocabularyRequest").add("VocabularyName", vocabularyName())
                .add("LanguageCode", languageCodeAsString()).add("Phrases", phrases())
                .add("VocabularyFileUri", vocabularyFileUri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "Phrases":
            return Optional.ofNullable(clazz.cast(phrases()));
        case "VocabularyFileUri":
            return Optional.ofNullable(clazz.cast(vocabularyFileUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVocabularyRequest, T> g) {
        return obj -> g.apply((UpdateVocabularyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVocabularyRequest> {
        /**
         * <p>
         * The name of the vocabulary to update. The name is case sensitive. If you try to update a vocabulary with the
         * same name as a previous vocabulary you will receive a <code>ConflictException</code> error.
         * </p>
         * 
         * @param vocabularyName
         *        The name of the vocabulary to update. The name is case sensitive. If you try to update a vocabulary
         *        with the same name as a previous vocabulary you will receive a <code>ConflictException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * The language code of the vocabulary entries.
         * </p>
         * 
         * @param languageCode
         *        The language code of the vocabulary entries.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code of the vocabulary entries.
         * </p>
         * 
         * @param languageCode
         *        The language code of the vocabulary entries.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * An array of strings containing the vocabulary entries.
         * </p>
         * 
         * @param phrases
         *        An array of strings containing the vocabulary entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phrases(Collection<String> phrases);

        /**
         * <p>
         * An array of strings containing the vocabulary entries.
         * </p>
         * 
         * @param phrases
         *        An array of strings containing the vocabulary entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phrases(String... phrases);

        /**
         * <p>
         * The S3 location of the text file that contains the definition of the custom vocabulary. The URI must be in
         * the same region as the API endpoint that you are calling. The general form is
         * </p>
         * <p>
         * For example:
         * </p>
         * <p>
         * For more information about S3 object names, see <a
         * href="http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in the
         * <i>Amazon S3 Developer Guide</i>.
         * </p>
         * <p>
         * For more information about custom vocabularies, see <a
         * href="http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary">Custom
         * Vocabularies</a>.
         * </p>
         * 
         * @param vocabularyFileUri
         *        The S3 location of the text file that contains the definition of the custom vocabulary. The URI must
         *        be in the same region as the API endpoint that you are calling. The general form is </p>
         *        <p>
         *        For example:
         *        </p>
         *        <p>
         *        For more information about S3 object names, see <a
         *        href="http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a>
         *        in the <i>Amazon S3 Developer Guide</i>.
         *        </p>
         *        <p>
         *        For more information about custom vocabularies, see <a
         *        href="http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary">Custom
         *        Vocabularies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFileUri(String vocabularyFileUri);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String vocabularyName;

        private String languageCode;

        private List<String> phrases = DefaultSdkAutoConstructList.getInstance();

        private String vocabularyFileUri;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVocabularyRequest model) {
            super(model);
            vocabularyName(model.vocabularyName);
            languageCode(model.languageCode);
            phrases(model.phrases);
            vocabularyFileUri(model.vocabularyFileUri);
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Collection<String> getPhrases() {
            return phrases;
        }

        @Override
        public final Builder phrases(Collection<String> phrases) {
            this.phrases = PhrasesCopier.copy(phrases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phrases(String... phrases) {
            phrases(Arrays.asList(phrases));
            return this;
        }

        public final void setPhrases(Collection<String> phrases) {
            this.phrases = PhrasesCopier.copy(phrases);
        }

        public final String getVocabularyFileUri() {
            return vocabularyFileUri;
        }

        @Override
        public final Builder vocabularyFileUri(String vocabularyFileUri) {
            this.vocabularyFileUri = vocabularyFileUri;
            return this;
        }

        public final void setVocabularyFileUri(String vocabularyFileUri) {
            this.vocabularyFileUri = vocabularyFileUri;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVocabularyRequest build() {
            return new UpdateVocabularyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
