/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputDataConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputDataConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputDataConfig.getter(InputDataConfig::s3Uri)).setter(InputDataConfig.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final SdkField<String> TUNING_DATA_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputDataConfig.getter(InputDataConfig::tuningDataS3Uri)).setter(InputDataConfig.setter(Builder::tuningDataS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TuningDataS3Uri").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputDataConfig.getter(InputDataConfig::dataAccessRoleArn)).setter(InputDataConfig.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, TUNING_DATA_S3_URI_FIELD, DATA_ACCESS_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3Uri;
    private final String tuningDataS3Uri;
    private final String dataAccessRoleArn;

    private InputDataConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.tuningDataS3Uri = builder.tuningDataS3Uri;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
    }

    public String s3Uri() {
        return this.s3Uri;
    }

    public String tuningDataS3Uri() {
        return this.tuningDataS3Uri;
    }

    public String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.tuningDataS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDataConfig)) {
            return false;
        }
        InputDataConfig other = (InputDataConfig)obj;
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.tuningDataS3Uri(), other.tuningDataS3Uri()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn());
    }

    public String toString() {
        return ToString.builder((String)"InputDataConfig").add("S3Uri", (Object)this.s3Uri()).add("TuningDataS3Uri", (Object)this.tuningDataS3Uri()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "TuningDataS3Uri": {
                return Optional.ofNullable(clazz.cast(this.tuningDataS3Uri()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDataConfig, T> g) {
        return obj -> g.apply((InputDataConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Uri;
        private String tuningDataS3Uri;
        private String dataAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDataConfig model) {
            this.s3Uri(model.s3Uri);
            this.tuningDataS3Uri(model.tuningDataS3Uri);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        public final String getTuningDataS3Uri() {
            return this.tuningDataS3Uri;
        }

        @Override
        public final Builder tuningDataS3Uri(String tuningDataS3Uri) {
            this.tuningDataS3Uri = tuningDataS3Uri;
            return this;
        }

        public final void setTuningDataS3Uri(String tuningDataS3Uri) {
            this.tuningDataS3Uri = tuningDataS3Uri;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        public InputDataConfig build() {
            return new InputDataConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputDataConfig> {
        public Builder s3Uri(String var1);

        public Builder tuningDataS3Uri(String var1);

        public Builder dataAccessRoleArn(String var1);
    }
}

