/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.BaseModelName;
import software.amazon.awssdk.services.transcribe.model.CLMLanguageCode;
import software.amazon.awssdk.services.transcribe.model.InputDataConfig;
import software.amazon.awssdk.services.transcribe.model.ModelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LanguageModel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LanguageModel> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LanguageModel.getter(LanguageModel::modelName)).setter(LanguageModel.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(LanguageModel.getter(LanguageModel::createTime)).setter(LanguageModel.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(LanguageModel.getter(LanguageModel::lastModifiedTime)).setter(LanguageModel.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LanguageModel.getter(LanguageModel::languageCodeAsString)).setter(LanguageModel.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> BASE_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LanguageModel.getter(LanguageModel::baseModelNameAsString)).setter(LanguageModel.setter(Builder::baseModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseModelName").build()}).build();
    private static final SdkField<String> MODEL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LanguageModel.getter(LanguageModel::modelStatusAsString)).setter(LanguageModel.setter(Builder::modelStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelStatus").build()}).build();
    private static final SdkField<Boolean> UPGRADE_AVAILABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(LanguageModel.getter(LanguageModel::upgradeAvailability)).setter(LanguageModel.setter(Builder::upgradeAvailability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeAvailability").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LanguageModel.getter(LanguageModel::failureReason)).setter(LanguageModel.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(LanguageModel.getter(LanguageModel::inputDataConfig)).setter(LanguageModel.setter(Builder::inputDataConfig)).constructor(InputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, CREATE_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LANGUAGE_CODE_FIELD, BASE_MODEL_NAME_FIELD, MODEL_STATUS_FIELD, UPGRADE_AVAILABILITY_FIELD, FAILURE_REASON_FIELD, INPUT_DATA_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelName;
    private final Instant createTime;
    private final Instant lastModifiedTime;
    private final String languageCode;
    private final String baseModelName;
    private final String modelStatus;
    private final Boolean upgradeAvailability;
    private final String failureReason;
    private final InputDataConfig inputDataConfig;

    private LanguageModel(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.createTime = builder.createTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.languageCode = builder.languageCode;
        this.baseModelName = builder.baseModelName;
        this.modelStatus = builder.modelStatus;
        this.upgradeAvailability = builder.upgradeAvailability;
        this.failureReason = builder.failureReason;
        this.inputDataConfig = builder.inputDataConfig;
    }

    public String modelName() {
        return this.modelName;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public CLMLanguageCode languageCode() {
        return CLMLanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    public BaseModelName baseModelName() {
        return BaseModelName.fromValue(this.baseModelName);
    }

    public String baseModelNameAsString() {
        return this.baseModelName;
    }

    public ModelStatus modelStatus() {
        return ModelStatus.fromValue(this.modelStatus);
    }

    public String modelStatusAsString() {
        return this.modelStatus;
    }

    public Boolean upgradeAvailability() {
        return this.upgradeAvailability;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public InputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseModelNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeAvailability());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LanguageModel)) {
            return false;
        }
        LanguageModel other = (LanguageModel)obj;
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.baseModelNameAsString(), other.baseModelNameAsString()) && Objects.equals(this.modelStatusAsString(), other.modelStatusAsString()) && Objects.equals(this.upgradeAvailability(), other.upgradeAvailability()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig());
    }

    public String toString() {
        return ToString.builder((String)"LanguageModel").add("ModelName", (Object)this.modelName()).add("CreateTime", (Object)this.createTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LanguageCode", (Object)this.languageCodeAsString()).add("BaseModelName", (Object)this.baseModelNameAsString()).add("ModelStatus", (Object)this.modelStatusAsString()).add("UpgradeAvailability", (Object)this.upgradeAvailability()).add("FailureReason", (Object)this.failureReason()).add("InputDataConfig", (Object)this.inputDataConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "BaseModelName": {
                return Optional.ofNullable(clazz.cast(this.baseModelNameAsString()));
            }
            case "ModelStatus": {
                return Optional.ofNullable(clazz.cast(this.modelStatusAsString()));
            }
            case "UpgradeAvailability": {
                return Optional.ofNullable(clazz.cast(this.upgradeAvailability()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LanguageModel, T> g) {
        return obj -> g.apply((LanguageModel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelName;
        private Instant createTime;
        private Instant lastModifiedTime;
        private String languageCode;
        private String baseModelName;
        private String modelStatus;
        private Boolean upgradeAvailability;
        private String failureReason;
        private InputDataConfig inputDataConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(LanguageModel model) {
            this.modelName(model.modelName);
            this.createTime(model.createTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.languageCode(model.languageCode);
            this.baseModelName(model.baseModelName);
            this.modelStatus(model.modelStatus);
            this.upgradeAvailability(model.upgradeAvailability);
            this.failureReason(model.failureReason);
            this.inputDataConfig(model.inputDataConfig);
        }

        public final String getModelName() {
            return this.modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(CLMLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getBaseModelName() {
            return this.baseModelName;
        }

        @Override
        public final Builder baseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
            return this;
        }

        @Override
        public final Builder baseModelName(BaseModelName baseModelName) {
            this.baseModelName(baseModelName == null ? null : baseModelName.toString());
            return this;
        }

        public final void setBaseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
        }

        public final String getModelStatus() {
            return this.modelStatus;
        }

        @Override
        public final Builder modelStatus(String modelStatus) {
            this.modelStatus = modelStatus;
            return this;
        }

        @Override
        public final Builder modelStatus(ModelStatus modelStatus) {
            this.modelStatus(modelStatus == null ? null : modelStatus.toString());
            return this;
        }

        public final void setModelStatus(String modelStatus) {
            this.modelStatus = modelStatus;
        }

        public final Boolean getUpgradeAvailability() {
            return this.upgradeAvailability;
        }

        @Override
        public final Builder upgradeAvailability(Boolean upgradeAvailability) {
            this.upgradeAvailability = upgradeAvailability;
            return this;
        }

        public final void setUpgradeAvailability(Boolean upgradeAvailability) {
            this.upgradeAvailability = upgradeAvailability;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        public LanguageModel build() {
            return new LanguageModel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LanguageModel> {
        public Builder modelName(String var1);

        public Builder createTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder languageCode(String var1);

        public Builder languageCode(CLMLanguageCode var1);

        public Builder baseModelName(String var1);

        public Builder baseModelName(BaseModelName var1);

        public Builder modelStatus(String var1);

        public Builder modelStatus(ModelStatus var1);

        public Builder upgradeAvailability(Boolean var1);

        public Builder failureReason(String var1);

        public Builder inputDataConfig(InputDataConfig var1);

        default public Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((InputDataConfig)((InputDataConfig.Builder)InputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }
    }
}

