/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.VocabularyFilterMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Settings> {
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(Settings.getter(Settings::vocabularyName)).setter(Settings.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()}).build();
    private static final SdkField<Boolean> SHOW_SPEAKER_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ShowSpeakerLabels").getter(Settings.getter(Settings::showSpeakerLabels)).setter(Settings.setter(Builder::showSpeakerLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowSpeakerLabels").build()}).build();
    private static final SdkField<Integer> MAX_SPEAKER_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxSpeakerLabels").getter(Settings.getter(Settings::maxSpeakerLabels)).setter(Settings.setter(Builder::maxSpeakerLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSpeakerLabels").build()}).build();
    private static final SdkField<Boolean> CHANNEL_IDENTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ChannelIdentification").getter(Settings.getter(Settings::channelIdentification)).setter(Settings.setter(Builder::channelIdentification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelIdentification").build()}).build();
    private static final SdkField<Boolean> SHOW_ALTERNATIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ShowAlternatives").getter(Settings.getter(Settings::showAlternatives)).setter(Settings.setter(Builder::showAlternatives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowAlternatives").build()}).build();
    private static final SdkField<Integer> MAX_ALTERNATIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAlternatives").getter(Settings.getter(Settings::maxAlternatives)).setter(Settings.setter(Builder::maxAlternatives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAlternatives").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterName").getter(Settings.getter(Settings::vocabularyFilterName)).setter(Settings.setter(Builder::vocabularyFilterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterMethod").getter(Settings.getter(Settings::vocabularyFilterMethodAsString)).setter(Settings.setter(Builder::vocabularyFilterMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_NAME_FIELD, SHOW_SPEAKER_LABELS_FIELD, MAX_SPEAKER_LABELS_FIELD, CHANNEL_IDENTIFICATION_FIELD, SHOW_ALTERNATIVES_FIELD, MAX_ALTERNATIVES_FIELD, VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String vocabularyName;
    private final Boolean showSpeakerLabels;
    private final Integer maxSpeakerLabels;
    private final Boolean channelIdentification;
    private final Boolean showAlternatives;
    private final Integer maxAlternatives;
    private final String vocabularyFilterName;
    private final String vocabularyFilterMethod;

    private Settings(BuilderImpl builder) {
        this.vocabularyName = builder.vocabularyName;
        this.showSpeakerLabels = builder.showSpeakerLabels;
        this.maxSpeakerLabels = builder.maxSpeakerLabels;
        this.channelIdentification = builder.channelIdentification;
        this.showAlternatives = builder.showAlternatives;
        this.maxAlternatives = builder.maxAlternatives;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
    }

    public String vocabularyName() {
        return this.vocabularyName;
    }

    public Boolean showSpeakerLabels() {
        return this.showSpeakerLabels;
    }

    public Integer maxSpeakerLabels() {
        return this.maxSpeakerLabels;
    }

    public Boolean channelIdentification() {
        return this.channelIdentification;
    }

    public Boolean showAlternatives() {
        return this.showAlternatives;
    }

    public Integer maxAlternatives() {
        return this.maxAlternatives;
    }

    public String vocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public VocabularyFilterMethod vocabularyFilterMethod() {
        return VocabularyFilterMethod.fromValue(this.vocabularyFilterMethod);
    }

    public String vocabularyFilterMethodAsString() {
        return this.vocabularyFilterMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.showSpeakerLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSpeakerLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelIdentification());
        hashCode = 31 * hashCode + Objects.hashCode(this.showAlternatives());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAlternatives());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterMethodAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Settings)) {
            return false;
        }
        Settings other = (Settings)obj;
        return Objects.equals(this.vocabularyName(), other.vocabularyName()) && Objects.equals(this.showSpeakerLabels(), other.showSpeakerLabels()) && Objects.equals(this.maxSpeakerLabels(), other.maxSpeakerLabels()) && Objects.equals(this.channelIdentification(), other.channelIdentification()) && Objects.equals(this.showAlternatives(), other.showAlternatives()) && Objects.equals(this.maxAlternatives(), other.maxAlternatives()) && Objects.equals(this.vocabularyFilterName(), other.vocabularyFilterName()) && Objects.equals(this.vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString());
    }

    public String toString() {
        return ToString.builder((String)"Settings").add("VocabularyName", (Object)this.vocabularyName()).add("ShowSpeakerLabels", (Object)this.showSpeakerLabels()).add("MaxSpeakerLabels", (Object)this.maxSpeakerLabels()).add("ChannelIdentification", (Object)this.channelIdentification()).add("ShowAlternatives", (Object)this.showAlternatives()).add("MaxAlternatives", (Object)this.maxAlternatives()).add("VocabularyFilterName", (Object)this.vocabularyFilterName()).add("VocabularyFilterMethod", (Object)this.vocabularyFilterMethodAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
            case "ShowSpeakerLabels": {
                return Optional.ofNullable(clazz.cast(this.showSpeakerLabels()));
            }
            case "MaxSpeakerLabels": {
                return Optional.ofNullable(clazz.cast(this.maxSpeakerLabels()));
            }
            case "ChannelIdentification": {
                return Optional.ofNullable(clazz.cast(this.channelIdentification()));
            }
            case "ShowAlternatives": {
                return Optional.ofNullable(clazz.cast(this.showAlternatives()));
            }
            case "MaxAlternatives": {
                return Optional.ofNullable(clazz.cast(this.maxAlternatives()));
            }
            case "VocabularyFilterName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterName()));
            }
            case "VocabularyFilterMethod": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterMethodAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Settings, T> g) {
        return obj -> g.apply((Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vocabularyName;
        private Boolean showSpeakerLabels;
        private Integer maxSpeakerLabels;
        private Boolean channelIdentification;
        private Boolean showAlternatives;
        private Integer maxAlternatives;
        private String vocabularyFilterName;
        private String vocabularyFilterMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(Settings model) {
            this.vocabularyName(model.vocabularyName);
            this.showSpeakerLabels(model.showSpeakerLabels);
            this.maxSpeakerLabels(model.maxSpeakerLabels);
            this.channelIdentification(model.channelIdentification);
            this.showAlternatives(model.showAlternatives);
            this.maxAlternatives(model.maxAlternatives);
            this.vocabularyFilterName(model.vocabularyFilterName);
            this.vocabularyFilterMethod(model.vocabularyFilterMethod);
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        public final Boolean getShowSpeakerLabels() {
            return this.showSpeakerLabels;
        }

        @Override
        public final Builder showSpeakerLabels(Boolean showSpeakerLabels) {
            this.showSpeakerLabels = showSpeakerLabels;
            return this;
        }

        public final void setShowSpeakerLabels(Boolean showSpeakerLabels) {
            this.showSpeakerLabels = showSpeakerLabels;
        }

        public final Integer getMaxSpeakerLabels() {
            return this.maxSpeakerLabels;
        }

        @Override
        public final Builder maxSpeakerLabels(Integer maxSpeakerLabels) {
            this.maxSpeakerLabels = maxSpeakerLabels;
            return this;
        }

        public final void setMaxSpeakerLabels(Integer maxSpeakerLabels) {
            this.maxSpeakerLabels = maxSpeakerLabels;
        }

        public final Boolean getChannelIdentification() {
            return this.channelIdentification;
        }

        @Override
        public final Builder channelIdentification(Boolean channelIdentification) {
            this.channelIdentification = channelIdentification;
            return this;
        }

        public final void setChannelIdentification(Boolean channelIdentification) {
            this.channelIdentification = channelIdentification;
        }

        public final Boolean getShowAlternatives() {
            return this.showAlternatives;
        }

        @Override
        public final Builder showAlternatives(Boolean showAlternatives) {
            this.showAlternatives = showAlternatives;
            return this;
        }

        public final void setShowAlternatives(Boolean showAlternatives) {
            this.showAlternatives = showAlternatives;
        }

        public final Integer getMaxAlternatives() {
            return this.maxAlternatives;
        }

        @Override
        public final Builder maxAlternatives(Integer maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
            return this;
        }

        public final void setMaxAlternatives(Integer maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
        }

        public final String getVocabularyFilterName() {
            return this.vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        public final String getVocabularyFilterMethod() {
            return this.vocabularyFilterMethod;
        }

        @Override
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        public final Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        public Settings build() {
            return new Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Settings> {
        public Builder vocabularyName(String var1);

        public Builder showSpeakerLabels(Boolean var1);

        public Builder maxSpeakerLabels(Integer var1);

        public Builder channelIdentification(Boolean var1);

        public Builder showAlternatives(Boolean var1);

        public Builder maxAlternatives(Integer var1);

        public Builder vocabularyFilterName(String var1);

        public Builder vocabularyFilterMethod(String var1);

        public Builder vocabularyFilterMethod(VocabularyFilterMethod var1);
    }
}

