/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.ContentRedaction;
import software.amazon.awssdk.services.transcribe.model.JobExecutionSettings;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.services.transcribe.model.LanguageOptionsCopier;
import software.amazon.awssdk.services.transcribe.model.Media;
import software.amazon.awssdk.services.transcribe.model.MediaFormat;
import software.amazon.awssdk.services.transcribe.model.ModelSettings;
import software.amazon.awssdk.services.transcribe.model.Settings;
import software.amazon.awssdk.services.transcribe.model.TranscribeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTranscriptionJobRequest
extends TranscribeRequest
implements ToCopyableBuilder<Builder, StartTranscriptionJobRequest> {
    private static final SdkField<String> TRANSCRIPTION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TranscriptionJobName").getter(StartTranscriptionJobRequest.getter(StartTranscriptionJobRequest::transcriptionJobName)).setter(StartTranscriptionJobRequest.setter(Builder::transcriptionJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobName").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(StartTranscriptionJobRequest.getter(StartTranscriptionJobRequest::languageCodeAsString)).setter(StartTranscriptionJobRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MediaSampleRateHertz").getter(StartTranscriptionJobRequest.getter(StartTranscriptionJobRequest::mediaSampleRateHertz)).setter(StartTranscriptionJobRequest.setter(Builder::mediaSampleRateHertz)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaSampleRateHertz").build()}).build();
    private static final SdkField<String> MEDIA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaFormat").getter(StartTranscriptionJobRequest.getter(StartTranscriptionJobRequest::mediaFormatAsString)).setter(StartTranscriptionJobRequest.setter(Builder::mediaFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaFormat").build()}).build();
    private static final SdkField<Media> MEDIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Media").getter(StartTranscriptionJobRequest.getter(StartTranscriptionJobRequest::media)).setter(StartTranscriptionJobRequest.setter(Builder::media)).constructor(Media::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Media").build()}).build();
    private static final SdkField<String> OUTPUT_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputBucketName").getter(StartTranscriptionJobRequest.getter(StartTranscriptionJobRequest::outputBucketName)).setter(StartTranscriptionJobRequest.setter(Builder::outputBucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBucketName").build()}).build();
    private static final SdkField<String> OUTPUT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputKey").getter(StartTranscriptionJobRequest.getter(StartTranscriptionJobRequest::outputKey)).setter(StartTranscriptionJobRequest.setter(Builder::outputKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKey").build()}).build();
    private static final SdkField<String> OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputEncryptionKMSKeyId").getter(StartTranscriptionJobRequest.getter(StartTranscriptionJobRequest::outputEncryptionKMSKeyId)).setter(StartTranscriptionJobRequest.setter(Builder::outputEncryptionKMSKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputEncryptionKMSKeyId").build()}).build();
    private static final SdkField<Settings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(StartTranscriptionJobRequest.getter(StartTranscriptionJobRequest::settings)).setter(StartTranscriptionJobRequest.setter(Builder::settings)).constructor(Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final SdkField<ModelSettings> MODEL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelSettings").getter(StartTranscriptionJobRequest.getter(StartTranscriptionJobRequest::modelSettings)).setter(StartTranscriptionJobRequest.setter(Builder::modelSettings)).constructor(ModelSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelSettings").build()}).build();
    private static final SdkField<JobExecutionSettings> JOB_EXECUTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobExecutionSettings").getter(StartTranscriptionJobRequest.getter(StartTranscriptionJobRequest::jobExecutionSettings)).setter(StartTranscriptionJobRequest.setter(Builder::jobExecutionSettings)).constructor(JobExecutionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobExecutionSettings").build()}).build();
    private static final SdkField<ContentRedaction> CONTENT_REDACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContentRedaction").getter(StartTranscriptionJobRequest.getter(StartTranscriptionJobRequest::contentRedaction)).setter(StartTranscriptionJobRequest.setter(Builder::contentRedaction)).constructor(ContentRedaction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRedaction").build()}).build();
    private static final SdkField<Boolean> IDENTIFY_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IdentifyLanguage").getter(StartTranscriptionJobRequest.getter(StartTranscriptionJobRequest::identifyLanguage)).setter(StartTranscriptionJobRequest.setter(Builder::identifyLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifyLanguage").build()}).build();
    private static final SdkField<List<String>> LANGUAGE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LanguageOptions").getter(StartTranscriptionJobRequest.getter(StartTranscriptionJobRequest::languageOptionsAsStrings)).setter(StartTranscriptionJobRequest.setter(Builder::languageOptionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPTION_JOB_NAME_FIELD, LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_FORMAT_FIELD, MEDIA_FIELD, OUTPUT_BUCKET_NAME_FIELD, OUTPUT_KEY_FIELD, OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD, SETTINGS_FIELD, MODEL_SETTINGS_FIELD, JOB_EXECUTION_SETTINGS_FIELD, CONTENT_REDACTION_FIELD, IDENTIFY_LANGUAGE_FIELD, LANGUAGE_OPTIONS_FIELD));
    private final String transcriptionJobName;
    private final String languageCode;
    private final Integer mediaSampleRateHertz;
    private final String mediaFormat;
    private final Media media;
    private final String outputBucketName;
    private final String outputKey;
    private final String outputEncryptionKMSKeyId;
    private final Settings settings;
    private final ModelSettings modelSettings;
    private final JobExecutionSettings jobExecutionSettings;
    private final ContentRedaction contentRedaction;
    private final Boolean identifyLanguage;
    private final List<String> languageOptions;

    private StartTranscriptionJobRequest(BuilderImpl builder) {
        super(builder);
        this.transcriptionJobName = builder.transcriptionJobName;
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaFormat = builder.mediaFormat;
        this.media = builder.media;
        this.outputBucketName = builder.outputBucketName;
        this.outputKey = builder.outputKey;
        this.outputEncryptionKMSKeyId = builder.outputEncryptionKMSKeyId;
        this.settings = builder.settings;
        this.modelSettings = builder.modelSettings;
        this.jobExecutionSettings = builder.jobExecutionSettings;
        this.contentRedaction = builder.contentRedaction;
        this.identifyLanguage = builder.identifyLanguage;
        this.languageOptions = builder.languageOptions;
    }

    public String transcriptionJobName() {
        return this.transcriptionJobName;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    public Integer mediaSampleRateHertz() {
        return this.mediaSampleRateHertz;
    }

    public MediaFormat mediaFormat() {
        return MediaFormat.fromValue(this.mediaFormat);
    }

    public String mediaFormatAsString() {
        return this.mediaFormat;
    }

    public Media media() {
        return this.media;
    }

    public String outputBucketName() {
        return this.outputBucketName;
    }

    public String outputKey() {
        return this.outputKey;
    }

    public String outputEncryptionKMSKeyId() {
        return this.outputEncryptionKMSKeyId;
    }

    public Settings settings() {
        return this.settings;
    }

    public ModelSettings modelSettings() {
        return this.modelSettings;
    }

    public JobExecutionSettings jobExecutionSettings() {
        return this.jobExecutionSettings;
    }

    public ContentRedaction contentRedaction() {
        return this.contentRedaction;
    }

    public Boolean identifyLanguage() {
        return this.identifyLanguage;
    }

    public List<LanguageCode> languageOptions() {
        return LanguageOptionsCopier.copyStringToEnum(this.languageOptions);
    }

    public boolean hasLanguageOptions() {
        return this.languageOptions != null && !(this.languageOptions instanceof SdkAutoConstructList);
    }

    public List<String> languageOptionsAsStrings() {
        return this.languageOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptionJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.media());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputEncryptionKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobExecutionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentRedaction());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifyLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageOptionsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTranscriptionJobRequest)) {
            return false;
        }
        StartTranscriptionJobRequest other = (StartTranscriptionJobRequest)((Object)obj);
        return Objects.equals(this.transcriptionJobName(), other.transcriptionJobName()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.mediaSampleRateHertz(), other.mediaSampleRateHertz()) && Objects.equals(this.mediaFormatAsString(), other.mediaFormatAsString()) && Objects.equals(this.media(), other.media()) && Objects.equals(this.outputBucketName(), other.outputBucketName()) && Objects.equals(this.outputKey(), other.outputKey()) && Objects.equals(this.outputEncryptionKMSKeyId(), other.outputEncryptionKMSKeyId()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.modelSettings(), other.modelSettings()) && Objects.equals(this.jobExecutionSettings(), other.jobExecutionSettings()) && Objects.equals(this.contentRedaction(), other.contentRedaction()) && Objects.equals(this.identifyLanguage(), other.identifyLanguage()) && Objects.equals(this.languageOptionsAsStrings(), other.languageOptionsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"StartTranscriptionJobRequest").add("TranscriptionJobName", (Object)this.transcriptionJobName()).add("LanguageCode", (Object)this.languageCodeAsString()).add("MediaSampleRateHertz", (Object)this.mediaSampleRateHertz()).add("MediaFormat", (Object)this.mediaFormatAsString()).add("Media", (Object)this.media()).add("OutputBucketName", (Object)this.outputBucketName()).add("OutputKey", (Object)this.outputKey()).add("OutputEncryptionKMSKeyId", (Object)this.outputEncryptionKMSKeyId()).add("Settings", (Object)this.settings()).add("ModelSettings", (Object)this.modelSettings()).add("JobExecutionSettings", (Object)this.jobExecutionSettings()).add("ContentRedaction", (Object)this.contentRedaction()).add("IdentifyLanguage", (Object)this.identifyLanguage()).add("LanguageOptions", this.languageOptionsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TranscriptionJobName": {
                return Optional.ofNullable(clazz.cast(this.transcriptionJobName()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "MediaSampleRateHertz": {
                return Optional.ofNullable(clazz.cast(this.mediaSampleRateHertz()));
            }
            case "MediaFormat": {
                return Optional.ofNullable(clazz.cast(this.mediaFormatAsString()));
            }
            case "Media": {
                return Optional.ofNullable(clazz.cast(this.media()));
            }
            case "OutputBucketName": {
                return Optional.ofNullable(clazz.cast(this.outputBucketName()));
            }
            case "OutputKey": {
                return Optional.ofNullable(clazz.cast(this.outputKey()));
            }
            case "OutputEncryptionKMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.outputEncryptionKMSKeyId()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "ModelSettings": {
                return Optional.ofNullable(clazz.cast(this.modelSettings()));
            }
            case "JobExecutionSettings": {
                return Optional.ofNullable(clazz.cast(this.jobExecutionSettings()));
            }
            case "ContentRedaction": {
                return Optional.ofNullable(clazz.cast(this.contentRedaction()));
            }
            case "IdentifyLanguage": {
                return Optional.ofNullable(clazz.cast(this.identifyLanguage()));
            }
            case "LanguageOptions": {
                return Optional.ofNullable(clazz.cast(this.languageOptionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTranscriptionJobRequest, T> g) {
        return obj -> g.apply((StartTranscriptionJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeRequest.BuilderImpl
    implements Builder {
        private String transcriptionJobName;
        private String languageCode;
        private Integer mediaSampleRateHertz;
        private String mediaFormat;
        private Media media;
        private String outputBucketName;
        private String outputKey;
        private String outputEncryptionKMSKeyId;
        private Settings settings;
        private ModelSettings modelSettings;
        private JobExecutionSettings jobExecutionSettings;
        private ContentRedaction contentRedaction;
        private Boolean identifyLanguage;
        private List<String> languageOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartTranscriptionJobRequest model) {
            super(model);
            this.transcriptionJobName(model.transcriptionJobName);
            this.languageCode(model.languageCode);
            this.mediaSampleRateHertz(model.mediaSampleRateHertz);
            this.mediaFormat(model.mediaFormat);
            this.media(model.media);
            this.outputBucketName(model.outputBucketName);
            this.outputKey(model.outputKey);
            this.outputEncryptionKMSKeyId(model.outputEncryptionKMSKeyId);
            this.settings(model.settings);
            this.modelSettings(model.modelSettings);
            this.jobExecutionSettings(model.jobExecutionSettings);
            this.contentRedaction(model.contentRedaction);
            this.identifyLanguage(model.identifyLanguage);
            this.languageOptionsWithStrings(model.languageOptions);
        }

        public final String getTranscriptionJobName() {
            return this.transcriptionJobName;
        }

        @Override
        public final Builder transcriptionJobName(String transcriptionJobName) {
            this.transcriptionJobName = transcriptionJobName;
            return this;
        }

        public final void setTranscriptionJobName(String transcriptionJobName) {
            this.transcriptionJobName = transcriptionJobName;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Integer getMediaSampleRateHertz() {
            return this.mediaSampleRateHertz;
        }

        @Override
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        public final String getMediaFormat() {
            return this.mediaFormat;
        }

        @Override
        public final Builder mediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
            return this;
        }

        @Override
        public final Builder mediaFormat(MediaFormat mediaFormat) {
            this.mediaFormat(mediaFormat == null ? null : mediaFormat.toString());
            return this;
        }

        public final void setMediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
        }

        public final Media.Builder getMedia() {
            return this.media != null ? this.media.toBuilder() : null;
        }

        @Override
        public final Builder media(Media media) {
            this.media = media;
            return this;
        }

        public final void setMedia(Media.BuilderImpl media) {
            this.media = media != null ? media.build() : null;
        }

        public final String getOutputBucketName() {
            return this.outputBucketName;
        }

        @Override
        public final Builder outputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
            return this;
        }

        public final void setOutputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
        }

        public final String getOutputKey() {
            return this.outputKey;
        }

        @Override
        public final Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public final void setOutputKey(String outputKey) {
            this.outputKey = outputKey;
        }

        public final String getOutputEncryptionKMSKeyId() {
            return this.outputEncryptionKMSKeyId;
        }

        @Override
        public final Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
            return this;
        }

        public final void setOutputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
        }

        public final Settings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(Settings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final ModelSettings.Builder getModelSettings() {
            return this.modelSettings != null ? this.modelSettings.toBuilder() : null;
        }

        @Override
        public final Builder modelSettings(ModelSettings modelSettings) {
            this.modelSettings = modelSettings;
            return this;
        }

        public final void setModelSettings(ModelSettings.BuilderImpl modelSettings) {
            this.modelSettings = modelSettings != null ? modelSettings.build() : null;
        }

        public final JobExecutionSettings.Builder getJobExecutionSettings() {
            return this.jobExecutionSettings != null ? this.jobExecutionSettings.toBuilder() : null;
        }

        @Override
        public final Builder jobExecutionSettings(JobExecutionSettings jobExecutionSettings) {
            this.jobExecutionSettings = jobExecutionSettings;
            return this;
        }

        public final void setJobExecutionSettings(JobExecutionSettings.BuilderImpl jobExecutionSettings) {
            this.jobExecutionSettings = jobExecutionSettings != null ? jobExecutionSettings.build() : null;
        }

        public final ContentRedaction.Builder getContentRedaction() {
            return this.contentRedaction != null ? this.contentRedaction.toBuilder() : null;
        }

        @Override
        public final Builder contentRedaction(ContentRedaction contentRedaction) {
            this.contentRedaction = contentRedaction;
            return this;
        }

        public final void setContentRedaction(ContentRedaction.BuilderImpl contentRedaction) {
            this.contentRedaction = contentRedaction != null ? contentRedaction.build() : null;
        }

        public final Boolean getIdentifyLanguage() {
            return this.identifyLanguage;
        }

        @Override
        public final Builder identifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
            return this;
        }

        public final void setIdentifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
        }

        public final Collection<String> getLanguageOptions() {
            return this.languageOptions;
        }

        @Override
        public final Builder languageOptionsWithStrings(Collection<String> languageOptions) {
            this.languageOptions = LanguageOptionsCopier.copy(languageOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languageOptionsWithStrings(String ... languageOptions) {
            this.languageOptionsWithStrings(Arrays.asList(languageOptions));
            return this;
        }

        @Override
        public final Builder languageOptions(Collection<LanguageCode> languageOptions) {
            this.languageOptions = LanguageOptionsCopier.copyEnumToString(languageOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languageOptions(LanguageCode ... languageOptions) {
            this.languageOptions(Arrays.asList(languageOptions));
            return this;
        }

        public final void setLanguageOptions(Collection<String> languageOptions) {
            this.languageOptions = LanguageOptionsCopier.copy(languageOptions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTranscriptionJobRequest build() {
            return new StartTranscriptionJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranscribeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartTranscriptionJobRequest> {
        public Builder transcriptionJobName(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder mediaSampleRateHertz(Integer var1);

        public Builder mediaFormat(String var1);

        public Builder mediaFormat(MediaFormat var1);

        public Builder media(Media var1);

        default public Builder media(Consumer<Media.Builder> media) {
            return this.media((Media)((Media.Builder)Media.builder().applyMutation(media)).build());
        }

        public Builder outputBucketName(String var1);

        public Builder outputKey(String var1);

        public Builder outputEncryptionKMSKeyId(String var1);

        public Builder settings(Settings var1);

        default public Builder settings(Consumer<Settings.Builder> settings) {
            return this.settings((Settings)((Settings.Builder)Settings.builder().applyMutation(settings)).build());
        }

        public Builder modelSettings(ModelSettings var1);

        default public Builder modelSettings(Consumer<ModelSettings.Builder> modelSettings) {
            return this.modelSettings((ModelSettings)((ModelSettings.Builder)ModelSettings.builder().applyMutation(modelSettings)).build());
        }

        public Builder jobExecutionSettings(JobExecutionSettings var1);

        default public Builder jobExecutionSettings(Consumer<JobExecutionSettings.Builder> jobExecutionSettings) {
            return this.jobExecutionSettings((JobExecutionSettings)((JobExecutionSettings.Builder)JobExecutionSettings.builder().applyMutation(jobExecutionSettings)).build());
        }

        public Builder contentRedaction(ContentRedaction var1);

        default public Builder contentRedaction(Consumer<ContentRedaction.Builder> contentRedaction) {
            return this.contentRedaction((ContentRedaction)((ContentRedaction.Builder)ContentRedaction.builder().applyMutation(contentRedaction)).build());
        }

        public Builder identifyLanguage(Boolean var1);

        public Builder languageOptionsWithStrings(Collection<String> var1);

        public Builder languageOptionsWithStrings(String ... var1);

        public Builder languageOptions(Collection<LanguageCode> var1);

        public Builder languageOptions(LanguageCode ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

