/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.ContentRedaction;
import software.amazon.awssdk.services.transcribe.model.JobExecutionSettings;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.services.transcribe.model.LanguageOptionsCopier;
import software.amazon.awssdk.services.transcribe.model.Media;
import software.amazon.awssdk.services.transcribe.model.MediaFormat;
import software.amazon.awssdk.services.transcribe.model.ModelSettings;
import software.amazon.awssdk.services.transcribe.model.Settings;
import software.amazon.awssdk.services.transcribe.model.Transcript;
import software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TranscriptionJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TranscriptionJob> {
    private static final SdkField<String> TRANSCRIPTION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TranscriptionJobName").getter(TranscriptionJob.getter(TranscriptionJob::transcriptionJobName)).setter(TranscriptionJob.setter(Builder::transcriptionJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobName").build()}).build();
    private static final SdkField<String> TRANSCRIPTION_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TranscriptionJobStatus").getter(TranscriptionJob.getter(TranscriptionJob::transcriptionJobStatusAsString)).setter(TranscriptionJob.setter(Builder::transcriptionJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobStatus").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(TranscriptionJob.getter(TranscriptionJob::languageCodeAsString)).setter(TranscriptionJob.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MediaSampleRateHertz").getter(TranscriptionJob.getter(TranscriptionJob::mediaSampleRateHertz)).setter(TranscriptionJob.setter(Builder::mediaSampleRateHertz)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaSampleRateHertz").build()}).build();
    private static final SdkField<String> MEDIA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaFormat").getter(TranscriptionJob.getter(TranscriptionJob::mediaFormatAsString)).setter(TranscriptionJob.setter(Builder::mediaFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaFormat").build()}).build();
    private static final SdkField<Media> MEDIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Media").getter(TranscriptionJob.getter(TranscriptionJob::media)).setter(TranscriptionJob.setter(Builder::media)).constructor(Media::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Media").build()}).build();
    private static final SdkField<Transcript> TRANSCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Transcript").getter(TranscriptionJob.getter(TranscriptionJob::transcript)).setter(TranscriptionJob.setter(Builder::transcript)).constructor(Transcript::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transcript").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(TranscriptionJob.getter(TranscriptionJob::startTime)).setter(TranscriptionJob.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(TranscriptionJob.getter(TranscriptionJob::creationTime)).setter(TranscriptionJob.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(TranscriptionJob.getter(TranscriptionJob::completionTime)).setter(TranscriptionJob.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(TranscriptionJob.getter(TranscriptionJob::failureReason)).setter(TranscriptionJob.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<Settings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(TranscriptionJob.getter(TranscriptionJob::settings)).setter(TranscriptionJob.setter(Builder::settings)).constructor(Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final SdkField<ModelSettings> MODEL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelSettings").getter(TranscriptionJob.getter(TranscriptionJob::modelSettings)).setter(TranscriptionJob.setter(Builder::modelSettings)).constructor(ModelSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelSettings").build()}).build();
    private static final SdkField<JobExecutionSettings> JOB_EXECUTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobExecutionSettings").getter(TranscriptionJob.getter(TranscriptionJob::jobExecutionSettings)).setter(TranscriptionJob.setter(Builder::jobExecutionSettings)).constructor(JobExecutionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobExecutionSettings").build()}).build();
    private static final SdkField<ContentRedaction> CONTENT_REDACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContentRedaction").getter(TranscriptionJob.getter(TranscriptionJob::contentRedaction)).setter(TranscriptionJob.setter(Builder::contentRedaction)).constructor(ContentRedaction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRedaction").build()}).build();
    private static final SdkField<Boolean> IDENTIFY_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IdentifyLanguage").getter(TranscriptionJob.getter(TranscriptionJob::identifyLanguage)).setter(TranscriptionJob.setter(Builder::identifyLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifyLanguage").build()}).build();
    private static final SdkField<List<String>> LANGUAGE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LanguageOptions").getter(TranscriptionJob.getter(TranscriptionJob::languageOptionsAsStrings)).setter(TranscriptionJob.setter(Builder::languageOptionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Float> IDENTIFIED_LANGUAGE_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("IdentifiedLanguageScore").getter(TranscriptionJob.getter(TranscriptionJob::identifiedLanguageScore)).setter(TranscriptionJob.setter(Builder::identifiedLanguageScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifiedLanguageScore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPTION_JOB_NAME_FIELD, TRANSCRIPTION_JOB_STATUS_FIELD, LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_FORMAT_FIELD, MEDIA_FIELD, TRANSCRIPT_FIELD, START_TIME_FIELD, CREATION_TIME_FIELD, COMPLETION_TIME_FIELD, FAILURE_REASON_FIELD, SETTINGS_FIELD, MODEL_SETTINGS_FIELD, JOB_EXECUTION_SETTINGS_FIELD, CONTENT_REDACTION_FIELD, IDENTIFY_LANGUAGE_FIELD, LANGUAGE_OPTIONS_FIELD, IDENTIFIED_LANGUAGE_SCORE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transcriptionJobName;
    private final String transcriptionJobStatus;
    private final String languageCode;
    private final Integer mediaSampleRateHertz;
    private final String mediaFormat;
    private final Media media;
    private final Transcript transcript;
    private final Instant startTime;
    private final Instant creationTime;
    private final Instant completionTime;
    private final String failureReason;
    private final Settings settings;
    private final ModelSettings modelSettings;
    private final JobExecutionSettings jobExecutionSettings;
    private final ContentRedaction contentRedaction;
    private final Boolean identifyLanguage;
    private final List<String> languageOptions;
    private final Float identifiedLanguageScore;

    private TranscriptionJob(BuilderImpl builder) {
        this.transcriptionJobName = builder.transcriptionJobName;
        this.transcriptionJobStatus = builder.transcriptionJobStatus;
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaFormat = builder.mediaFormat;
        this.media = builder.media;
        this.transcript = builder.transcript;
        this.startTime = builder.startTime;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.failureReason = builder.failureReason;
        this.settings = builder.settings;
        this.modelSettings = builder.modelSettings;
        this.jobExecutionSettings = builder.jobExecutionSettings;
        this.contentRedaction = builder.contentRedaction;
        this.identifyLanguage = builder.identifyLanguage;
        this.languageOptions = builder.languageOptions;
        this.identifiedLanguageScore = builder.identifiedLanguageScore;
    }

    public String transcriptionJobName() {
        return this.transcriptionJobName;
    }

    public TranscriptionJobStatus transcriptionJobStatus() {
        return TranscriptionJobStatus.fromValue(this.transcriptionJobStatus);
    }

    public String transcriptionJobStatusAsString() {
        return this.transcriptionJobStatus;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    public Integer mediaSampleRateHertz() {
        return this.mediaSampleRateHertz;
    }

    public MediaFormat mediaFormat() {
        return MediaFormat.fromValue(this.mediaFormat);
    }

    public String mediaFormatAsString() {
        return this.mediaFormat;
    }

    public Media media() {
        return this.media;
    }

    public Transcript transcript() {
        return this.transcript;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant completionTime() {
        return this.completionTime;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Settings settings() {
        return this.settings;
    }

    public ModelSettings modelSettings() {
        return this.modelSettings;
    }

    public JobExecutionSettings jobExecutionSettings() {
        return this.jobExecutionSettings;
    }

    public ContentRedaction contentRedaction() {
        return this.contentRedaction;
    }

    public Boolean identifyLanguage() {
        return this.identifyLanguage;
    }

    public List<LanguageCode> languageOptions() {
        return LanguageOptionsCopier.copyStringToEnum(this.languageOptions);
    }

    public boolean hasLanguageOptions() {
        return this.languageOptions != null && !(this.languageOptions instanceof SdkAutoConstructList);
    }

    public List<String> languageOptionsAsStrings() {
        return this.languageOptions;
    }

    public Float identifiedLanguageScore() {
        return this.identifiedLanguageScore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptionJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptionJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.media());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcript());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobExecutionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentRedaction());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifyLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageOptionsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifiedLanguageScore());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranscriptionJob)) {
            return false;
        }
        TranscriptionJob other = (TranscriptionJob)obj;
        return Objects.equals(this.transcriptionJobName(), other.transcriptionJobName()) && Objects.equals(this.transcriptionJobStatusAsString(), other.transcriptionJobStatusAsString()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.mediaSampleRateHertz(), other.mediaSampleRateHertz()) && Objects.equals(this.mediaFormatAsString(), other.mediaFormatAsString()) && Objects.equals(this.media(), other.media()) && Objects.equals(this.transcript(), other.transcript()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.modelSettings(), other.modelSettings()) && Objects.equals(this.jobExecutionSettings(), other.jobExecutionSettings()) && Objects.equals(this.contentRedaction(), other.contentRedaction()) && Objects.equals(this.identifyLanguage(), other.identifyLanguage()) && Objects.equals(this.languageOptionsAsStrings(), other.languageOptionsAsStrings()) && Objects.equals(this.identifiedLanguageScore(), other.identifiedLanguageScore());
    }

    public String toString() {
        return ToString.builder((String)"TranscriptionJob").add("TranscriptionJobName", (Object)this.transcriptionJobName()).add("TranscriptionJobStatus", (Object)this.transcriptionJobStatusAsString()).add("LanguageCode", (Object)this.languageCodeAsString()).add("MediaSampleRateHertz", (Object)this.mediaSampleRateHertz()).add("MediaFormat", (Object)this.mediaFormatAsString()).add("Media", (Object)this.media()).add("Transcript", (Object)this.transcript()).add("StartTime", (Object)this.startTime()).add("CreationTime", (Object)this.creationTime()).add("CompletionTime", (Object)this.completionTime()).add("FailureReason", (Object)this.failureReason()).add("Settings", (Object)this.settings()).add("ModelSettings", (Object)this.modelSettings()).add("JobExecutionSettings", (Object)this.jobExecutionSettings()).add("ContentRedaction", (Object)this.contentRedaction()).add("IdentifyLanguage", (Object)this.identifyLanguage()).add("LanguageOptions", this.languageOptionsAsStrings()).add("IdentifiedLanguageScore", (Object)this.identifiedLanguageScore()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TranscriptionJobName": {
                return Optional.ofNullable(clazz.cast(this.transcriptionJobName()));
            }
            case "TranscriptionJobStatus": {
                return Optional.ofNullable(clazz.cast(this.transcriptionJobStatusAsString()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "MediaSampleRateHertz": {
                return Optional.ofNullable(clazz.cast(this.mediaSampleRateHertz()));
            }
            case "MediaFormat": {
                return Optional.ofNullable(clazz.cast(this.mediaFormatAsString()));
            }
            case "Media": {
                return Optional.ofNullable(clazz.cast(this.media()));
            }
            case "Transcript": {
                return Optional.ofNullable(clazz.cast(this.transcript()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "ModelSettings": {
                return Optional.ofNullable(clazz.cast(this.modelSettings()));
            }
            case "JobExecutionSettings": {
                return Optional.ofNullable(clazz.cast(this.jobExecutionSettings()));
            }
            case "ContentRedaction": {
                return Optional.ofNullable(clazz.cast(this.contentRedaction()));
            }
            case "IdentifyLanguage": {
                return Optional.ofNullable(clazz.cast(this.identifyLanguage()));
            }
            case "LanguageOptions": {
                return Optional.ofNullable(clazz.cast(this.languageOptionsAsStrings()));
            }
            case "IdentifiedLanguageScore": {
                return Optional.ofNullable(clazz.cast(this.identifiedLanguageScore()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TranscriptionJob, T> g) {
        return obj -> g.apply((TranscriptionJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transcriptionJobName;
        private String transcriptionJobStatus;
        private String languageCode;
        private Integer mediaSampleRateHertz;
        private String mediaFormat;
        private Media media;
        private Transcript transcript;
        private Instant startTime;
        private Instant creationTime;
        private Instant completionTime;
        private String failureReason;
        private Settings settings;
        private ModelSettings modelSettings;
        private JobExecutionSettings jobExecutionSettings;
        private ContentRedaction contentRedaction;
        private Boolean identifyLanguage;
        private List<String> languageOptions = DefaultSdkAutoConstructList.getInstance();
        private Float identifiedLanguageScore;

        private BuilderImpl() {
        }

        private BuilderImpl(TranscriptionJob model) {
            this.transcriptionJobName(model.transcriptionJobName);
            this.transcriptionJobStatus(model.transcriptionJobStatus);
            this.languageCode(model.languageCode);
            this.mediaSampleRateHertz(model.mediaSampleRateHertz);
            this.mediaFormat(model.mediaFormat);
            this.media(model.media);
            this.transcript(model.transcript);
            this.startTime(model.startTime);
            this.creationTime(model.creationTime);
            this.completionTime(model.completionTime);
            this.failureReason(model.failureReason);
            this.settings(model.settings);
            this.modelSettings(model.modelSettings);
            this.jobExecutionSettings(model.jobExecutionSettings);
            this.contentRedaction(model.contentRedaction);
            this.identifyLanguage(model.identifyLanguage);
            this.languageOptionsWithStrings(model.languageOptions);
            this.identifiedLanguageScore(model.identifiedLanguageScore);
        }

        public final String getTranscriptionJobName() {
            return this.transcriptionJobName;
        }

        @Override
        public final Builder transcriptionJobName(String transcriptionJobName) {
            this.transcriptionJobName = transcriptionJobName;
            return this;
        }

        public final void setTranscriptionJobName(String transcriptionJobName) {
            this.transcriptionJobName = transcriptionJobName;
        }

        public final String getTranscriptionJobStatus() {
            return this.transcriptionJobStatus;
        }

        @Override
        public final Builder transcriptionJobStatus(String transcriptionJobStatus) {
            this.transcriptionJobStatus = transcriptionJobStatus;
            return this;
        }

        @Override
        public final Builder transcriptionJobStatus(TranscriptionJobStatus transcriptionJobStatus) {
            this.transcriptionJobStatus(transcriptionJobStatus == null ? null : transcriptionJobStatus.toString());
            return this;
        }

        public final void setTranscriptionJobStatus(String transcriptionJobStatus) {
            this.transcriptionJobStatus = transcriptionJobStatus;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Integer getMediaSampleRateHertz() {
            return this.mediaSampleRateHertz;
        }

        @Override
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        public final String getMediaFormat() {
            return this.mediaFormat;
        }

        @Override
        public final Builder mediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
            return this;
        }

        @Override
        public final Builder mediaFormat(MediaFormat mediaFormat) {
            this.mediaFormat(mediaFormat == null ? null : mediaFormat.toString());
            return this;
        }

        public final void setMediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
        }

        public final Media.Builder getMedia() {
            return this.media != null ? this.media.toBuilder() : null;
        }

        @Override
        public final Builder media(Media media) {
            this.media = media;
            return this;
        }

        public final void setMedia(Media.BuilderImpl media) {
            this.media = media != null ? media.build() : null;
        }

        public final Transcript.Builder getTranscript() {
            return this.transcript != null ? this.transcript.toBuilder() : null;
        }

        @Override
        public final Builder transcript(Transcript transcript) {
            this.transcript = transcript;
            return this;
        }

        public final void setTranscript(Transcript.BuilderImpl transcript) {
            this.transcript = transcript != null ? transcript.build() : null;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Settings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(Settings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final ModelSettings.Builder getModelSettings() {
            return this.modelSettings != null ? this.modelSettings.toBuilder() : null;
        }

        @Override
        public final Builder modelSettings(ModelSettings modelSettings) {
            this.modelSettings = modelSettings;
            return this;
        }

        public final void setModelSettings(ModelSettings.BuilderImpl modelSettings) {
            this.modelSettings = modelSettings != null ? modelSettings.build() : null;
        }

        public final JobExecutionSettings.Builder getJobExecutionSettings() {
            return this.jobExecutionSettings != null ? this.jobExecutionSettings.toBuilder() : null;
        }

        @Override
        public final Builder jobExecutionSettings(JobExecutionSettings jobExecutionSettings) {
            this.jobExecutionSettings = jobExecutionSettings;
            return this;
        }

        public final void setJobExecutionSettings(JobExecutionSettings.BuilderImpl jobExecutionSettings) {
            this.jobExecutionSettings = jobExecutionSettings != null ? jobExecutionSettings.build() : null;
        }

        public final ContentRedaction.Builder getContentRedaction() {
            return this.contentRedaction != null ? this.contentRedaction.toBuilder() : null;
        }

        @Override
        public final Builder contentRedaction(ContentRedaction contentRedaction) {
            this.contentRedaction = contentRedaction;
            return this;
        }

        public final void setContentRedaction(ContentRedaction.BuilderImpl contentRedaction) {
            this.contentRedaction = contentRedaction != null ? contentRedaction.build() : null;
        }

        public final Boolean getIdentifyLanguage() {
            return this.identifyLanguage;
        }

        @Override
        public final Builder identifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
            return this;
        }

        public final void setIdentifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
        }

        public final Collection<String> getLanguageOptions() {
            return this.languageOptions;
        }

        @Override
        public final Builder languageOptionsWithStrings(Collection<String> languageOptions) {
            this.languageOptions = LanguageOptionsCopier.copy(languageOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languageOptionsWithStrings(String ... languageOptions) {
            this.languageOptionsWithStrings(Arrays.asList(languageOptions));
            return this;
        }

        @Override
        public final Builder languageOptions(Collection<LanguageCode> languageOptions) {
            this.languageOptions = LanguageOptionsCopier.copyEnumToString(languageOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languageOptions(LanguageCode ... languageOptions) {
            this.languageOptions(Arrays.asList(languageOptions));
            return this;
        }

        public final void setLanguageOptions(Collection<String> languageOptions) {
            this.languageOptions = LanguageOptionsCopier.copy(languageOptions);
        }

        public final Float getIdentifiedLanguageScore() {
            return this.identifiedLanguageScore;
        }

        @Override
        public final Builder identifiedLanguageScore(Float identifiedLanguageScore) {
            this.identifiedLanguageScore = identifiedLanguageScore;
            return this;
        }

        public final void setIdentifiedLanguageScore(Float identifiedLanguageScore) {
            this.identifiedLanguageScore = identifiedLanguageScore;
        }

        public TranscriptionJob build() {
            return new TranscriptionJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TranscriptionJob> {
        public Builder transcriptionJobName(String var1);

        public Builder transcriptionJobStatus(String var1);

        public Builder transcriptionJobStatus(TranscriptionJobStatus var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder mediaSampleRateHertz(Integer var1);

        public Builder mediaFormat(String var1);

        public Builder mediaFormat(MediaFormat var1);

        public Builder media(Media var1);

        default public Builder media(Consumer<Media.Builder> media) {
            return this.media((Media)((Media.Builder)Media.builder().applyMutation(media)).build());
        }

        public Builder transcript(Transcript var1);

        default public Builder transcript(Consumer<Transcript.Builder> transcript) {
            return this.transcript((Transcript)((Transcript.Builder)Transcript.builder().applyMutation(transcript)).build());
        }

        public Builder startTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder settings(Settings var1);

        default public Builder settings(Consumer<Settings.Builder> settings) {
            return this.settings((Settings)((Settings.Builder)Settings.builder().applyMutation(settings)).build());
        }

        public Builder modelSettings(ModelSettings var1);

        default public Builder modelSettings(Consumer<ModelSettings.Builder> modelSettings) {
            return this.modelSettings((ModelSettings)((ModelSettings.Builder)ModelSettings.builder().applyMutation(modelSettings)).build());
        }

        public Builder jobExecutionSettings(JobExecutionSettings var1);

        default public Builder jobExecutionSettings(Consumer<JobExecutionSettings.Builder> jobExecutionSettings) {
            return this.jobExecutionSettings((JobExecutionSettings)((JobExecutionSettings.Builder)JobExecutionSettings.builder().applyMutation(jobExecutionSettings)).build());
        }

        public Builder contentRedaction(ContentRedaction var1);

        default public Builder contentRedaction(Consumer<ContentRedaction.Builder> contentRedaction) {
            return this.contentRedaction((ContentRedaction)((ContentRedaction.Builder)ContentRedaction.builder().applyMutation(contentRedaction)).build());
        }

        public Builder identifyLanguage(Boolean var1);

        public Builder languageOptionsWithStrings(Collection<String> var1);

        public Builder languageOptionsWithStrings(String ... var1);

        public Builder languageOptions(Collection<LanguageCode> var1);

        public Builder languageOptions(LanguageCode ... var1);

        public Builder identifiedLanguageScore(Float var1);
    }
}

