/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.TranscribeRequest;
import software.amazon.awssdk.services.transcribe.model.WordsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVocabularyFilterRequest
extends TranscribeRequest
implements ToCopyableBuilder<Builder, UpdateVocabularyFilterRequest> {
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterName").getter(UpdateVocabularyFilterRequest.getter(UpdateVocabularyFilterRequest::vocabularyFilterName)).setter(UpdateVocabularyFilterRequest.setter(Builder::vocabularyFilterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build()}).build();
    private static final SdkField<List<String>> WORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Words").getter(UpdateVocabularyFilterRequest.getter(UpdateVocabularyFilterRequest::words)).setter(UpdateVocabularyFilterRequest.setter(Builder::words)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Words").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_FILE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterFileUri").getter(UpdateVocabularyFilterRequest.getter(UpdateVocabularyFilterRequest::vocabularyFilterFileUri)).setter(UpdateVocabularyFilterRequest.setter(Builder::vocabularyFilterFileUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterFileUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_FILTER_NAME_FIELD, WORDS_FIELD, VOCABULARY_FILTER_FILE_URI_FIELD));
    private final String vocabularyFilterName;
    private final List<String> words;
    private final String vocabularyFilterFileUri;

    private UpdateVocabularyFilterRequest(BuilderImpl builder) {
        super(builder);
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.words = builder.words;
        this.vocabularyFilterFileUri = builder.vocabularyFilterFileUri;
    }

    public String vocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public boolean hasWords() {
        return this.words != null && !(this.words instanceof SdkAutoConstructList);
    }

    public List<String> words() {
        return this.words;
    }

    public String vocabularyFilterFileUri() {
        return this.vocabularyFilterFileUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.words());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterFileUri());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVocabularyFilterRequest)) {
            return false;
        }
        UpdateVocabularyFilterRequest other = (UpdateVocabularyFilterRequest)((Object)obj);
        return Objects.equals(this.vocabularyFilterName(), other.vocabularyFilterName()) && Objects.equals(this.words(), other.words()) && Objects.equals(this.vocabularyFilterFileUri(), other.vocabularyFilterFileUri());
    }

    public String toString() {
        return ToString.builder((String)"UpdateVocabularyFilterRequest").add("VocabularyFilterName", (Object)this.vocabularyFilterName()).add("Words", this.words()).add("VocabularyFilterFileUri", (Object)this.vocabularyFilterFileUri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VocabularyFilterName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterName()));
            }
            case "Words": {
                return Optional.ofNullable(clazz.cast(this.words()));
            }
            case "VocabularyFilterFileUri": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterFileUri()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVocabularyFilterRequest, T> g) {
        return obj -> g.apply((UpdateVocabularyFilterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeRequest.BuilderImpl
    implements Builder {
        private String vocabularyFilterName;
        private List<String> words = DefaultSdkAutoConstructList.getInstance();
        private String vocabularyFilterFileUri;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVocabularyFilterRequest model) {
            super(model);
            this.vocabularyFilterName(model.vocabularyFilterName);
            this.words(model.words);
            this.vocabularyFilterFileUri(model.vocabularyFilterFileUri);
        }

        public final String getVocabularyFilterName() {
            return this.vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        public final Collection<String> getWords() {
            return this.words;
        }

        @Override
        public final Builder words(Collection<String> words) {
            this.words = WordsCopier.copy(words);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder words(String ... words) {
            this.words(Arrays.asList(words));
            return this;
        }

        public final void setWords(Collection<String> words) {
            this.words = WordsCopier.copy(words);
        }

        public final String getVocabularyFilterFileUri() {
            return this.vocabularyFilterFileUri;
        }

        @Override
        public final Builder vocabularyFilterFileUri(String vocabularyFilterFileUri) {
            this.vocabularyFilterFileUri = vocabularyFilterFileUri;
            return this;
        }

        public final void setVocabularyFilterFileUri(String vocabularyFilterFileUri) {
            this.vocabularyFilterFileUri = vocabularyFilterFileUri;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVocabularyFilterRequest build() {
            return new UpdateVocabularyFilterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranscribeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVocabularyFilterRequest> {
        public Builder vocabularyFilterName(String var1);

        public Builder words(Collection<String> var1);

        public Builder words(String ... var1);

        public Builder vocabularyFilterFileUri(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

