/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for content redaction within a transcription job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentRedaction implements SdkPojo, Serializable,
        ToCopyableBuilder<ContentRedaction.Builder, ContentRedaction> {
    private static final SdkField<String> REDACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedactionType").getter(getter(ContentRedaction::redactionTypeAsString))
            .setter(setter(Builder::redactionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedactionType").build()).build();

    private static final SdkField<String> REDACTION_OUTPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedactionOutput").getter(getter(ContentRedaction::redactionOutputAsString))
            .setter(setter(Builder::redactionOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedactionOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDACTION_TYPE_FIELD,
            REDACTION_OUTPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String redactionType;

    private final String redactionOutput;

    private ContentRedaction(BuilderImpl builder) {
        this.redactionType = builder.redactionType;
        this.redactionOutput = builder.redactionOutput;
    }

    /**
     * <p>
     * Request parameter that defines the entities to be redacted. The only accepted value is <code>PII</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #redactionType}
     * will return {@link RedactionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #redactionTypeAsString}.
     * </p>
     * 
     * @return Request parameter that defines the entities to be redacted. The only accepted value is <code>PII</code>.
     * @see RedactionType
     */
    public RedactionType redactionType() {
        return RedactionType.fromValue(redactionType);
    }

    /**
     * <p>
     * Request parameter that defines the entities to be redacted. The only accepted value is <code>PII</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #redactionType}
     * will return {@link RedactionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #redactionTypeAsString}.
     * </p>
     * 
     * @return Request parameter that defines the entities to be redacted. The only accepted value is <code>PII</code>.
     * @see RedactionType
     */
    public String redactionTypeAsString() {
        return redactionType;
    }

    /**
     * <p>
     * The output transcript file stored in either the default S3 bucket or in a bucket you specify.
     * </p>
     * <p>
     * When you choose <code>redacted</code> Amazon Transcribe outputs only the redacted transcript.
     * </p>
     * <p>
     * When you choose <code>redacted_and_unredacted</code> Amazon Transcribe outputs both the redacted and unredacted
     * transcripts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #redactionOutput}
     * will return {@link RedactionOutput#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #redactionOutputAsString}.
     * </p>
     * 
     * @return The output transcript file stored in either the default S3 bucket or in a bucket you specify.</p>
     *         <p>
     *         When you choose <code>redacted</code> Amazon Transcribe outputs only the redacted transcript.
     *         </p>
     *         <p>
     *         When you choose <code>redacted_and_unredacted</code> Amazon Transcribe outputs both the redacted and
     *         unredacted transcripts.
     * @see RedactionOutput
     */
    public RedactionOutput redactionOutput() {
        return RedactionOutput.fromValue(redactionOutput);
    }

    /**
     * <p>
     * The output transcript file stored in either the default S3 bucket or in a bucket you specify.
     * </p>
     * <p>
     * When you choose <code>redacted</code> Amazon Transcribe outputs only the redacted transcript.
     * </p>
     * <p>
     * When you choose <code>redacted_and_unredacted</code> Amazon Transcribe outputs both the redacted and unredacted
     * transcripts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #redactionOutput}
     * will return {@link RedactionOutput#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #redactionOutputAsString}.
     * </p>
     * 
     * @return The output transcript file stored in either the default S3 bucket or in a bucket you specify.</p>
     *         <p>
     *         When you choose <code>redacted</code> Amazon Transcribe outputs only the redacted transcript.
     *         </p>
     *         <p>
     *         When you choose <code>redacted_and_unredacted</code> Amazon Transcribe outputs both the redacted and
     *         unredacted transcripts.
     * @see RedactionOutput
     */
    public String redactionOutputAsString() {
        return redactionOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(redactionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(redactionOutputAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentRedaction)) {
            return false;
        }
        ContentRedaction other = (ContentRedaction) obj;
        return Objects.equals(redactionTypeAsString(), other.redactionTypeAsString())
                && Objects.equals(redactionOutputAsString(), other.redactionOutputAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ContentRedaction").add("RedactionType", redactionTypeAsString())
                .add("RedactionOutput", redactionOutputAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RedactionType":
            return Optional.ofNullable(clazz.cast(redactionTypeAsString()));
        case "RedactionOutput":
            return Optional.ofNullable(clazz.cast(redactionOutputAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContentRedaction, T> g) {
        return obj -> g.apply((ContentRedaction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentRedaction> {
        /**
         * <p>
         * Request parameter that defines the entities to be redacted. The only accepted value is <code>PII</code>.
         * </p>
         * 
         * @param redactionType
         *        Request parameter that defines the entities to be redacted. The only accepted value is
         *        <code>PII</code>.
         * @see RedactionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedactionType
         */
        Builder redactionType(String redactionType);

        /**
         * <p>
         * Request parameter that defines the entities to be redacted. The only accepted value is <code>PII</code>.
         * </p>
         * 
         * @param redactionType
         *        Request parameter that defines the entities to be redacted. The only accepted value is
         *        <code>PII</code>.
         * @see RedactionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedactionType
         */
        Builder redactionType(RedactionType redactionType);

        /**
         * <p>
         * The output transcript file stored in either the default S3 bucket or in a bucket you specify.
         * </p>
         * <p>
         * When you choose <code>redacted</code> Amazon Transcribe outputs only the redacted transcript.
         * </p>
         * <p>
         * When you choose <code>redacted_and_unredacted</code> Amazon Transcribe outputs both the redacted and
         * unredacted transcripts.
         * </p>
         * 
         * @param redactionOutput
         *        The output transcript file stored in either the default S3 bucket or in a bucket you specify.</p>
         *        <p>
         *        When you choose <code>redacted</code> Amazon Transcribe outputs only the redacted transcript.
         *        </p>
         *        <p>
         *        When you choose <code>redacted_and_unredacted</code> Amazon Transcribe outputs both the redacted and
         *        unredacted transcripts.
         * @see RedactionOutput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedactionOutput
         */
        Builder redactionOutput(String redactionOutput);

        /**
         * <p>
         * The output transcript file stored in either the default S3 bucket or in a bucket you specify.
         * </p>
         * <p>
         * When you choose <code>redacted</code> Amazon Transcribe outputs only the redacted transcript.
         * </p>
         * <p>
         * When you choose <code>redacted_and_unredacted</code> Amazon Transcribe outputs both the redacted and
         * unredacted transcripts.
         * </p>
         * 
         * @param redactionOutput
         *        The output transcript file stored in either the default S3 bucket or in a bucket you specify.</p>
         *        <p>
         *        When you choose <code>redacted</code> Amazon Transcribe outputs only the redacted transcript.
         *        </p>
         *        <p>
         *        When you choose <code>redacted_and_unredacted</code> Amazon Transcribe outputs both the redacted and
         *        unredacted transcripts.
         * @see RedactionOutput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedactionOutput
         */
        Builder redactionOutput(RedactionOutput redactionOutput);
    }

    static final class BuilderImpl implements Builder {
        private String redactionType;

        private String redactionOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(ContentRedaction model) {
            redactionType(model.redactionType);
            redactionOutput(model.redactionOutput);
        }

        public final String getRedactionType() {
            return redactionType;
        }

        @Override
        public final Builder redactionType(String redactionType) {
            this.redactionType = redactionType;
            return this;
        }

        @Override
        public final Builder redactionType(RedactionType redactionType) {
            this.redactionType(redactionType == null ? null : redactionType.toString());
            return this;
        }

        public final void setRedactionType(String redactionType) {
            this.redactionType = redactionType;
        }

        public final String getRedactionOutput() {
            return redactionOutput;
        }

        @Override
        public final Builder redactionOutput(String redactionOutput) {
            this.redactionOutput = redactionOutput;
            return this;
        }

        @Override
        public final Builder redactionOutput(RedactionOutput redactionOutput) {
            this.redactionOutput(redactionOutput == null ? null : redactionOutput.toString());
            return this;
        }

        public final void setRedactionOutput(String redactionOutput) {
            this.redactionOutput = redactionOutput;
        }

        @Override
        public ContentRedaction build() {
            return new ContentRedaction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
