/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.ContentRedaction;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.services.transcribe.model.ModelSettings;
import software.amazon.awssdk.services.transcribe.model.OutputLocationType;
import software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TranscriptionJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TranscriptionJobSummary> {
    private static final SdkField<String> TRANSCRIPTION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TranscriptionJobName").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::transcriptionJobName)).setter(TranscriptionJobSummary.setter(Builder::transcriptionJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::creationTime)).setter(TranscriptionJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::startTime)).setter(TranscriptionJobSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::completionTime)).setter(TranscriptionJobSummary.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::languageCodeAsString)).setter(TranscriptionJobSummary.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> TRANSCRIPTION_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TranscriptionJobStatus").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::transcriptionJobStatusAsString)).setter(TranscriptionJobSummary.setter(Builder::transcriptionJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::failureReason)).setter(TranscriptionJobSummary.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> OUTPUT_LOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputLocationType").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::outputLocationTypeAsString)).setter(TranscriptionJobSummary.setter(Builder::outputLocationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocationType").build()}).build();
    private static final SdkField<ContentRedaction> CONTENT_REDACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContentRedaction").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::contentRedaction)).setter(TranscriptionJobSummary.setter(Builder::contentRedaction)).constructor(ContentRedaction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRedaction").build()}).build();
    private static final SdkField<ModelSettings> MODEL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelSettings").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::modelSettings)).setter(TranscriptionJobSummary.setter(Builder::modelSettings)).constructor(ModelSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelSettings").build()}).build();
    private static final SdkField<Boolean> IDENTIFY_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IdentifyLanguage").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::identifyLanguage)).setter(TranscriptionJobSummary.setter(Builder::identifyLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifyLanguage").build()}).build();
    private static final SdkField<Float> IDENTIFIED_LANGUAGE_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("IdentifiedLanguageScore").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::identifiedLanguageScore)).setter(TranscriptionJobSummary.setter(Builder::identifiedLanguageScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifiedLanguageScore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPTION_JOB_NAME_FIELD, CREATION_TIME_FIELD, START_TIME_FIELD, COMPLETION_TIME_FIELD, LANGUAGE_CODE_FIELD, TRANSCRIPTION_JOB_STATUS_FIELD, FAILURE_REASON_FIELD, OUTPUT_LOCATION_TYPE_FIELD, CONTENT_REDACTION_FIELD, MODEL_SETTINGS_FIELD, IDENTIFY_LANGUAGE_FIELD, IDENTIFIED_LANGUAGE_SCORE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transcriptionJobName;
    private final Instant creationTime;
    private final Instant startTime;
    private final Instant completionTime;
    private final String languageCode;
    private final String transcriptionJobStatus;
    private final String failureReason;
    private final String outputLocationType;
    private final ContentRedaction contentRedaction;
    private final ModelSettings modelSettings;
    private final Boolean identifyLanguage;
    private final Float identifiedLanguageScore;

    private TranscriptionJobSummary(BuilderImpl builder) {
        this.transcriptionJobName = builder.transcriptionJobName;
        this.creationTime = builder.creationTime;
        this.startTime = builder.startTime;
        this.completionTime = builder.completionTime;
        this.languageCode = builder.languageCode;
        this.transcriptionJobStatus = builder.transcriptionJobStatus;
        this.failureReason = builder.failureReason;
        this.outputLocationType = builder.outputLocationType;
        this.contentRedaction = builder.contentRedaction;
        this.modelSettings = builder.modelSettings;
        this.identifyLanguage = builder.identifyLanguage;
        this.identifiedLanguageScore = builder.identifiedLanguageScore;
    }

    public String transcriptionJobName() {
        return this.transcriptionJobName;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant completionTime() {
        return this.completionTime;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    public TranscriptionJobStatus transcriptionJobStatus() {
        return TranscriptionJobStatus.fromValue(this.transcriptionJobStatus);
    }

    public String transcriptionJobStatusAsString() {
        return this.transcriptionJobStatus;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public OutputLocationType outputLocationType() {
        return OutputLocationType.fromValue(this.outputLocationType);
    }

    public String outputLocationTypeAsString() {
        return this.outputLocationType;
    }

    public ContentRedaction contentRedaction() {
        return this.contentRedaction;
    }

    public ModelSettings modelSettings() {
        return this.modelSettings;
    }

    public Boolean identifyLanguage() {
        return this.identifyLanguage;
    }

    public Float identifiedLanguageScore() {
        return this.identifiedLanguageScore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptionJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptionJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentRedaction());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifyLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifiedLanguageScore());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranscriptionJobSummary)) {
            return false;
        }
        TranscriptionJobSummary other = (TranscriptionJobSummary)obj;
        return Objects.equals(this.transcriptionJobName(), other.transcriptionJobName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.transcriptionJobStatusAsString(), other.transcriptionJobStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.outputLocationTypeAsString(), other.outputLocationTypeAsString()) && Objects.equals(this.contentRedaction(), other.contentRedaction()) && Objects.equals(this.modelSettings(), other.modelSettings()) && Objects.equals(this.identifyLanguage(), other.identifyLanguage()) && Objects.equals(this.identifiedLanguageScore(), other.identifiedLanguageScore());
    }

    public String toString() {
        return ToString.builder((String)"TranscriptionJobSummary").add("TranscriptionJobName", (Object)this.transcriptionJobName()).add("CreationTime", (Object)this.creationTime()).add("StartTime", (Object)this.startTime()).add("CompletionTime", (Object)this.completionTime()).add("LanguageCode", (Object)this.languageCodeAsString()).add("TranscriptionJobStatus", (Object)this.transcriptionJobStatusAsString()).add("FailureReason", (Object)this.failureReason()).add("OutputLocationType", (Object)this.outputLocationTypeAsString()).add("ContentRedaction", (Object)this.contentRedaction()).add("ModelSettings", (Object)this.modelSettings()).add("IdentifyLanguage", (Object)this.identifyLanguage()).add("IdentifiedLanguageScore", (Object)this.identifiedLanguageScore()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TranscriptionJobName": {
                return Optional.ofNullable(clazz.cast(this.transcriptionJobName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "TranscriptionJobStatus": {
                return Optional.ofNullable(clazz.cast(this.transcriptionJobStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "OutputLocationType": {
                return Optional.ofNullable(clazz.cast(this.outputLocationTypeAsString()));
            }
            case "ContentRedaction": {
                return Optional.ofNullable(clazz.cast(this.contentRedaction()));
            }
            case "ModelSettings": {
                return Optional.ofNullable(clazz.cast(this.modelSettings()));
            }
            case "IdentifyLanguage": {
                return Optional.ofNullable(clazz.cast(this.identifyLanguage()));
            }
            case "IdentifiedLanguageScore": {
                return Optional.ofNullable(clazz.cast(this.identifiedLanguageScore()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TranscriptionJobSummary, T> g) {
        return obj -> g.apply((TranscriptionJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transcriptionJobName;
        private Instant creationTime;
        private Instant startTime;
        private Instant completionTime;
        private String languageCode;
        private String transcriptionJobStatus;
        private String failureReason;
        private String outputLocationType;
        private ContentRedaction contentRedaction;
        private ModelSettings modelSettings;
        private Boolean identifyLanguage;
        private Float identifiedLanguageScore;

        private BuilderImpl() {
        }

        private BuilderImpl(TranscriptionJobSummary model) {
            this.transcriptionJobName(model.transcriptionJobName);
            this.creationTime(model.creationTime);
            this.startTime(model.startTime);
            this.completionTime(model.completionTime);
            this.languageCode(model.languageCode);
            this.transcriptionJobStatus(model.transcriptionJobStatus);
            this.failureReason(model.failureReason);
            this.outputLocationType(model.outputLocationType);
            this.contentRedaction(model.contentRedaction);
            this.modelSettings(model.modelSettings);
            this.identifyLanguage(model.identifyLanguage);
            this.identifiedLanguageScore(model.identifiedLanguageScore);
        }

        public final String getTranscriptionJobName() {
            return this.transcriptionJobName;
        }

        @Override
        public final Builder transcriptionJobName(String transcriptionJobName) {
            this.transcriptionJobName = transcriptionJobName;
            return this;
        }

        public final void setTranscriptionJobName(String transcriptionJobName) {
            this.transcriptionJobName = transcriptionJobName;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getTranscriptionJobStatus() {
            return this.transcriptionJobStatus;
        }

        @Override
        public final Builder transcriptionJobStatus(String transcriptionJobStatus) {
            this.transcriptionJobStatus = transcriptionJobStatus;
            return this;
        }

        @Override
        public final Builder transcriptionJobStatus(TranscriptionJobStatus transcriptionJobStatus) {
            this.transcriptionJobStatus(transcriptionJobStatus == null ? null : transcriptionJobStatus.toString());
            return this;
        }

        public final void setTranscriptionJobStatus(String transcriptionJobStatus) {
            this.transcriptionJobStatus = transcriptionJobStatus;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getOutputLocationType() {
            return this.outputLocationType;
        }

        @Override
        public final Builder outputLocationType(String outputLocationType) {
            this.outputLocationType = outputLocationType;
            return this;
        }

        @Override
        public final Builder outputLocationType(OutputLocationType outputLocationType) {
            this.outputLocationType(outputLocationType == null ? null : outputLocationType.toString());
            return this;
        }

        public final void setOutputLocationType(String outputLocationType) {
            this.outputLocationType = outputLocationType;
        }

        public final ContentRedaction.Builder getContentRedaction() {
            return this.contentRedaction != null ? this.contentRedaction.toBuilder() : null;
        }

        @Override
        public final Builder contentRedaction(ContentRedaction contentRedaction) {
            this.contentRedaction = contentRedaction;
            return this;
        }

        public final void setContentRedaction(ContentRedaction.BuilderImpl contentRedaction) {
            this.contentRedaction = contentRedaction != null ? contentRedaction.build() : null;
        }

        public final ModelSettings.Builder getModelSettings() {
            return this.modelSettings != null ? this.modelSettings.toBuilder() : null;
        }

        @Override
        public final Builder modelSettings(ModelSettings modelSettings) {
            this.modelSettings = modelSettings;
            return this;
        }

        public final void setModelSettings(ModelSettings.BuilderImpl modelSettings) {
            this.modelSettings = modelSettings != null ? modelSettings.build() : null;
        }

        public final Boolean getIdentifyLanguage() {
            return this.identifyLanguage;
        }

        @Override
        public final Builder identifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
            return this;
        }

        public final void setIdentifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
        }

        public final Float getIdentifiedLanguageScore() {
            return this.identifiedLanguageScore;
        }

        @Override
        public final Builder identifiedLanguageScore(Float identifiedLanguageScore) {
            this.identifiedLanguageScore = identifiedLanguageScore;
            return this;
        }

        public final void setIdentifiedLanguageScore(Float identifiedLanguageScore) {
            this.identifiedLanguageScore = identifiedLanguageScore;
        }

        public TranscriptionJobSummary build() {
            return new TranscriptionJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TranscriptionJobSummary> {
        public Builder transcriptionJobName(String var1);

        public Builder creationTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder transcriptionJobStatus(String var1);

        public Builder transcriptionJobStatus(TranscriptionJobStatus var1);

        public Builder failureReason(String var1);

        public Builder outputLocationType(String var1);

        public Builder outputLocationType(OutputLocationType var1);

        public Builder contentRedaction(ContentRedaction var1);

        default public Builder contentRedaction(Consumer<ContentRedaction.Builder> contentRedaction) {
            return this.contentRedaction((ContentRedaction)((ContentRedaction.Builder)ContentRedaction.builder().applyMutation(contentRedaction)).build());
        }

        public Builder modelSettings(ModelSettings var1);

        default public Builder modelSettings(Consumer<ModelSettings.Builder> modelSettings) {
            return this.modelSettings((ModelSettings)((ModelSettings.Builder)ModelSettings.builder().applyMutation(modelSettings)).build());
        }

        public Builder identifyLanguage(Boolean var1);

        public Builder identifiedLanguageScore(Float var1);
    }
}

