/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about when a transcription job should be executed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobExecutionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<JobExecutionSettings.Builder, JobExecutionSettings> {
    private static final SdkField<Boolean> ALLOW_DEFERRED_EXECUTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowDeferredExecution").getter(getter(JobExecutionSettings::allowDeferredExecution))
            .setter(setter(Builder::allowDeferredExecution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowDeferredExecution").build())
            .build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(JobExecutionSettings::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ALLOW_DEFERRED_EXECUTION_FIELD, DATA_ACCESS_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean allowDeferredExecution;

    private final String dataAccessRoleArn;

    private JobExecutionSettings(BuilderImpl builder) {
        this.allowDeferredExecution = builder.allowDeferredExecution;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
    }

    /**
     * <p>
     * Indicates whether a job should be queued by Amazon Transcribe when the concurrent execution limit is exceeded.
     * When the <code>AllowDeferredExecution</code> field is true, jobs are queued and executed when the number of
     * executing jobs falls below the concurrent execution limit. If the field is false, Amazon Transcribe returns a
     * <code>LimitExceededException</code> exception.
     * </p>
     * <p>
     * If you specify the <code>AllowDeferredExecution</code> field, you must specify the <code>DataAccessRoleArn</code>
     * field.
     * </p>
     * 
     * @return Indicates whether a job should be queued by Amazon Transcribe when the concurrent execution limit is
     *         exceeded. When the <code>AllowDeferredExecution</code> field is true, jobs are queued and executed when
     *         the number of executing jobs falls below the concurrent execution limit. If the field is false, Amazon
     *         Transcribe returns a <code>LimitExceededException</code> exception.</p>
     *         <p>
     *         If you specify the <code>AllowDeferredExecution</code> field, you must specify the
     *         <code>DataAccessRoleArn</code> field.
     */
    public Boolean allowDeferredExecution() {
        return allowDeferredExecution;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a role that has access to the S3 bucket that contains the input files. Amazon
     * Transcribe assumes this role to read queued media files. If you have specified an output S3 bucket for the
     * transcription results, this role should have access to the output bucket as well.
     * </p>
     * <p>
     * If you specify the <code>AllowDeferredExecution</code> field, you must specify the <code>DataAccessRoleArn</code>
     * field.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a role that has access to the S3 bucket that contains the input files.
     *         Amazon Transcribe assumes this role to read queued media files. If you have specified an output S3 bucket
     *         for the transcription results, this role should have access to the output bucket as well.</p>
     *         <p>
     *         If you specify the <code>AllowDeferredExecution</code> field, you must specify the
     *         <code>DataAccessRoleArn</code> field.
     */
    public String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowDeferredExecution());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionSettings)) {
            return false;
        }
        JobExecutionSettings other = (JobExecutionSettings) obj;
        return Objects.equals(allowDeferredExecution(), other.allowDeferredExecution())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobExecutionSettings").add("AllowDeferredExecution", allowDeferredExecution())
                .add("DataAccessRoleArn", dataAccessRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowDeferredExecution":
            return Optional.ofNullable(clazz.cast(allowDeferredExecution()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobExecutionSettings, T> g) {
        return obj -> g.apply((JobExecutionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobExecutionSettings> {
        /**
         * <p>
         * Indicates whether a job should be queued by Amazon Transcribe when the concurrent execution limit is
         * exceeded. When the <code>AllowDeferredExecution</code> field is true, jobs are queued and executed when the
         * number of executing jobs falls below the concurrent execution limit. If the field is false, Amazon Transcribe
         * returns a <code>LimitExceededException</code> exception.
         * </p>
         * <p>
         * If you specify the <code>AllowDeferredExecution</code> field, you must specify the
         * <code>DataAccessRoleArn</code> field.
         * </p>
         * 
         * @param allowDeferredExecution
         *        Indicates whether a job should be queued by Amazon Transcribe when the concurrent execution limit is
         *        exceeded. When the <code>AllowDeferredExecution</code> field is true, jobs are queued and executed
         *        when the number of executing jobs falls below the concurrent execution limit. If the field is false,
         *        Amazon Transcribe returns a <code>LimitExceededException</code> exception.</p>
         *        <p>
         *        If you specify the <code>AllowDeferredExecution</code> field, you must specify the
         *        <code>DataAccessRoleArn</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowDeferredExecution(Boolean allowDeferredExecution);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a role that has access to the S3 bucket that contains the input files.
         * Amazon Transcribe assumes this role to read queued media files. If you have specified an output S3 bucket for
         * the transcription results, this role should have access to the output bucket as well.
         * </p>
         * <p>
         * If you specify the <code>AllowDeferredExecution</code> field, you must specify the
         * <code>DataAccessRoleArn</code> field.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of a role that has access to the S3 bucket that contains the input
         *        files. Amazon Transcribe assumes this role to read queued media files. If you have specified an output
         *        S3 bucket for the transcription results, this role should have access to the output bucket as
         *        well.</p>
         *        <p>
         *        If you specify the <code>AllowDeferredExecution</code> field, you must specify the
         *        <code>DataAccessRoleArn</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowDeferredExecution;

        private String dataAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionSettings model) {
            allowDeferredExecution(model.allowDeferredExecution);
            dataAccessRoleArn(model.dataAccessRoleArn);
        }

        public final Boolean getAllowDeferredExecution() {
            return allowDeferredExecution;
        }

        @Override
        public final Builder allowDeferredExecution(Boolean allowDeferredExecution) {
            this.allowDeferredExecution = allowDeferredExecution;
            return this;
        }

        public final void setAllowDeferredExecution(Boolean allowDeferredExecution) {
            this.allowDeferredExecution = allowDeferredExecution;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public JobExecutionSettings build() {
            return new JobExecutionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
