/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object used to call your custom language model to your transcription job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelSettings implements SdkPojo, Serializable, ToCopyableBuilder<ModelSettings.Builder, ModelSettings> {
    private static final SdkField<String> LANGUAGE_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageModelName").getter(getter(ModelSettings::languageModelName))
            .setter(setter(Builder::languageModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageModelName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_MODEL_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String languageModelName;

    private ModelSettings(BuilderImpl builder) {
        this.languageModelName = builder.languageModelName;
    }

    /**
     * <p>
     * The name of your custom language model.
     * </p>
     * 
     * @return The name of your custom language model.
     */
    public String languageModelName() {
        return languageModelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(languageModelName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelSettings)) {
            return false;
        }
        ModelSettings other = (ModelSettings) obj;
        return Objects.equals(languageModelName(), other.languageModelName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModelSettings").add("LanguageModelName", languageModelName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LanguageModelName":
            return Optional.ofNullable(clazz.cast(languageModelName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelSettings, T> g) {
        return obj -> g.apply((ModelSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelSettings> {
        /**
         * <p>
         * The name of your custom language model.
         * </p>
         * 
         * @param languageModelName
         *        The name of your custom language model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageModelName(String languageModelName);
    }

    static final class BuilderImpl implements Builder {
        private String languageModelName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelSettings model) {
            languageModelName(model.languageModelName);
        }

        public final String getLanguageModelName() {
            return languageModelName;
        }

        @Override
        public final Builder languageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
            return this;
        }

        public final void setLanguageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
        }

        @Override
        public ModelSettings build() {
            return new ModelSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
