/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJobSummariesCopier;
import software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJobSummary;
import software.amazon.awssdk.services.transcribe.model.TranscribeResponse;
import software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMedicalTranscriptionJobsResponse
extends TranscribeResponse
implements ToCopyableBuilder<Builder, ListMedicalTranscriptionJobsResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListMedicalTranscriptionJobsResponse.getter(ListMedicalTranscriptionJobsResponse::statusAsString)).setter(ListMedicalTranscriptionJobsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMedicalTranscriptionJobsResponse.getter(ListMedicalTranscriptionJobsResponse::nextToken)).setter(ListMedicalTranscriptionJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<MedicalTranscriptionJobSummary>> MEDICAL_TRANSCRIPTION_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MedicalTranscriptionJobSummaries").getter(ListMedicalTranscriptionJobsResponse.getter(ListMedicalTranscriptionJobsResponse::medicalTranscriptionJobSummaries)).setter(ListMedicalTranscriptionJobsResponse.setter(Builder::medicalTranscriptionJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalTranscriptionJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MedicalTranscriptionJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, NEXT_TOKEN_FIELD, MEDICAL_TRANSCRIPTION_JOB_SUMMARIES_FIELD));
    private final String status;
    private final String nextToken;
    private final List<MedicalTranscriptionJobSummary> medicalTranscriptionJobSummaries;

    private ListMedicalTranscriptionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.medicalTranscriptionJobSummaries = builder.medicalTranscriptionJobSummaries;
    }

    public final TranscriptionJobStatus status() {
        return TranscriptionJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasMedicalTranscriptionJobSummaries() {
        return this.medicalTranscriptionJobSummaries != null && !(this.medicalTranscriptionJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<MedicalTranscriptionJobSummary> medicalTranscriptionJobSummaries() {
        return this.medicalTranscriptionJobSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMedicalTranscriptionJobSummaries() ? this.medicalTranscriptionJobSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMedicalTranscriptionJobsResponse)) {
            return false;
        }
        ListMedicalTranscriptionJobsResponse other = (ListMedicalTranscriptionJobsResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasMedicalTranscriptionJobSummaries() == other.hasMedicalTranscriptionJobSummaries() && Objects.equals(this.medicalTranscriptionJobSummaries(), other.medicalTranscriptionJobSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListMedicalTranscriptionJobsResponse").add("Status", (Object)this.statusAsString()).add("NextToken", (Object)this.nextToken()).add("MedicalTranscriptionJobSummaries", this.hasMedicalTranscriptionJobSummaries() ? this.medicalTranscriptionJobSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MedicalTranscriptionJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.medicalTranscriptionJobSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMedicalTranscriptionJobsResponse, T> g) {
        return obj -> g.apply((ListMedicalTranscriptionJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeResponse.BuilderImpl
    implements Builder {
        private String status;
        private String nextToken;
        private List<MedicalTranscriptionJobSummary> medicalTranscriptionJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMedicalTranscriptionJobsResponse model) {
            super(model);
            this.status(model.status);
            this.nextToken(model.nextToken);
            this.medicalTranscriptionJobSummaries(model.medicalTranscriptionJobSummaries);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TranscriptionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<MedicalTranscriptionJobSummary.Builder> getMedicalTranscriptionJobSummaries() {
            if (this.medicalTranscriptionJobSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.medicalTranscriptionJobSummaries != null ? (Collection)this.medicalTranscriptionJobSummaries.stream().map(MedicalTranscriptionJobSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder medicalTranscriptionJobSummaries(Collection<MedicalTranscriptionJobSummary> medicalTranscriptionJobSummaries) {
            this.medicalTranscriptionJobSummaries = MedicalTranscriptionJobSummariesCopier.copy(medicalTranscriptionJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder medicalTranscriptionJobSummaries(MedicalTranscriptionJobSummary ... medicalTranscriptionJobSummaries) {
            this.medicalTranscriptionJobSummaries(Arrays.asList(medicalTranscriptionJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder medicalTranscriptionJobSummaries(Consumer<MedicalTranscriptionJobSummary.Builder> ... medicalTranscriptionJobSummaries) {
            this.medicalTranscriptionJobSummaries(Stream.of(medicalTranscriptionJobSummaries).map(c -> (MedicalTranscriptionJobSummary)((MedicalTranscriptionJobSummary.Builder)MedicalTranscriptionJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMedicalTranscriptionJobSummaries(Collection<MedicalTranscriptionJobSummary.BuilderImpl> medicalTranscriptionJobSummaries) {
            this.medicalTranscriptionJobSummaries = MedicalTranscriptionJobSummariesCopier.copyFromBuilder(medicalTranscriptionJobSummaries);
        }

        @Override
        public ListMedicalTranscriptionJobsResponse build() {
            return new ListMedicalTranscriptionJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranscribeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMedicalTranscriptionJobsResponse> {
        public Builder status(String var1);

        public Builder status(TranscriptionJobStatus var1);

        public Builder nextToken(String var1);

        public Builder medicalTranscriptionJobSummaries(Collection<MedicalTranscriptionJobSummary> var1);

        public Builder medicalTranscriptionJobSummaries(MedicalTranscriptionJobSummary ... var1);

        public Builder medicalTranscriptionJobSummaries(Consumer<MedicalTranscriptionJobSummary.Builder> ... var1);
    }
}

