/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLanguageModelRequest extends TranscribeRequest implements
        ToCopyableBuilder<CreateLanguageModelRequest.Builder, CreateLanguageModelRequest> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(CreateLanguageModelRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> BASE_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseModelName").getter(getter(CreateLanguageModelRequest::baseModelNameAsString))
            .setter(setter(Builder::baseModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseModelName").build()).build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(CreateLanguageModelRequest::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField
            .<InputDataConfig> builder(MarshallingType.SDK_POJO).memberName("InputDataConfig")
            .getter(getter(CreateLanguageModelRequest::inputDataConfig)).setter(setter(Builder::inputDataConfig))
            .constructor(InputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD,
            BASE_MODEL_NAME_FIELD, MODEL_NAME_FIELD, INPUT_DATA_CONFIG_FIELD));

    private final String languageCode;

    private final String baseModelName;

    private final String modelName;

    private final InputDataConfig inputDataConfig;

    private CreateLanguageModelRequest(BuilderImpl builder) {
        super(builder);
        this.languageCode = builder.languageCode;
        this.baseModelName = builder.baseModelName;
        this.modelName = builder.modelName;
        this.inputDataConfig = builder.inputDataConfig;
    }

    /**
     * <p>
     * The language of the input text you're using to train your custom language model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link CLMLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language of the input text you're using to train your custom language model.
     * @see CLMLanguageCode
     */
    public final CLMLanguageCode languageCode() {
        return CLMLanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language of the input text you're using to train your custom language model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link CLMLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language of the input text you're using to train your custom language model.
     * @see CLMLanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The Amazon Transcribe standard language model, or base model used to create your custom language model.
     * </p>
     * <p>
     * If you want to use your custom language model to transcribe audio with a sample rate of 16 kHz or greater, choose
     * <code>Wideband</code>.
     * </p>
     * <p>
     * If you want to use your custom language model to transcribe audio with a sample rate that is less than 16 kHz,
     * choose <code>Narrowband</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #baseModelName}
     * will return {@link BaseModelName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #baseModelNameAsString}.
     * </p>
     * 
     * @return The Amazon Transcribe standard language model, or base model used to create your custom language
     *         model.</p>
     *         <p>
     *         If you want to use your custom language model to transcribe audio with a sample rate of 16 kHz or
     *         greater, choose <code>Wideband</code>.
     *         </p>
     *         <p>
     *         If you want to use your custom language model to transcribe audio with a sample rate that is less than 16
     *         kHz, choose <code>Narrowband</code>.
     * @see BaseModelName
     */
    public final BaseModelName baseModelName() {
        return BaseModelName.fromValue(baseModelName);
    }

    /**
     * <p>
     * The Amazon Transcribe standard language model, or base model used to create your custom language model.
     * </p>
     * <p>
     * If you want to use your custom language model to transcribe audio with a sample rate of 16 kHz or greater, choose
     * <code>Wideband</code>.
     * </p>
     * <p>
     * If you want to use your custom language model to transcribe audio with a sample rate that is less than 16 kHz,
     * choose <code>Narrowband</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #baseModelName}
     * will return {@link BaseModelName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #baseModelNameAsString}.
     * </p>
     * 
     * @return The Amazon Transcribe standard language model, or base model used to create your custom language
     *         model.</p>
     *         <p>
     *         If you want to use your custom language model to transcribe audio with a sample rate of 16 kHz or
     *         greater, choose <code>Wideband</code>.
     *         </p>
     *         <p>
     *         If you want to use your custom language model to transcribe audio with a sample rate that is less than 16
     *         kHz, choose <code>Narrowband</code>.
     * @see BaseModelName
     */
    public final String baseModelNameAsString() {
        return baseModelName;
    }

    /**
     * <p>
     * The name you choose for your custom language model when you create it.
     * </p>
     * 
     * @return The name you choose for your custom language model when you create it.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * Contains the data access role and the Amazon S3 prefixes to read the required input files to create a custom
     * language model.
     * </p>
     * 
     * @return Contains the data access role and the Amazon S3 prefixes to read the required input files to create a
     *         custom language model.
     */
    public final InputDataConfig inputDataConfig() {
        return inputDataConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(baseModelNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(inputDataConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLanguageModelRequest)) {
            return false;
        }
        CreateLanguageModelRequest other = (CreateLanguageModelRequest) obj;
        return Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(baseModelNameAsString(), other.baseModelNameAsString())
                && Objects.equals(modelName(), other.modelName()) && Objects.equals(inputDataConfig(), other.inputDataConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLanguageModelRequest").add("LanguageCode", languageCodeAsString())
                .add("BaseModelName", baseModelNameAsString()).add("ModelName", modelName())
                .add("InputDataConfig", inputDataConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "BaseModelName":
            return Optional.ofNullable(clazz.cast(baseModelNameAsString()));
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLanguageModelRequest, T> g) {
        return obj -> g.apply((CreateLanguageModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLanguageModelRequest> {
        /**
         * <p>
         * The language of the input text you're using to train your custom language model.
         * </p>
         * 
         * @param languageCode
         *        The language of the input text you're using to train your custom language model.
         * @see CLMLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CLMLanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language of the input text you're using to train your custom language model.
         * </p>
         * 
         * @param languageCode
         *        The language of the input text you're using to train your custom language model.
         * @see CLMLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CLMLanguageCode
         */
        Builder languageCode(CLMLanguageCode languageCode);

        /**
         * <p>
         * The Amazon Transcribe standard language model, or base model used to create your custom language model.
         * </p>
         * <p>
         * If you want to use your custom language model to transcribe audio with a sample rate of 16 kHz or greater,
         * choose <code>Wideband</code>.
         * </p>
         * <p>
         * If you want to use your custom language model to transcribe audio with a sample rate that is less than 16
         * kHz, choose <code>Narrowband</code>.
         * </p>
         * 
         * @param baseModelName
         *        The Amazon Transcribe standard language model, or base model used to create your custom language
         *        model.</p>
         *        <p>
         *        If you want to use your custom language model to transcribe audio with a sample rate of 16 kHz or
         *        greater, choose <code>Wideband</code>.
         *        </p>
         *        <p>
         *        If you want to use your custom language model to transcribe audio with a sample rate that is less than
         *        16 kHz, choose <code>Narrowband</code>.
         * @see BaseModelName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BaseModelName
         */
        Builder baseModelName(String baseModelName);

        /**
         * <p>
         * The Amazon Transcribe standard language model, or base model used to create your custom language model.
         * </p>
         * <p>
         * If you want to use your custom language model to transcribe audio with a sample rate of 16 kHz or greater,
         * choose <code>Wideband</code>.
         * </p>
         * <p>
         * If you want to use your custom language model to transcribe audio with a sample rate that is less than 16
         * kHz, choose <code>Narrowband</code>.
         * </p>
         * 
         * @param baseModelName
         *        The Amazon Transcribe standard language model, or base model used to create your custom language
         *        model.</p>
         *        <p>
         *        If you want to use your custom language model to transcribe audio with a sample rate of 16 kHz or
         *        greater, choose <code>Wideband</code>.
         *        </p>
         *        <p>
         *        If you want to use your custom language model to transcribe audio with a sample rate that is less than
         *        16 kHz, choose <code>Narrowband</code>.
         * @see BaseModelName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BaseModelName
         */
        Builder baseModelName(BaseModelName baseModelName);

        /**
         * <p>
         * The name you choose for your custom language model when you create it.
         * </p>
         * 
         * @param modelName
         *        The name you choose for your custom language model when you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * Contains the data access role and the Amazon S3 prefixes to read the required input files to create a custom
         * language model.
         * </p>
         * 
         * @param inputDataConfig
         *        Contains the data access role and the Amazon S3 prefixes to read the required input files to create a
         *        custom language model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(InputDataConfig inputDataConfig);

        /**
         * <p>
         * Contains the data access role and the Amazon S3 prefixes to read the required input files to create a custom
         * language model.
         * </p>
         * This is a convenience that creates an instance of the {@link InputDataConfig.Builder} avoiding the need to
         * create one manually via {@link InputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDataConfig(InputDataConfig)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link InputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(InputDataConfig)
         */
        default Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return inputDataConfig(InputDataConfig.builder().applyMutation(inputDataConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String languageCode;

        private String baseModelName;

        private String modelName;

        private InputDataConfig inputDataConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLanguageModelRequest model) {
            super(model);
            languageCode(model.languageCode);
            baseModelName(model.baseModelName);
            modelName(model.modelName);
            inputDataConfig(model.inputDataConfig);
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(CLMLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getBaseModelName() {
            return baseModelName;
        }

        @Override
        public final Builder baseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
            return this;
        }

        @Override
        public final Builder baseModelName(BaseModelName baseModelName) {
            this.baseModelName(baseModelName == null ? null : baseModelName.toString());
            return this;
        }

        public final void setBaseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
        }

        public final String getModelName() {
            return modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return inputDataConfig != null ? inputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLanguageModelRequest build() {
            return new CreateLanguageModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
